/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RRD_O14_DISPENSE;
import ca.uhn.hl7v2.model.v251.group.RRD_O14_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRD_O14_ORDER
extends AbstractGroup {
    public RRD_O14_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RRD_O14_TIMING.class, false, true, false);
            this.add(RRD_O14_DISPENSE.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRD_O14_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RRD_O14_TIMING getTIMING() {
        RRD_O14_TIMING retVal = (RRD_O14_TIMING)this.getTyped("TIMING", RRD_O14_TIMING.class);
        return retVal;
    }

    public RRD_O14_TIMING getTIMING(int rep) {
        RRD_O14_TIMING retVal = (RRD_O14_TIMING)this.getTyped("TIMING", rep, RRD_O14_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RRD_O14_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RRD_O14_TIMING.class);
    }

    public void insertTIMING(RRD_O14_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RRD_O14_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RRD_O14_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RRD_O14_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RRD_O14_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RRD_O14_DISPENSE getDISPENSE() {
        RRD_O14_DISPENSE retVal = (RRD_O14_DISPENSE)this.getTyped("DISPENSE", RRD_O14_DISPENSE.class);
        return retVal;
    }
}

