/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RSP_K31_ENCODING;
import ca.uhn.hl7v2.model.v251.group.RSP_K31_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.RSP_K31_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RSP_K31_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.model.v251.segment.RXC;
import ca.uhn.hl7v2.model.v251.segment.RXD;
import ca.uhn.hl7v2.model.v251.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_K31_ORDER
extends AbstractGroup {
    public RSP_K31_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RSP_K31_TIMING.class, false, true, false);
            this.add(RSP_K31_ORDER_DETAIL.class, false, false, false);
            this.add(RSP_K31_ENCODING.class, false, false, false);
            this.add(RXD.class, true, false, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
            this.add(RSP_K31_OBSERVATION.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_K31_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RSP_K31_TIMING getTIMING() {
        RSP_K31_TIMING retVal = (RSP_K31_TIMING)this.getTyped("TIMING", RSP_K31_TIMING.class);
        return retVal;
    }

    public RSP_K31_TIMING getTIMING(int rep) {
        RSP_K31_TIMING retVal = (RSP_K31_TIMING)this.getTyped("TIMING", rep, RSP_K31_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RSP_K31_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RSP_K31_TIMING.class);
    }

    public void insertTIMING(RSP_K31_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RSP_K31_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_K31_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_K31_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_K31_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RSP_K31_ORDER_DETAIL getORDER_DETAIL() {
        RSP_K31_ORDER_DETAIL retVal = (RSP_K31_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RSP_K31_ORDER_DETAIL.class);
        return retVal;
    }

    public RSP_K31_ENCODING getENCODING() {
        RSP_K31_ENCODING retVal = (RSP_K31_ENCODING)this.getTyped("ENCODING", RSP_K31_ENCODING.class);
        return retVal;
    }

    public RXD getRXD() {
        RXD retVal = (RXD)this.getTyped("RXD", RXD.class);
        return retVal;
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = (RXR)this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = (RXC)this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = (RXC)this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public RSP_K31_OBSERVATION getOBSERVATION() {
        RSP_K31_OBSERVATION retVal = (RSP_K31_OBSERVATION)this.getTyped("OBSERVATION", RSP_K31_OBSERVATION.class);
        return retVal;
    }

    public RSP_K31_OBSERVATION getOBSERVATION(int rep) {
        RSP_K31_OBSERVATION retVal = (RSP_K31_OBSERVATION)this.getTyped("OBSERVATION", rep, RSP_K31_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RSP_K31_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RSP_K31_OBSERVATION.class);
    }

    public void insertOBSERVATION(RSP_K31_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RSP_K31_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_K31_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_K31_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_K31_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

