/*
 * Decompiled with CFR 0.152.
 */
package org.monte.iodemo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.monte.media.Buffer;
import org.monte.media.MovieReader;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatDemoMain {
    public static void main(String[] args) {
        File outfile = null;
        ArrayList<File> infiles = new ArrayList<File>();
        try {
            int arg = 32;
            block8: for (int i = 0; i < args.length; ++i) {
                if (args[i].length() > 1 && args[i].charAt(0) == '-') {
                    arg = args[i].charAt(1);
                    continue;
                }
                switch (arg) {
                    case 111: {
                        if (outfile != null) {
                            throw new IllegalArgumentException("error: only one outputfile allowed");
                        }
                        outfile = new File(args[i]);
                        continue block8;
                    }
                    case 105: {
                        infiles.add(new File(args[i]));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("error: illegal option: " + args[i]);
                    }
                }
            }
            if (outfile == null) {
                throw new IllegalArgumentException("error: no outputfile specified");
            }
            if (infiles.size() == 0) {
                throw new IllegalArgumentException("error: no inputfiles specified");
            }
            for (File f : infiles) {
                if (f.exists()) continue;
                throw new IllegalArgumentException("error: inputfile does not exist: " + f);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.err.println("usage: java -jar ConcatDemo.jar [-o outputfile] [-i inputfile ...]");
            String version = ConcatDemoMain.class.getPackage().getImplementationVersion();
            System.err.println("ConcatDemo " + (version == null ? "" : version + " ") + "(c) Werner Randelshofer");
            System.exit(10);
        }
        try {
            ConcatDemoMain.concat(outfile, infiles);
        }
        catch (IOException e) {
            System.err.println("error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void concat(File outfile, ArrayList<File> infiles) throws IOException {
        MovieWriter out = Registry.getInstance().getWriter(outfile);
        if (out == null) {
            throw new IOException("output file format not supported for: " + outfile);
        }
        try {
            int[][] matchingT = new int[infiles.size()][0];
            int imax = infiles.size();
            for (int i = 0; i < imax; ++i) {
                File infile = infiles.get(i);
                MovieReader in = Registry.getInstance().getReader(infile);
                if (in == null) {
                    throw new IOException("input file format not supported for: " + infile);
                }
                try {
                    matchingT[i] = new int[in.getTrackCount()];
                    int jmax = in.getTrackCount();
                    for (int t = 0; t < jmax; ++t) {
                        matchingT[i][t] = -1;
                        int nOutputTracks = out.getTrackCount();
                        for (int outputTrack = 0; outputTrack < nOutputTracks; ++outputTrack) {
                            if (!in.getFormat(t).matches(out.getFormat(outputTrack))) continue;
                            for (int tt = 0; tt < t; ++tt) {
                                if (matchingT[i][tt] != outputTrack) continue;
                            }
                            matchingT[i][t] = outputTrack;
                            break;
                        }
                        if (matchingT[i][t] != -1) continue;
                        matchingT[i][t] = out.getTrackCount();
                        out.addTrack(in.getFormat(t));
                    }
                    continue;
                }
                finally {
                    in.close();
                }
            }
            Buffer buf = new Buffer();
            int imax2 = infiles.size();
            for (int i = 0; i < imax2; ++i) {
                File infile = infiles.get(i);
                MovieReader in = Registry.getInstance().getReader(infile);
                if (in == null) {
                    throw new IOException("input file format not supported for: " + infile);
                }
                try {
                    int t = in.nextTrack();
                    while (t != -1) {
                        in.read(t, buf);
                        out.write(matchingT[i][t], buf);
                        t = in.nextTrack();
                    }
                    continue;
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            out.close();
        }
    }
}

