/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.io.IOException;
import org.monte.media.AbstractMovie;
import org.monte.media.Format;
import org.monte.media.MovieReader;
import org.monte.media.math.Rational;

public class DefaultMovie
extends AbstractMovie {
    private MovieReader reader;
    private Rational playhead;
    private Rational in;
    private Rational out;

    public MovieReader getReader() {
        return this.reader;
    }

    public void setReader(MovieReader reader) {
        this.reader = reader;
        try {
            this.out = reader.getDuration();
        }
        catch (IOException ex) {
            InternalError ie = new InternalError("Can't read duration.");
            ie.initCause(ex);
            throw ie;
        }
        this.playhead = new Rational(0L, 1L);
        this.in = new Rational(0L, 1L);
    }

    public Rational getDuration() {
        try {
            return this.reader.getDuration();
        }
        catch (IOException ex) {
            InternalError ie = new InternalError("Can't read duration.");
            ie.initCause(ex);
            throw ie;
        }
    }

    public Rational getInsertionPoint() {
        return this.playhead;
    }

    public void setInsertionPoint(Rational newValue) {
        Rational oldValue = this.playhead;
        this.playhead = newValue;
        this.firePropertyChange("playhead", oldValue, newValue);
    }

    public Rational getSelectionStart() {
        return this.in;
    }

    public void setSelectionStart(Rational newValue) {
        Rational oldValue = this.in;
        this.in = newValue;
        this.firePropertyChange("in", oldValue, newValue);
    }

    public Rational getSelectionEnd() {
        return this.out;
    }

    public void setSelectionEnd(Rational newValue) {
        Rational oldValue = this.out;
        this.out = newValue;
        this.firePropertyChange("out", oldValue, newValue);
    }

    public long timeToSample(int track, Rational time) {
        try {
            return this.reader.timeToSample(track, time);
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    public Rational sampleToTime(int track, long sample) {
        try {
            return this.reader.sampleToTime(track, sample);
        }
        catch (IOException ex) {
            return new Rational(0L);
        }
    }

    public int getTrackCount() {
        try {
            return this.reader.getTrackCount();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Format getFormat(int track) {
        try {
            return this.reader.getFormat(track);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Format getFileFormat() {
        try {
            return this.reader.getFileFormat();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

