/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.awt.geom.Point2D;
import org.monte.media.AbstractSplineInterpolator;

public class SplineInterpolator
extends AbstractSplineInterpolator {
    private float x1;
    private float y1;
    private float x2;
    private float y2;

    public SplineInterpolator(float x1, float y1, float x2, float y2) {
        this(x1, y1, x2, y2, 1000L);
    }

    public SplineInterpolator(float x1, float y1, float x2, float y2, long timespan) {
        this(x1, y1, x2, y2, false, timespan);
    }

    public SplineInterpolator(float x1, float y1, float x2, float y2, boolean reverse, long timespan) {
        super(reverse ? 1.0f : 0.0f, reverse ? 0.0f : 1.0f, timespan);
        if (x1 < 0.0f || x1 > 1.0f || y1 < 0.0f || y1 > 1.0f || x2 < 0.0f || x2 > 1.0f || y2 < 0.0f || y2 > 1.0f) {
            throw new IllegalArgumentException("Control points must be in the range [0, 1]:");
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.updateFractions(100);
    }

    public Point2D.Float getXY(float t, Point2D.Float p) {
        if (p == null) {
            p = new Point2D.Float();
        }
        float invT = 1.0f - t;
        float b1 = 3.0f * t * (invT * invT);
        float b2 = 3.0f * (t * t) * invT;
        float b3 = t * t * t;
        p.setLocation(b1 * this.x1 + b2 * this.x2 + b3, b1 * this.y1 + b2 * this.y2 + b3);
        return p;
    }

    public float getY(float t) {
        float invT = 1.0f - t;
        float b1 = 3.0f * t * (invT * invT);
        float b2 = 3.0f * (t * t) * invT;
        float b3 = t * t * t;
        return b1 * this.y1 + b2 * this.y2 + b3;
    }
}

