/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.SeekableByteArrayOutputStream;

public class DIBCodec
extends AbstractVideoCodec {
    public DIBCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 4}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 4}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24})});
    }

    public int process(Buffer in, Buffer out) {
        if (this.outputFormat.get(VideoFormatKeys.EncodingKey) == "image") {
            return this.decode(in, out);
        }
        return this.encode(in, out);
    }

    public int decode(Buffer in, Buffer out) {
        int imgType;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.sampleCount = 1;
        BufferedImage img = null;
        switch (this.outputFormat.get(VideoFormatKeys.DepthKey)) {
            case 4: {
                imgType = 13;
                break;
            }
            case 8: {
                imgType = 13;
                break;
            }
            case 24: {
                imgType = 1;
                break;
            }
            default: {
                imgType = 1;
            }
        }
        if (out.data instanceof BufferedImage && ((img = (BufferedImage)out.data).getWidth() != this.outputFormat.get(VideoFormatKeys.WidthKey).intValue() || img.getHeight() != this.outputFormat.get(VideoFormatKeys.HeightKey).intValue() || img.getType() != imgType)) {
            img = null;
        }
        if (img == null) {
            img = new BufferedImage(this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey), imgType);
        }
        out.data = img;
        switch (this.outputFormat.get(VideoFormatKeys.DepthKey)) {
            case 4: {
                this.readKey4((byte[])in.data, in.offset, in.length, img);
                break;
            }
            case 8: {
                this.readKey8((byte[])in.data, in.offset, in.length, img);
                break;
            }
            default: {
                this.readKey24((int[])in.data, in.offset, in.length, img);
            }
        }
        return 0;
    }

    public int encode(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
            out.header = image.getColorModel();
        } else {
            r = new Rectangle(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey));
            scanlineStride = this.outputFormat.get(VideoFormatKeys.WidthKey);
            out.header = null;
        }
        try {
            switch (this.outputFormat.get(VideoFormatKeys.DepthKey)) {
                case 4: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    this.writeKey4(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    this.writeKey8(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    this.writeKey24(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                default: {
                    out.setFlag(BufferFlag.DISCARD);
                    return 0;
                }
            }
            out.setFlag(BufferFlag.KEYFRAME);
            out.data = tmp.getBuffer();
            out.sampleCount = 1;
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    public void readKey4(byte[] in, int offset, int length, BufferedImage img) {
        DataBufferByte buf = (DataBufferByte)img.getRaster().getDataBuffer();
        WritableRaster raster = img.getRaster();
        int scanlineStride = raster.getSampleModel().getWidth();
        Rectangle r = raster.getBounds();
        r.x -= raster.getSampleModelTranslateX();
        r.y -= raster.getSampleModelTranslateY();
        throw new UnsupportedOperationException("readKey4 not yet implemented");
    }

    public void readKey8(byte[] in, int offset, int length, BufferedImage img) {
        DataBufferByte buf = (DataBufferByte)img.getRaster().getDataBuffer();
        WritableRaster raster = img.getRaster();
        int scanlineStride = raster.getSampleModel().getWidth();
        Rectangle r = raster.getBounds();
        r.x -= raster.getSampleModelTranslateX();
        r.y -= raster.getSampleModelTranslateY();
        int h = img.getHeight();
        int w = img.getWidth();
        int i = offset;
        int j = r.x + r.y * scanlineStride + (h - 1) * scanlineStride;
        byte[] out = buf.getData();
        for (int y = 0; y < h; ++y) {
            System.arraycopy(in, i, out, j, w);
            i += w;
            j -= scanlineStride;
        }
    }

    public void readKey24(int[] in, int offset, int length, BufferedImage img) {
        DataBufferInt buf = (DataBufferInt)img.getRaster().getDataBuffer();
        WritableRaster raster = img.getRaster();
        int scanlineStride = raster.getSampleModel().getWidth();
        Rectangle r = raster.getBounds();
        r.x -= raster.getSampleModelTranslateX();
        r.y -= raster.getSampleModelTranslateY();
        int h = img.getHeight();
        int w = img.getWidth();
        int i = offset;
        int j = r.x + r.y * scanlineStride + (h - 1) * scanlineStride;
        int[] out = buf.getData();
        for (int y = 0; y < h; ++y) {
            System.arraycopy(in, i, out, j, w);
            i += w;
            j -= scanlineStride;
        }
    }

    public void writeKey4(OutputStream out, byte[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        byte[] bytes = new byte[width];
        for (int y = (height - 1) * scanlineStride; y >= 0; y -= scanlineStride) {
            int x = offset;
            int xx = 0;
            int n = offset + width;
            while (x < n) {
                bytes[xx] = (byte)((pixels[y + x] & 0xF) << 4 | pixels[y + x + 1] & 0xF);
                x += 2;
                ++xx;
            }
            out.write(bytes);
        }
    }

    public void writeKey8(OutputStream out, byte[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        for (int y = (height - 1) * scanlineStride; y >= 0; y -= scanlineStride) {
            out.write(pixels, y + offset, width);
        }
    }

    public void writeKey24(OutputStream out, int[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        int w3 = width * 3;
        byte[] bytes = new byte[w3];
        for (int xy = (height - 1) * scanlineStride + offset; xy >= offset; xy -= scanlineStride) {
            int x = 0;
            int xp = 0;
            while (x < w3) {
                int p = pixels[xy + xp];
                bytes[x] = (byte)p;
                bytes[x + 1] = (byte)(p >> 8);
                bytes[x + 2] = (byte)(p >> 16);
                x += 3;
                ++xp;
            }
            out.write(bytes);
        }
    }
}

