/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.eightsvx;

import java.io.IOException;
import java.io.OutputStream;
import org.monte.media.eightsvx.JDK10AudioClip;
import org.monte.media.eightsvx.JDK13LongAudioClip;
import org.monte.media.eightsvx.JDK13ShortAudioClip;
import org.monte.media.eightsvx.LoopableAudioClip;

public class EightSVXAudioClip
implements LoopableAudioClip {
    private String name_ = "";
    private String author_ = "";
    private String copyright_ = "";
    private String remark_ = "";
    private byte[] body_;
    private long oneShotHiSamples_;
    private long repeatHiSamples_;
    private long samplesPerHiCycle_;
    private int sampleRate_;
    private int ctOctave_;
    public static final int S_CMP_NONE = 0;
    public static final int S_CMP_FIB_DELTA = 1;
    private int sCompression_;
    private static final double UNITY = 65536.0;
    private int volume_;
    private LoopableAudioClip cachedAudioClip_;
    private int cachedSampleRate_;
    public static final int RIGHT = 4;
    public static final int LEFT = 2;
    public static final int STEREO = 6;
    private int sampleType_;
    private static Boolean javaxAudioIsPresent;
    private static final byte[] CODE_TO_DELTA;
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final int[] exp_lut1;

    protected void setName(String value) {
        this.name_ = value;
    }

    protected String getName() {
        return this.name_;
    }

    protected void setAuthor(String value) {
        this.author_ = value;
    }

    protected String getAuthor() {
        return this.author_;
    }

    protected void setCopyright(String value) {
        this.copyright_ = value;
    }

    protected String getCopyright() {
        return this.copyright_;
    }

    protected void setRemark(String value) {
        this.remark_ = value;
    }

    protected String getRemark() {
        return this.remark_;
    }

    public void set8SVXBody(byte[] value) {
        this.body_ = value;
        this.cachedAudioClip_ = null;
    }

    public byte[] get8SVXBody() {
        return this.body_;
    }

    public void setOneShotHiSamples(long value) {
        this.oneShotHiSamples_ = value;
    }

    public void setRepeatHiSamples(long value) {
        this.repeatHiSamples_ = value;
    }

    public void setSamplesPerHiCycle(long value) {
        this.samplesPerHiCycle_ = value;
    }

    public void setSampleType(int value) {
        this.sampleType_ = value;
    }

    public void setSampleRate(int value) {
        this.sampleRate_ = value;
    }

    public void setCtOctave(int value) {
        this.ctOctave_ = value;
    }

    public void setSCompression(int value) {
        this.sCompression_ = value;
    }

    public void setVolume(int value) {
        this.volume_ = value;
    }

    public long getOneShotHiSamples() {
        return this.oneShotHiSamples_;
    }

    public long getRepeatHiSamples() {
        return this.repeatHiSamples_;
    }

    public long getSamplesPerHiCycle() {
        return this.samplesPerHiCycle_;
    }

    public long getSampleType() {
        return this.sampleType_;
    }

    public int getSampleRate() {
        return this.sampleRate_;
    }

    public int getCtOctave() {
        return this.ctOctave_;
    }

    public int getVolume() {
        return this.volume_;
    }

    public int getSCompression() {
        return this.sCompression_;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getName().length() == 0) {
            buf.append("<unnamed>");
        } else {
            buf.append(this.getName());
        }
        if (this.getAuthor().length() != 0) {
            buf.append(", ");
            buf.append(this.getAuthor());
        }
        if (this.getCopyright().length() != 0) {
            buf.append(", \ufffd ");
            buf.append(this.getCopyright());
        }
        buf.append(' ');
        buf.append(Integer.toString(this.getSampleRate()));
        buf.append(" Hz");
        return buf.toString();
    }

    public LoopableAudioClip createAudioClip() {
        return this.createAudioClip(this.getSampleRate(), this.volume_, 0.0f);
    }

    public LoopableAudioClip createAudioClip(int sampleRate, int volume, float pan) {
        if (javaxAudioIsPresent == null || javaxAudioIsPresent == Boolean.TRUE) {
            try {
                LoopableAudioClip clip = this.createJDK13AudioClip(sampleRate, volume, pan);
                javaxAudioIsPresent = Boolean.TRUE;
                return clip;
            }
            catch (Throwable t) {
                t.printStackTrace();
                javaxAudioIsPresent = Boolean.FALSE;
            }
        }
        return this.createJDK10AudioClip(sampleRate);
    }

    public LoopableAudioClip createJDK13AudioClip(int sampleRate, int volume, float pan) {
        byte[] samples;
        Object audioClip = null;
        if (this.sCompression_ == 1) {
            this.body_ = EightSVXAudioClip.unpackFibonacciDeltaCompression(this.body_);
            this.sCompression_ = 0;
        }
        if (this.sampleType_ == 6) {
            double volumeCorrection = EightSVXAudioClip.computeStereoVolumeCorrection(this.body_);
            this.body_ = EightSVXAudioClip.linear8StereoToMono(this.body_, volumeCorrection);
            this.sampleType_ = 2;
        }
        if ((samples = this.get8SVXBody()).length > 1000000) {
            return new JDK13LongAudioClip(samples, sampleRate, volume, pan);
        }
        return new JDK13ShortAudioClip(samples, sampleRate, volume, pan);
    }

    public LoopableAudioClip createJDK10AudioClip(int sampleRate) {
        Object audioClip = null;
        if (this.sCompression_ == 1) {
            this.body_ = EightSVXAudioClip.unpackFibonacciDeltaCompression(this.body_);
            this.sCompression_ = 0;
        }
        if (this.sampleType_ == 6) {
            double volumeCorrection = EightSVXAudioClip.computeStereoVolumeCorrection(this.body_);
            this.body_ = EightSVXAudioClip.linear8StereoToMono(this.body_, volumeCorrection);
            this.sampleType_ = 2;
        }
        byte[] samples = this.get8SVXBody();
        samples = EightSVXAudioClip.resample(samples, sampleRate, 8000);
        samples = EightSVXAudioClip.linear8ToULaw(samples);
        return new JDK10AudioClip(samples, 8000);
    }

    public void play() {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.play();
    }

    public void loop() {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.loop();
    }

    public void stop() {
        if (this.cachedAudioClip_ != null) {
            this.cachedAudioClip_.stop();
        }
    }

    public void prepare() {
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
    }

    public static double computeStereoVolumeCorrection(byte[] stereo) {
        int half = stereo.length / 2;
        int max = 0;
        for (int i = 0; i < half; ++i) {
            max = Math.max(max, Math.abs(stereo[i] + stereo[half + i]));
        }
        if (max < 128) {
            return 1.0;
        }
        return 128.0 / (double)max;
    }

    public static byte[] linear8StereoToMono(byte[] stereo, double volumeCorrection) {
        int half = stereo.length / 2;
        byte[] mono = new byte[half];
        for (int i = 0; i < half; ++i) {
            mono[i] = (byte)((double)(stereo[i] + stereo[half + i]) * volumeCorrection);
        }
        return mono;
    }

    public static byte[] resample(byte[] input, int inputSampleRate, int outputSampleRate) {
        if (inputSampleRate == outputSampleRate) {
            return input;
        }
        if (inputSampleRate > outputSampleRate) {
            float factor = (float)inputSampleRate / (float)outputSampleRate;
            byte[] output = new byte[(int)Math.floor((float)input.length / factor)];
            for (int i = 0; i < output.length; ++i) {
                output[i] = input[(int)((float)i * factor)];
            }
            return output;
        }
        float factor = (float)inputSampleRate / (float)outputSampleRate;
        byte[] output = new byte[(int)Math.ceil((float)input.length / factor)];
        for (int i = 0; i < output.length; ++i) {
            output[i] = input[(int)((float)i * factor)];
        }
        return output;
    }

    public static byte[] linear8ToULaw(byte[] linear8) {
        byte[] ulaw = new byte[linear8.length];
        for (int i = 0; i < linear8.length; ++i) {
            ulaw[i] = EightSVXAudioClip.linear16ToULaw(linear8[i] << 8);
        }
        return ulaw;
    }

    public static byte[] linear16ToULaw(int[] linear16) {
        byte[] ulaw = new byte[linear16.length];
        for (int i = 0; i < linear16.length; ++i) {
            ulaw[i] = EightSVXAudioClip.linear16ToULaw(linear16[i]);
        }
        return ulaw;
    }

    public static byte[] unpackFibonacciDeltaCompression(byte[] source) {
        int n = source.length - 2;
        int lim = n * 2;
        byte[] dest = new byte[lim];
        int x = source[1];
        int i = 0;
        for (int j = 2; j < n; ++j) {
            byte d = source[j];
            dest[i++] = (byte)(x += CODE_TO_DELTA[d >> 4 & 0xF]);
            dest[i++] = (byte)(x += CODE_TO_DELTA[d & 0xF]);
        }
        return dest;
    }

    public static void writeSunAudioHeader(OutputStream outfile, int dataSize, int sampleRate, int sampleType) throws IOException {
        EightSVXAudioClip.wrulong(outfile, 779316836);
        EightSVXAudioClip.wrulong(outfile, 24);
        EightSVXAudioClip.wrulong(outfile, dataSize);
        EightSVXAudioClip.wrulong(outfile, 1);
        EightSVXAudioClip.wrulong(outfile, sampleRate);
        EightSVXAudioClip.wrulong(outfile, sampleType == 6 ? 2 : 1);
    }

    public static void wrulong(OutputStream outfile, int ulong) throws IOException {
        outfile.write(ulong >> 24 & 0xFF);
        outfile.write(ulong >> 16 & 0xFF);
        outfile.write(ulong >> 8 & 0xFF);
        outfile.write(ulong >> 0 & 0xFF);
    }

    private static byte linear16ToULaw(int sample) {
        int mantissa;
        int exponent;
        int ulawbyte;
        if (sample > Short.MAX_VALUE) {
            sample = Short.MAX_VALUE;
        } else if (sample < Short.MIN_VALUE) {
            sample = Short.MIN_VALUE;
        }
        int sign = sample >> 8 & 0x80;
        if (sign != 0) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = 32635;
        }
        if ((ulawbyte = ~(sign | (exponent = exp_lut1[(sample += 132) >> 7 & 0xFF]) << 4 | (mantissa = sample >> exponent + 3 & 0xF))) == 0) {
            ulawbyte = 2;
        }
        return (byte)ulawbyte;
    }

    public void loop(int count) {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.loop(count);
    }

    static {
        CODE_TO_DELTA = new byte[]{-34, -21, -13, -8, -5, -3, -2, -1, 0, 1, 2, 3, 5, 8, 13, 21};
        exp_lut1 = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    }
}

