/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.monte.media.gui.datatransfer.AbstractTransferable;

public class PlainTextTransferable
extends AbstractTransferable {
    private String plainText;

    public PlainTextTransferable(String plainText) {
        this(PlainTextTransferable.getDefaultFlavors(), plainText);
    }

    public PlainTextTransferable(DataFlavor flavor, String plainText) {
        this(new DataFlavor[]{flavor}, plainText);
    }

    public PlainTextTransferable(DataFlavor[] flavors, String plainText) {
        super(flavors);
        this.plainText = plainText;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        String string = this.plainText = this.plainText == null ? "" : this.plainText;
        if (String.class.equals(flavor.getRepresentationClass())) {
            return this.plainText;
        }
        if (Reader.class.equals(flavor.getRepresentationClass())) {
            return new StringReader(this.plainText);
        }
        if (InputStream.class.equals(flavor.getRepresentationClass())) {
            String charsetName = flavor.getParameter("charset");
            return new ByteArrayInputStream(this.plainText.getBytes(charsetName == null ? "UTF-8" : charsetName));
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected static DataFlavor[] getDefaultFlavors() {
        try {
            return new DataFlavor[]{new DataFlavor("text/plain;class=java.lang.String"), new DataFlavor("text/plain;class=java.io.Reader"), new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream")};
        }
        catch (ClassNotFoundException cle) {
            InternalError ie = new InternalError("error initializing PlainTextTransferable");
            ie.initCause(cle);
            throw ie;
        }
    }
}

