/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.imgseq;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Codec;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieWriter;
import org.monte.media.VideoFormatKeys;
import org.monte.media.jpeg.JPEGCodec;
import org.monte.media.math.Rational;
import org.monte.media.png.PNGCodec;

public class ImageSequenceWriter
implements MovieWriter {
    private Format fileFormat = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE});
    private ArrayList<VideoTrack> tracks = new ArrayList();

    public int addTrack(Format format) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Format getFileFormat() throws IOException {
        return this.fileFormat;
    }

    public int getTrackCount() {
        return 1;
    }

    public Format getFormat(int track) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int addVideoTrack(File dir, String filenameFormatter, int width, int height) {
        Format fmt = filenameFormatter.toLowerCase().endsWith(".png") ? new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, 24}) : new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "jpeg", VideoFormatKeys.WidthKey, width, VideoFormatKeys.HeightKey, height, VideoFormatKeys.DepthKey, 24});
        VideoTrack t = new VideoTrack(dir, filenameFormatter, fmt, null, width, height);
        this.tracks.add(t);
        this.createCodec(t);
        return this.tracks.size() - 1;
    }

    private void createCodec(VideoTrack vt) {
        Format fmt = vt.videoFormat;
        String enc = (String)fmt.get(VideoFormatKeys.EncodingKey);
        if (enc.equals("MJPG") || enc.equals("jpeg")) {
            vt.codec = new JPEGCodec();
        } else if (enc.equals("png ") || enc.equals("png ")) {
            vt.codec = new PNGCodec();
        }
        vt.codec.setInputFormat(fmt.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class}));
        vt.codec.setOutputFormat(fmt.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, enc, VideoFormatKeys.DataClassKey, byte[].class}));
    }

    public void write(int track, BufferedImage image, long duration) throws IOException {
        VideoTrack t = this.tracks.get(track);
        if (t.inputBuffer == null) {
            t.inputBuffer = new Buffer();
        }
        if (t.outputBuffer == null) {
            t.outputBuffer = new Buffer();
        }
        t.inputBuffer.setFlagsTo(BufferFlag.KEYFRAME);
        t.inputBuffer.data = image;
        t.codec.process(t.inputBuffer, t.outputBuffer);
        this.write(track, t.outputBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int track, Buffer buf) throws IOException {
        VideoTrack t;
        block13: {
            t = this.tracks.get(track);
            if (buf.isFlag(BufferFlag.DISCARD)) {
                return;
            }
            File file = new File(t.dir, String.format(t.nameFormat, t.count + 1));
            if (buf.data instanceof byte[]) {
                FileOutputStream out = new FileOutputStream(file);
                try {
                    out.write((byte[])buf.data, buf.offset, buf.length);
                }
                finally {
                    out.close();
                }
            }
            if (buf.data instanceof File) {
                FileInputStream in = new FileInputStream((File)buf.data);
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int len;
                        byte[] b = new byte[2048];
                        while ((len = in.read(b)) != -1) {
                            out.write(b, 0, len);
                        }
                        break block13;
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
            throw new IllegalArgumentException("Can't process buffer data:" + buf.data);
        }
        ++t.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSample(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        VideoTrack t = this.tracks.get(track);
        File file = new File(t.dir, String.format(t.nameFormat, t.count + 1));
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(data, off, len);
        }
        finally {
            out.close();
        }
        ++t.count;
    }

    public void writeSamples(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        for (int i = 0; i < sampleCount; ++i) {
            this.writeSample(track, data, off, len / sampleCount, sampleDuration, isSync);
            off += len / sampleCount;
        }
    }

    public void close() throws IOException {
    }

    public boolean isVFRSupported() {
        return false;
    }

    public boolean isDataLimitReached() {
        return false;
    }

    public Rational getDuration(int track) {
        VideoTrack tr = this.tracks.get(track);
        return new Rational(tr.count, 30L);
    }

    public boolean isEmpty(int track) {
        return this.tracks.get((int)track).count == 0;
    }

    private class VideoTrack {
        Format videoFormat;
        File dir;
        String nameFormat;
        int count;
        Codec codec;
        Buffer inputBuffer;
        Buffer outputBuffer;
        int width;
        int height;

        public VideoTrack(File dir, String filenameFormatter, Format fmt, Codec codec, int width, int height) {
            this.dir = dir;
            this.nameFormat = filenameFormatter;
            this.videoFormat = fmt;
            this.codec = codec;
            this.width = width;
            this.height = height;
        }
    }
}

