/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.mpo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.monte.media.gui.Worker;
import org.monte.media.mpo.MPOFiles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPOImageSplitter
extends JPanel {
    private Handler handler = new Handler();
    private JLabel label;

    public MPOImageSplitter() {
        this.initComponents();
        new DropTarget(this, this.handler);
        new DropTarget(this.label, this.handler);
    }

    public void splitMPOFiles(final List<File> files) {
        this.label.setEnabled(false);
        new Worker(){

            protected Object construct() throws Exception {
                for (File f : files) {
                    MPOFiles.splitMPOFile(f);
                }
                return null;
            }

            protected void finished() {
                MPOImageSplitter.this.label.setEnabled(true);
            }
        }.start();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        this.label.setHorizontalAlignment(0);
        this.label.setText("Drop MPO file here.");
        this.add((Component)this.label, "Center");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame f = new JFrame("MPO Image Splitter");
                f.setDefaultCloseOperation(3);
                f.add(new MPOImageSplitter());
                f.setSize(200, 200);
                f.setVisible(true);
            }
        });
    }

    private class Handler
    implements DropTargetListener {
        private Handler() {
        }

        public void dragEnter(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent event) {
        }

        public void dragOver(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        public void drop(DropTargetDropEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                try {
                    List files = (List)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    MPOImageSplitter.this.splitMPOFiles(files);
                }
                catch (IOException e) {
                    JOptionPane.showConfirmDialog(MPOImageSplitter.this, "Could not access the dropped data.", "MPOImageSplitter: Drop Failed", -1, 1);
                }
                catch (UnsupportedFlavorException e) {
                    JOptionPane.showConfirmDialog(MPOImageSplitter.this, "Unsupported data flavor.", "MPOImageSplitter: Drop Failed", -1, 1);
                }
            } else {
                event.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

