/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.seq;

import java.applet.AudioClip;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.monte.media.ilbm.ColorCycle;
import org.monte.media.seq.SEQAudioCommand;
import org.monte.media.seq.SEQFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEQMovieTrack {
    private int width;
    private int height;
    private int xPosition;
    private int yPosition;
    private int nbPlanes;
    private int nbPalettes_ = -1;
    private int masking;
    public static final int MSK_NONE = 0;
    public static final int MSK_HAS_MASK = 1;
    public static final int MSK_HAS_TRANSPARENT_COLOR = 2;
    public static final int MSK_LASSO = 3;
    private int transparentColor;
    private int xAspect;
    private int yAspect;
    private int pageWidth;
    private int pageHeight;
    private int screenMode;
    private int jiffies;
    private final boolean isPlayWrapupFrames = true;
    private boolean isSwapSpeakers = false;
    public static final int MODE_INDEXED_COLORS = 0;
    public static final int MODE_DIRECT_COLORS = 1;
    public static final int MODE_EHB = 2;
    public static final int MODE_HAM6 = 3;
    public static final int MODE_HAM8 = 4;
    private int compression_;
    public static final int CMP_NONE = 0;
    public static final int CMP_BYTE_RUN_1 = 1;
    public static final int CMP_VERTICAL = 2;
    private long totalDuration_;
    private Hashtable properties_ = new Hashtable();
    private Vector frames_ = new Vector();
    private Vector audioClips_ = new Vector();
    private PropertyChangeSupport listeners_ = new PropertyChangeSupport(this);
    private ArrayList<ColorCycle> colorCycles = new ArrayList();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners_.removePropertyChangeListener(listener);
    }

    public void setProperty(String name, Object newValue) {
        Object oldValue = this.properties_.get(name);
        if (newValue == null) {
            this.properties_.remove(name);
        } else {
            this.properties_.put(name, newValue);
        }
        this.listeners_.firePropertyChange(name, oldValue, newValue);
    }

    public boolean isPlayWrapupFrames() {
        return true;
    }

    public int getInterleave() {
        return this.frames_.size() > 0 && ((SEQFrame)this.frames_.get(this.frames_.size() - 1)).getInterleave() == 1 ? 1 : 2;
    }

    public void setSwapSpeakers(boolean newValue) {
        boolean oldValue = this.isSwapSpeakers;
        this.isSwapSpeakers = newValue;
        if (newValue != oldValue) {
            Enumeration i = this.frames_.elements();
            while (i.hasMoreElements()) {
                SEQAudioCommand[] aac = ((SEQFrame)i.nextElement()).getAudioCommands();
                if (aac == null) continue;
                for (int j = 0; j < aac.length; ++j) {
                    aac[j].dispose();
                }
            }
        }
    }

    public boolean isSwapSpeakers() {
        return this.isSwapSpeakers;
    }

    public Object getProperty(String name) {
        return this.properties_.get(name);
    }

    private void firePropertyChange(String name, int oldValue, int newValue) {
        this.listeners_.firePropertyChange(name, new Integer(oldValue), new Integer(newValue));
    }

    public void setJiffies(int newValue) {
        int oldValue = this.jiffies;
        this.jiffies = newValue;
        this.firePropertyChange("jiffies", oldValue, newValue);
    }

    public void setCompression(int newValue) {
        int oldValue = this.compression_;
        this.compression_ = newValue;
        this.firePropertyChange("compression", oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setXPosition(int newValue) {
        int oldValue = this.xPosition;
        this.xPosition = newValue;
        this.firePropertyChange("xPosition", oldValue, newValue);
    }

    public void setYPosition(int newValue) {
        int oldValue = this.yPosition;
        this.yPosition = newValue;
        this.firePropertyChange("yPosition", oldValue, newValue);
    }

    public void setNbPlanes(int newValue) {
        int oldValue = this.nbPlanes;
        this.nbPlanes = newValue;
        this.firePropertyChange("nbPlanes", oldValue, newValue);
    }

    public void setMasking(int newValue) {
        int oldValue = this.masking;
        this.masking = newValue;
        this.firePropertyChange("masking", oldValue, newValue);
    }

    public void setTransparentColor(int newValue) {
        int oldValue = this.transparentColor;
        this.transparentColor = newValue;
        this.firePropertyChange("transparentColor", oldValue, newValue);
    }

    public void setXAspect(int newValue) {
        int oldValue = this.xAspect;
        this.xAspect = newValue;
        this.firePropertyChange("xAspect", oldValue, newValue);
    }

    public void setYAspect(int newValue) {
        int oldValue = this.yAspect;
        this.yAspect = newValue;
        this.firePropertyChange("yAspect", oldValue, newValue);
    }

    public void setPageWidth(int newValue) {
        int oldValue = this.pageWidth;
        this.pageWidth = newValue;
        this.firePropertyChange("pageWidth", oldValue, newValue);
    }

    public void setPageHeight(int newValue) {
        int oldValue = this.pageHeight;
        this.pageHeight = newValue;
        this.firePropertyChange("pageHeight", oldValue, newValue);
    }

    public void setScreenMode(int newValue) {
        int oldValue = this.screenMode;
        this.screenMode = newValue;
        this.firePropertyChange("screenMode", oldValue, newValue);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public int getNbPlanes() {
        return this.nbPlanes;
    }

    public int getNbPalettes() {
        block4: {
            int n;
            if (this.nbPalettes_ != -1 || (n = this.getFrameCount()) <= 0) break block4;
            ColorModel cm = this.getFrame(0).getColorModel();
            if (cm instanceof IndexColorModel) {
                IndexColorModel prev = (IndexColorModel)cm;
                int size = prev.getMapSize();
                byte[] pr = new byte[size];
                byte[] pg = new byte[size];
                byte[] pb = new byte[size];
                byte[] cr = new byte[size];
                byte[] cg = new byte[size];
                byte[] cb = new byte[size];
                prev.getReds(pr);
                prev.getGreens(pg);
                prev.getBlues(pb);
                this.nbPalettes_ = 1;
                for (int i = 1; i < n; ++i) {
                    IndexColorModel cur = (IndexColorModel)this.getFrame(i).getColorModel();
                    if (cur == prev) continue;
                    cur.getReds(cr);
                    cur.getGreens(cg);
                    cur.getBlues(cb);
                    if (Arrays.equals(cr, pr) && Arrays.equals(cg, pg) && Arrays.equals(cb, pb)) continue;
                    ++this.nbPalettes_;
                    prev = cur;
                    System.arraycopy(cr, 0, pr, 0, cr.length);
                    System.arraycopy(cg, 0, pg, 0, cg.length);
                    System.arraycopy(cb, 0, pb, 0, cb.length);
                }
            } else {
                this.nbPalettes_ = 1;
                ColorModel prev = cm;
                for (int i = 1; i < n; ++i) {
                    ColorModel cur = this.getFrame(i).getColorModel();
                    if (cur == prev) continue;
                    ++this.nbPalettes_;
                    prev = cur;
                }
            }
        }
        return this.nbPalettes_;
    }

    public int getMasking() {
        return this.masking;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public int getXAspect() {
        return this.xAspect;
    }

    public int getYAspect() {
        return this.yAspect;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public int getScreenMode() {
        return this.screenMode;
    }

    public int getJiffies() {
        return this.jiffies;
    }

    public int getCompression() {
        return this.compression_;
    }

    public int getDeltaOperation() {
        int lastFrame = this.frames_.size() - 1;
        if (lastFrame < 0) {
            return -1;
        }
        return ((SEQFrame)this.frames_.elementAt(lastFrame)).getOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(SEQFrame frame) {
        int oldValue;
        SEQMovieTrack sEQMovieTrack = this;
        synchronized (sEQMovieTrack) {
            oldValue = this.frames_.size();
            this.frames_.addElement(frame);
            this.totalDuration_ = -1L;
        }
        this.firePropertyChange("frameCount", oldValue, oldValue + 1);
    }

    public void addAudioClip(AudioClip clip) {
        int oldValue = this.audioClips_.size();
        this.audioClips_.addElement(clip);
        this.firePropertyChange("audioClipCount", oldValue, oldValue + 1);
    }

    public int getAudioClipCount() {
        return this.audioClips_.size();
    }

    public AudioClip getAudioClip(int index) {
        return (AudioClip)this.audioClips_.elementAt(index);
    }

    public int getFrameCount() {
        int size = this.frames_.size();
        return size;
    }

    public SEQFrame getFrame(int index) {
        return (SEQFrame)this.frames_.elementAt(index);
    }

    public long getFrameDuration(int index) {
        return ((SEQFrame)this.frames_.elementAt(index)).getRelTime();
    }

    public synchronized long getTotalDuration() {
        if (this.totalDuration_ == -1L) {
            this.totalDuration_ = 0L;
            for (int i = this.getFrameCount() - 1; i > -1; --i) {
                this.totalDuration_ += Math.max(this.getFrameDuration(i), 1L);
            }
        }
        return this.totalDuration_;
    }

    public void addColorCycle(ColorCycle cc) {
        int oldCount = this.colorCycles.size();
        this.colorCycles.add(cc);
        this.firePropertyChange("colorCyclesCount", oldCount, this.colorCycles.size());
    }

    public List<ColorCycle> getColorCycles() {
        return this.colorCycles;
    }

    public int getColorCyclesCount() {
        return this.colorCycles.size();
    }

    public void removeFrame(int i) {
        this.frames_.remove(i);
        this.totalDuration_ = -1L;
    }
}

