/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.tiff;

import java.util.ArrayList;
import org.monte.media.tiff.FileSegment;
import org.monte.media.tiff.IFD;
import org.monte.media.tiff.IFDEntry;
import org.monte.media.tiff.TIFFField;
import org.monte.media.tiff.TIFFNode;
import org.monte.media.tiff.TIFFTag;
import org.monte.media.tiff.TagSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIFFDirectory
extends TIFFNode {
    private TagSet tagSet;
    private int index;
    private IFD ifd;
    private ArrayList<FileSegment> fileSegments;
    private long offset;
    private long length;

    public TIFFDirectory(TagSet tagSet, TIFFTag tag, int index) {
        super(tag);
        this.tagSet = tagSet;
        this.index = index;
    }

    public TIFFDirectory(TagSet tagSet, TIFFTag tag, int index, IFD ifd, IFDEntry parentEntry, ArrayList<FileSegment> fileSegments) {
        this(tagSet, tag, index);
        this.ifd = ifd;
        this.ifdEntry = parentEntry;
        this.fileSegments = fileSegments;
    }

    public TIFFDirectory(TagSet tagSet, TIFFTag tag, int index, IFD ifd, IFDEntry parentEntry, FileSegment fileSegment) {
        this(tagSet, tag, index);
        this.ifd = ifd;
        this.ifdEntry = parentEntry;
        this.fileSegments = new ArrayList();
        this.fileSegments.add(fileSegment);
    }

    public TIFFDirectory(TagSet tagSet, TIFFTag tag, int index, long offset, long length, FileSegment fileSegment) {
        this(tagSet, tag, index);
        this.offset = offset;
        this.length = length;
        this.fileSegments = new ArrayList();
        this.fileSegments.add(fileSegment);
    }

    public TIFFDirectory(TagSet tagSet, TIFFTag tag, int index, long offset, long length, ArrayList<FileSegment> fileSegments) {
        this(tagSet, tag, index);
        this.offset = offset;
        this.length = length;
        this.fileSegments = fileSegments;
    }

    public IFD getIFD() {
        return this.ifd;
    }

    public TagSet getTagSet() {
        return this.tagSet;
    }

    public String getName() {
        return this.tagSet == null ? null : this.tagSet.getName();
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.getChildren().size();
    }

    public long getOffset() {
        return this.ifd != null ? this.ifd.getOffset() : this.offset;
    }

    public long getLength() {
        return this.ifd != null ? this.ifd.getLength() : this.length;
    }

    public ArrayList<FileSegment> getFileSegments() {
        return this.fileSegments;
    }

    public TIFFField getField(TIFFTag tag) {
        for (TIFFNode node : this.getChildren()) {
            if (!(node instanceof TIFFField) || node.getTag() != tag) continue;
            return (TIFFField)node;
        }
        return null;
    }

    public Object getData(TIFFTag tag) {
        TIFFField field = this.getField(tag);
        return field == null ? null : field.getData();
    }

    public String toString() {
        return "TIFFDirectory " + this.tagSet;
    }
}

