/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.WeakHashMap;
import org.dcm4che2.data.AbstractDicomElement;
import org.dcm4che2.data.AbstractDicomObject;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.ElementDictionary;
import org.dcm4che2.data.Implementation;
import org.dcm4che2.data.SequenceDicomElement;
import org.dcm4che2.data.SimpleDicomElement;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;
import org.dcm4che2.data.VRMap;
import org.dcm4che2.util.IntHashtable;
import org.dcm4che2.util.TagUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDicomObject
extends AbstractDicomObject {
    private static final long serialVersionUID = 1L;
    private static final int INIT_FRAGMENT_CAPACITY = 2;
    private static final int INIT_SEQUENCE_CAPACITY = 10;
    private final transient IntHashtable<DicomElement> table;
    private transient DicomObject defaults;
    private transient DicomObject parent;
    private transient SpecificCharacterSet charset = null;
    private transient long itemOffset = -1L;
    private transient int itemPos = -1;
    private transient boolean cacheGet = true;
    private transient boolean cachePut = false;
    private transient boolean bigEndian = false;

    public BasicDicomObject() {
        this(null, 10);
    }

    public BasicDicomObject(DicomObject defaults) {
        this(defaults, 10);
    }

    public BasicDicomObject(int capacity) {
        this(null, capacity);
    }

    public BasicDicomObject(DicomObject defaults, int capacity) {
        this.defaults = defaults;
        this.table = new IntHashtable(capacity);
    }

    public final DicomObject getDefaults() {
        return this.defaults;
    }

    public final void setDefaults(DicomObject defaults) {
        this.defaults = defaults;
    }

    @Override
    public void clear() {
        this.table.clear();
        this.charset = null;
    }

    @Override
    public final boolean cacheGet() {
        return this.cacheGet;
    }

    @Override
    public final void cacheGet(final boolean cacheGet) {
        this.cacheGet = cacheGet;
        this.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement attr) {
                if (attr.vr() == VR.SQ && attr.hasItems()) {
                    int n = attr.countItems();
                    for (int i = 0; i < n; ++i) {
                        attr.getDicomObject(i).cacheGet(cacheGet);
                    }
                }
                return true;
            }
        });
    }

    @Override
    public final boolean cachePut() {
        return this.cachePut;
    }

    @Override
    public final void cachePut(final boolean cachePut) {
        this.cachePut = cachePut;
        this.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement attr) {
                if (attr.vr() == VR.SQ && attr.hasItems()) {
                    int n = attr.countItems();
                    for (int i = 0; i < n; ++i) {
                        attr.getDicomObject(i).cachePut(cachePut);
                    }
                }
                return true;
            }
        });
    }

    @Override
    public final boolean bigEndian() {
        return this.parent != null ? this.parent.bigEndian() : this.bigEndian;
    }

    @Override
    public final void bigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    @Override
    public int resolveTag(int privateTag, String privateCreator) {
        return this.resolveTag(privateTag, privateCreator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shareElements() {
        WeakHashMap<SimpleDicomElement, WeakReference<SimpleDicomElement>> weakHashMap = SimpleDicomElement.shared;
        synchronized (weakHashMap) {
            this.table.accept(new IntHashtable.Visitor(){

                public boolean visit(int key, Object value) {
                    BasicDicomObject.this.table.put(key, ((DicomElement)value).share());
                    return true;
                }
            });
        }
    }

    @Override
    public Iterator<DicomElement> iterator() {
        return this.iterator(0, -1);
    }

    @Override
    public Iterator<DicomElement> iterator(int fromTag, int toTag) {
        if (((long)fromTag & 0xFFFFFFFFL) > ((long)toTag & 0xFFFFFFFFL)) {
            throw new IllegalArgumentException("fromTag:" + TagUtils.toString(fromTag) + " > toTag:" + TagUtils.toString(toTag));
        }
        return this.table.iterator(fromTag, toTag);
    }

    @Override
    public final DicomObject getParent() {
        return this.parent;
    }

    @Override
    public final void setParent(DicomObject parent) {
        this.parent = parent;
    }

    @Override
    public DicomObject getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    @Override
    public final int getItemPosition() {
        return this.itemPos;
    }

    @Override
    public final void setItemPosition(int itemPos) {
        this.itemPos = itemPos;
    }

    @Override
    public final long getItemOffset() {
        return this.itemOffset;
    }

    @Override
    public final void setItemOffset(long itemOffset) {
        this.itemOffset = itemOffset;
    }

    @Override
    public SpecificCharacterSet getSpecificCharacterSet() {
        if (this.charset != null) {
            return this.charset;
        }
        if (this.parent != null) {
            return this.parent.getSpecificCharacterSet();
        }
        return null;
    }

    @Override
    public VR vrOf(int tag) {
        VRMap vrmap;
        if ((tag & 0xFFFF) == 0) {
            return VR.UL;
        }
        if ((tag & 0x10000) != 0) {
            if ((tag & 0xFF00) == 0) {
                return VR.LO;
            }
            String privateCreatorID = this.getPrivateCreator(tag);
            if (privateCreatorID == null) {
                return VR.UN;
            }
            vrmap = VRMap.getPrivateVRMap(privateCreatorID);
        } else {
            vrmap = VRMap.getVRMap();
        }
        return vrmap.vrOf(tag);
    }

    @Override
    public String nameOf(int tag) {
        ElementDictionary dict;
        if ((tag & 0xFFFF) == 0) {
            return "Group Length";
        }
        if ((tag & 0x10000) != 0) {
            if ((tag & 0xFF00) == 0) {
                return "Private Creator Data Element";
            }
            String privateCreatorID = this.getPrivateCreator(tag);
            if (privateCreatorID == null) {
                return ElementDictionary.getUnkown();
            }
            dict = ElementDictionary.getPrivateDictionary(privateCreatorID);
        } else {
            dict = ElementDictionary.getDictionary();
        }
        return dict.nameOf(tag);
    }

    @Override
    public String getPrivateCreator(int tag) {
        if (!TagUtils.isPrivateDataElement(tag) || TagUtils.isPrivateCreatorDataElement(tag)) {
            throw new IllegalArgumentException(TagUtils.toString(tag));
        }
        int creatorIDtag = tag & 0xFFFF0000 | tag >> 8 & 0xFF;
        return this.getAndCacheString(creatorIDtag);
    }

    private String getAndCacheString(int creatorIDtag) {
        DicomElement a = this.get(creatorIDtag);
        return a == null ? null : a.getString(this.getSpecificCharacterSet(), true);
    }

    @Override
    public int resolveTag(int tag, String creator, boolean reserve) {
        String id;
        if (creator == null || !TagUtils.isPrivateDataElement(tag)) {
            return tag;
        }
        int gggg0000 = tag & 0xFFFF0000;
        int idTag = gggg0000 | 0x10;
        int maxIdTag = gggg0000 | 0xFF;
        while (!creator.equals(id = this.getAndCacheString(idTag))) {
            if (id == null) {
                if (!reserve) {
                    return -1;
                }
                this.addPrivateCreator(creator, idTag);
                break;
            }
            if (++idTag <= maxIdTag) continue;
            throw new IllegalStateException("No free block to reserve in group " + TagUtils.toString(gggg0000));
        }
        return tag & 0xFFFF00FF | (idTag & 0xFF) << 8;
    }

    private void addPrivateCreator(String privateCreator, int idTag) {
        this.addInternal(new SimpleDicomElement(idTag, VR.LO, false, VR.LO.toBytes(privateCreator, false, this.getSpecificCharacterSet()), privateCreator));
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public boolean contains(int tag) {
        return this.table.get(tag) != null || this.defaults != null && this.defaults.contains(tag);
    }

    @Override
    public DicomElement get(int tag) {
        DicomElement attr = this.table.get(tag);
        return attr != null || this.defaults == null ? attr : this.defaults.get(tag);
    }

    @Override
    public DicomElement remove(int tag) {
        DicomElement attr = (DicomElement)this.table.remove(tag);
        if (attr != null && tag == 524293) {
            this.charset = null;
        }
        return attr;
    }

    DicomElement addInternal(DicomElement a) {
        int tag = a.tag();
        if ((tag & 0xFFFF) == 0) {
            return a;
        }
        this.table.put(tag, a);
        if (tag == 524293) {
            this.charset = SpecificCharacterSet.valueOf(a.getStrings(null, false));
        }
        return a;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DicomObject)) {
            return false;
        }
        DicomObject other = (DicomObject)o;
        Iterator<DicomElement> it = this.iterator();
        Iterator<DicomElement> otherIt = other.iterator();
        while (it.hasNext() && otherIt.hasNext()) {
            if (it.next().equals(otherIt.next())) continue;
            return false;
        }
        return !it.hasNext() && !otherIt.hasNext();
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    @Override
    public boolean accept(final DicomObject.Visitor visitor) {
        return this.table.accept(new IntHashtable.Visitor(){

            public boolean visit(int key, Object value) {
                return visitor.visit((DicomElement)value);
            }
        });
    }

    @Override
    public void add(DicomElement a) {
        if (a.hasItems()) {
            DicomElement t;
            int n = a.countItems();
            if (a.vr() == VR.SQ) {
                t = this.putSequence(a.tag(), n);
                for (int i = 0; i < n; ++i) {
                    DicomObject srcItem = a.getDicomObject(i);
                    BasicDicomObject item = new BasicDicomObject(srcItem.size());
                    item.setParent(this);
                    srcItem.copyTo(item);
                    t.addDicomObject(item);
                }
            } else {
                t = this.putFragments(a.tag(), a.vr(), a.bigEndian(), n);
                for (int i = 0; i < n; ++i) {
                    t.addFragment(a.getFragment(i));
                }
            }
            a = t;
        }
        this.addInternal(a);
    }

    @Override
    public DicomElement putNull(int tag, VR vr) {
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        AbstractDicomElement e = vr == VR.SQ ? new SequenceDicomElement(tag, vr, false, new ArrayList<Object>(0), this) : new SimpleDicomElement(tag, vr, false, null, null);
        return this.addInternal(e);
    }

    @Override
    public DicomElement putBytes(int tag, VR vr, byte[] val, boolean bigEndian) {
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, bigEndian, val, null));
    }

    @Override
    public DicomElement putNestedDicomObject(int tag, DicomObject item) {
        DicomElement a = this.putSequence(tag, 1);
        a.addDicomObject(item);
        return a;
    }

    @Override
    public DicomElement putShorts(int tag, VR vr, short[] val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), (short[])(this.cachePut ? val : null)));
    }

    @Override
    public DicomElement putInt(int tag, VR vr, int val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), this.cachePut ? Integer.valueOf(val) : null));
    }

    @Override
    public DicomElement putInts(int tag, VR vr, int[] val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), (int[])(this.cachePut ? val : null)));
    }

    @Override
    public DicomElement putFloat(int tag, VR vr, float val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), this.cachePut ? new Float(val) : null));
    }

    @Override
    public DicomElement putFloats(int tag, VR vr, float[] val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), (float[])(this.cachePut ? val : null)));
    }

    public DicomElement putTruncatedFloatsToDS(int tag, float[] val, int truncatedDigits) {
        boolean be = this.bigEndian();
        String[] s = this.toBytesTruncated(val, be, truncatedDigits);
        return this.addInternal(new SimpleDicomElement(tag, VR.DS, be, VR.DS.toBytes(s, be, null), (float[])(this.cachePut ? val : null)));
    }

    private String[] toBytesTruncated(float[] val, boolean bigEndian, int truncatedDigits) {
        if (val == null) {
            return null;
        }
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        DecimalFormat fmt = (DecimalFormat)nf;
        fmt.setMaximumFractionDigits(truncatedDigits);
        fmt.setGroupingUsed(false);
        String[] ss = new String[val.length];
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = fmt.format(val[i]);
        }
        return ss;
    }

    @Override
    public DicomElement putDouble(int tag, VR vr, double val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), this.cachePut ? new Double(val) : null));
    }

    @Override
    public DicomElement putDoubles(int tag, VR vr, double[] val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be), (double[])(this.cachePut ? val : null)));
    }

    @Override
    public DicomElement putString(int tag, VR vr, String val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be, this.getSpecificCharacterSet()), this.cachePut && vr.isSingleValue(val) ? val : null));
    }

    @Override
    public DicomElement putStrings(int tag, VR vr, String[] val) {
        boolean be = this.bigEndian();
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, be, vr.toBytes(val, be, this.getSpecificCharacterSet()), this.cachePut && vr.containsSingleValues(val) ? val : null));
    }

    @Override
    public DicomElement putDate(int tag, VR vr, Date val) {
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, false, vr.toBytes(val), null));
    }

    @Override
    public DicomElement putDates(int tag, VR vr, Date[] val) {
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, false, vr.toBytes(val), null));
    }

    @Override
    public DicomElement putDateRange(int tag, VR vr, DateRange val) {
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        return this.addInternal(new SimpleDicomElement(tag, vr, false, vr.toBytes(val), null));
    }

    @Override
    public DicomElement putSequence(int tag) {
        return this.putSequence(tag, 10);
    }

    @Override
    public DicomElement putSequence(int tag, int capacity) {
        return this.addInternal(new SequenceDicomElement(tag, VR.SQ, false, new ArrayList<Object>(capacity), this));
    }

    @Override
    public DicomElement putFragments(int tag, VR vr, boolean bigEndian) {
        return this.putFragments(tag, vr, bigEndian, 2);
    }

    @Override
    public DicomElement putFragments(int tag, VR vr, boolean bigEndian, int capacity) {
        if (vr == null) {
            vr = this.vrOf(tag);
        }
        if (!(vr instanceof VR.Fragment)) {
            throw new UnsupportedOperationException();
        }
        return this.addInternal(new SequenceDicomElement(tag, vr, bigEndian, new ArrayList<Object>(capacity), this));
    }

    @Override
    public void initFileMetaInformation(String tsuid) {
        String sopClassUID = this.getString(524310);
        String sopInstanceUID = this.getString(524312);
        this.initFileMetaInformation(sopClassUID, sopInstanceUID, tsuid);
    }

    @Override
    public void initFileMetaInformation(String cuid, String iuid, String tsuid) {
        this.putBytes(131073, VR.OB, new byte[]{0, 1}, false);
        this.putString(131074, VR.UI, cuid);
        this.putString(131075, VR.UI, iuid);
        this.putString(131088, VR.UI, tsuid);
        this.putString(131090, VR.UI, Implementation.classUID());
        this.putString(131091, VR.SH, Implementation.versionName());
    }
}

