/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DataOutputStreamAdapter;
import org.dcm4che2.io.RAFOutputStreamAdapter;
import org.dcm4che2.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DicomOutputStream
extends FilterOutputStream {
    private static final int PREAMBLE_LENGTH = 128;
    private TransferSyntax ts = TransferSyntax.ExplicitVRLittleEndian;
    private boolean includeGroupLength = false;
    private boolean explicitItemLength = false;
    private boolean explicitSequenceLength = false;
    private boolean explicitItemLengthIfZero = true;
    private boolean explicitSequenceLengthIfZero = true;
    private byte[] header = new byte[8];
    private byte[] preamble = new byte[128];
    private long pos = 0L;
    private boolean autoFinish = true;

    public DicomOutputStream(OutputStream out) {
        super(out);
    }

    public DicomOutputStream(File f) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(f)));
    }

    public DicomOutputStream(RandomAccessFile raf) throws IOException {
        super(new RAFOutputStreamAdapter(raf));
        this.pos = raf.getFilePointer();
    }

    public DicomOutputStream(DataOutput dout) {
        super(new DataOutputStreamAdapter(dout));
    }

    public byte[] getPreamble() {
        return this.preamble;
    }

    public void setPreamble(byte[] preamble) {
        if (preamble != null && preamble.length != 128) {
            throw new IllegalArgumentException("preamble length must be 128 but is " + preamble.length);
        }
        this.preamble = preamble;
    }

    public final long getStreamPosition() {
        return this.pos;
    }

    public final void setStreamPosition(long pos) {
        this.pos = pos;
    }

    public final TransferSyntax getTransferSyntax() {
        return this.ts;
    }

    public final void setTransferSyntax(TransferSyntax ts) {
        if (ts.deflated() && !(this.out instanceof DeflaterOutputStream)) {
            this.out = new DeflaterOutputStream(this.out, new Deflater(-1, true));
        }
        this.ts = ts;
    }

    public final void setTransferSyntax(String tsuid) {
        this.setTransferSyntax(TransferSyntax.valueOf(tsuid));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.pos += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.pos;
    }

    public final boolean isExplicitItemLength() {
        return this.explicitItemLength;
    }

    public final void setExplicitItemLength(boolean explicitItemLength) {
        this.explicitItemLength = explicitItemLength;
    }

    public final boolean isExplicitItemLengthIfZero() {
        return this.explicitItemLengthIfZero;
    }

    public final void setExplicitItemLengthIfZero(boolean explicitItemLengthIfZero) {
        this.explicitItemLengthIfZero = explicitItemLengthIfZero;
    }

    public final boolean isExplicitSequenceLength() {
        return this.explicitSequenceLength;
    }

    public final void setExplicitSequenceLength(boolean explicitSequenceLength) {
        this.explicitSequenceLength = explicitSequenceLength;
    }

    public final boolean isExplicitSequenceLengthIfZero() {
        return this.explicitSequenceLengthIfZero;
    }

    public final void setExplicitSequenceLengthIfZero(boolean explicitSequenceLengthIfZero) {
        this.explicitSequenceLengthIfZero = explicitSequenceLengthIfZero;
    }

    public final boolean isIncludeGroupLength() {
        return this.includeGroupLength;
    }

    public final void setIncludeGroupLength(boolean includeGroupLength) {
        this.includeGroupLength = includeGroupLength;
    }

    public void serializeDicomObject(DicomObject attrs) throws IOException {
        this.ts = TransferSyntax.ExplicitVRLittleEndian;
        this.writeElements(attrs.iterator(), false, null);
        this.writeHeader(-73715, null, 0);
    }

    public void writeCommand(DicomObject attrs) throws IOException {
        this.ts = TransferSyntax.ImplicitVRLittleEndian;
        this.writeElements(attrs.commandIterator(), true, new ItemInfo(attrs.commandIterator(), true));
    }

    private void writeGroupLength(int tag, int length) throws IOException {
        this.writeHeader(tag, VR.UL, 4);
        this.write(VR.UL.toBytes(length, this.ts.bigEndian()), 0, 4);
    }

    public void writeDicomFile(DicomObject attrs) throws IOException {
        String tsuid = attrs.getString(131088);
        if (tsuid == null) {
            throw new IllegalArgumentException("Missing (0002,0010) Transfer Syntax UID");
        }
        this.writeFileMetaInformation(attrs);
        this.writeDataset(attrs, tsuid);
    }

    public void writeFileMetaInformation(DicomObject attrs) throws IOException {
        if (this.preamble != null) {
            this.write(this.preamble, 0, 128);
            this.write(68);
            this.write(73);
            this.write(67);
            this.write(77);
        }
        this.ts = TransferSyntax.ExplicitVRLittleEndian;
        this.writeElements(attrs.fileMetaInfoIterator(), true, new ItemInfo(attrs.fileMetaInfoIterator(), true));
    }

    public void writeDataset(DicomObject attrs, String tsuid) throws IOException {
        this.writeDataset(attrs, TransferSyntax.valueOf(tsuid));
    }

    public void writeDataset(DicomObject attrs, TransferSyntax transferSyntax) throws IOException {
        this.setTransferSyntax(transferSyntax);
        this.ts = transferSyntax;
        this.writeElements(attrs.datasetIterator(), this.includeGroupLength, this.createItemInfo(attrs));
        if (this.autoFinish) {
            this.finish();
        }
    }

    public boolean isAutoFinish() {
        return this.autoFinish;
    }

    public void setAutoFinish(boolean autoFinish) {
        this.autoFinish = autoFinish;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
    }

    public void finish() throws IOException {
        if (this.out instanceof DeflaterOutputStream) {
            ((DeflaterOutputStream)this.out).finish();
        }
    }

    private ItemInfo createItemInfo(DicomObject attrs) {
        if (this.needItemInfo()) {
            return new ItemInfo(attrs.datasetIterator(), this.includeGroupLength);
        }
        return null;
    }

    private boolean needItemInfo() {
        return this.includeGroupLength || this.explicitItemLength || this.explicitSequenceLength;
    }

    public void writeItem(DicomObject item, TransferSyntax transferSyntax) throws IOException {
        this.ts = transferSyntax;
        this.writeItem(item, this.createItemInfo(item));
    }

    private void writeItem(DicomObject item, ItemInfo itemInfo) throws IOException {
        item.setItemOffset(this.pos);
        int len = item.isEmpty() ? (this.explicitItemLengthIfZero ? 0 : -1) : (this.explicitItemLength ? itemInfo.len : -1);
        this.writeHeader(-73728, null, len);
        this.writeElements(item.iterator(), this.includeGroupLength, itemInfo);
        if (len == -1) {
            this.writeHeader(-73715, null, 0);
        }
    }

    private void writeElements(Iterator<DicomElement> itr, boolean groupLength1, ItemInfo itemInfo) throws IOException {
        int gggg0 = -1;
        int gri = -1;
        int sqi = -1;
        while (itr.hasNext()) {
            int gggg;
            DicomElement a = itr.next();
            if (groupLength1 && (gggg = a.tag() & 0xFFFF0000) != gggg0) {
                gggg0 = gggg;
                assert (itemInfo != null);
                this.writeGroupLength(gggg, itemInfo.grlen[++gri]);
            }
            VR vr = a.vr();
            int len = a.length();
            if (vr == VR.SQ) {
                if (len == -1 && this.explicitSequenceLength) {
                    assert (itemInfo != null);
                    len = itemInfo.sqlen[++sqi];
                } else if (len == 0 && !this.explicitSequenceLengthIfZero) {
                    len = -1;
                }
            }
            this.writeHeader(a.tag(), vr, len);
            a.bigEndian(this.ts.bigEndian());
            if (a.hasItems()) {
                int n;
                if (vr == VR.SQ) {
                    n = a.countItems();
                    for (int i = 0; i < n; ++i) {
                        DicomObject item = a.getDicomObject(i);
                        ItemInfo childItemInfo = itemInfo != null ? itemInfo.childs.removeFirst() : null;
                        this.writeItem(item, childItemInfo);
                    }
                } else {
                    n = a.countItems();
                    for (int i = 0; i < n; ++i) {
                        byte[] val = a.getFragment(i);
                        this.writeHeader(-73728, null, val.length + 1 & 0xFFFFFFFE);
                        this.write(val);
                        if ((val.length & 1) == 0) continue;
                        this.write(0);
                    }
                }
            } else if (len > 0) {
                byte[] val = a.getBytes();
                this.write(val);
                if ((val.length & 1) != 0) {
                    this.write(vr.padding());
                }
            }
            if (len != -1) continue;
            this.writeHeader(-73507, null, 0);
        }
    }

    public void writeHeader(int tag, VR vr, int len) throws IOException {
        if (this.ts.bigEndian()) {
            ByteUtils.tag2bytesBE(tag, this.header, 0);
        } else {
            ByteUtils.tag2bytesLE(tag, this.header, 0);
        }
        int off = 0;
        if (vr != null && this.ts.explicitVR()) {
            ByteUtils.ushort2bytesBE(vr.code(), this.header, 4);
            if (vr.explicitVRHeaderLength() == 8) {
                if (this.ts.bigEndian()) {
                    ByteUtils.ushort2bytesBE(len, this.header, 6);
                } else {
                    ByteUtils.ushort2bytesLE(len, this.header, 6);
                }
                this.write(this.header, 0, 8);
                return;
            }
            this.header[7] = 0;
            this.header[6] = 0;
            this.write(this.header, 0, 8);
            off = 4;
        }
        if (this.ts.bigEndian()) {
            ByteUtils.int2bytesBE(len, this.header, 4);
        } else {
            ByteUtils.int2bytesLE(len, this.header, 4);
        }
        this.write(this.header, off, 8 - off);
    }

    private static int[] realloc(int[] src) {
        int[] dest = new int[src.length + 10];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemInfo {
        int len = 0;
        int[] grlen = new int[]{0};
        int[] sqlen = new int[0];
        LinkedList<ItemInfo> childs = null;

        ItemInfo(Iterator<DicomElement> it, boolean groupLength1) {
            int gggg0 = -1;
            int gri = -1;
            int sqi = -1;
            while (it.hasNext()) {
                DicomElement a = it.next();
                VR vr = a.vr();
                int vlen = a.length();
                if (vlen == -1) {
                    if (a.vr() == VR.SQ) {
                        vlen = this.calcItemSqLen(a);
                        if (DicomOutputStream.this.explicitSequenceLength) {
                            if (++sqi >= this.sqlen.length) {
                                this.sqlen = DicomOutputStream.realloc(this.sqlen);
                            }
                            this.sqlen[sqi] = vlen;
                        }
                    } else {
                        vlen = this.calcFragSqLen(a);
                    }
                } else if (a.vr() == VR.SQ && !DicomOutputStream.this.explicitSequenceLengthIfZero) {
                    vlen = 8;
                }
                int alen = (DicomOutputStream.this.ts.explicitVR() ? vr.explicitVRHeaderLength() : 8) + vlen;
                this.len += alen;
                int gggg = a.tag() & 0xFFFF0000;
                if (!groupLength1) continue;
                if (gggg != gggg0) {
                    gggg0 = gggg;
                    this.len += 12;
                    if (++gri >= this.grlen.length) {
                        this.grlen = DicomOutputStream.realloc(this.grlen);
                    }
                }
                int n = gri;
                this.grlen[n] = this.grlen[n] + alen;
            }
            if (!(this.len != 0 ? DicomOutputStream.this.explicitItemLength : DicomOutputStream.this.explicitItemLengthIfZero)) {
                this.len += 8;
            }
        }

        private int calcFragSqLen(DicomElement a) {
            int l = 8;
            int n = a.countItems();
            for (int i = 0; i < n; ++i) {
                byte[] b = a.getFragment(i);
                l += 8 + (b.length + 1) & 0xFFFFFFFE;
            }
            return l;
        }

        private int calcItemSqLen(DicomElement a) {
            int l = DicomOutputStream.this.explicitSequenceLength ? 0 : 8;
            int n = a.countItems();
            for (int i = 0; i < n; ++i) {
                DicomObject item = a.getDicomObject(i);
                ItemInfo itemInfo = new ItemInfo(item.iterator(), DicomOutputStream.this.includeGroupLength);
                if (this.childs == null) {
                    this.childs = new LinkedList();
                }
                this.childs.add(itemInfo);
                l += 8 + itemInfo.len;
            }
            return l;
        }
    }
}

