/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalModelClassFactory
extends DefaultModelClassFactory {
    private static final long serialVersionUID = -1795680089524220526L;
    private Class<? extends Message> myMessageClass;
    private String myVersion;

    public CanonicalModelClassFactory() {
        this.myVersion = CanonicalModelClassFactory.getHighestKnownVersion();
    }

    public CanonicalModelClassFactory(Class<? extends Message> theClass) {
        if (theClass == null) {
            throw new NullPointerException("Class may not be null");
        }
        this.myMessageClass = theClass;
    }

    public CanonicalModelClassFactory(String theVersion) {
        if (theVersion == null || !Version.supportsVersion(theVersion)) {
            throw new IllegalArgumentException("Unknown version: " + theVersion);
        }
        this.myVersion = theVersion;
    }

    @Override
    public Class<? extends Group> getGroupClass(String theName, String theVersion) throws HL7Exception {
        return super.getGroupClass(theName, this.myVersion);
    }

    @Override
    public Class<? extends Message> getMessageClass(String theName, String theVersion, boolean theIsExplicit) throws HL7Exception {
        if (this.myMessageClass != null) {
            return this.myMessageClass;
        }
        this.initVersionIfNeeded();
        return super.getMessageClass(theName, this.myVersion, theIsExplicit);
    }

    @Override
    public Class<? extends Segment> getSegmentClass(String theName, String theVersion) throws HL7Exception {
        this.initVersionIfNeeded();
        return super.getSegmentClass(theName, this.myVersion);
    }

    @Override
    public Class<? extends Type> getTypeClass(String theName, String theVersion) throws HL7Exception {
        this.initVersionIfNeeded();
        return super.getTypeClass(theName, this.myVersion);
    }

    private void initVersionIfNeeded() throws HL7Exception {
        if (this.myMessageClass != null && this.myVersion == null) {
            this.myVersion = ReflectionUtil.instantiateMessage(this.myMessageClass, this).getVersion();
        }
    }
}

