/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo _info;

    public KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        this(kEKRecipientInfo, algorithmIdentifier, null, inputStream);
    }

    public KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, InputStream inputStream) {
        super(algorithmIdentifier, algorithmIdentifier2, AlgorithmIdentifier.getInstance((Object)kEKRecipientInfo.getKeyEncryptionAlgorithm()), inputStream);
        this._info = kEKRecipientInfo;
        this.rid = new RecipientId();
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid.setKeyIdentifier(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        try {
            byte[] byArray = this._info.getEncryptedKey().getOctets();
            Cipher cipher = Cipher.getInstance(this.keyEncAlg.getObjectId().getId(), provider);
            cipher.init(4, key);
            AlgorithmIdentifier algorithmIdentifier = this.encAlg;
            if (algorithmIdentifier == null) {
                algorithmIdentifier = this.macAlg;
            }
            String string = algorithmIdentifier.getObjectId().getId();
            Key key2 = cipher.unwrap(byArray, string, 3);
            return this.getContentFromSessionKey(key2, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
    }
}

