/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.utils.Base64;
import org.hornetq.utils.ExecutorFactory;

public class XmlDataExporter {
    public static final Long LARGE_MESSAGE_CHUNK_SIZE = 1000L;
    private static final Logger log = Logger.getLogger(XmlDataExporter.class);
    private JournalStorageManager storageManager;
    private Configuration config = new ConfigurationImpl();
    private XMLStreamWriter xmlWriter;
    private Map<Long, HashMap<Long, JournalStorageManager.ReferenceDescribe>> messageRefs;
    private HashMap<Long, Message> messages;
    private Map<Long, Set<PagePosition>> cursorRecords;
    private Set<Long> pgTXs;
    HashMap<Long, JournalStorageManager.PersistentQueueBindingEncoding> queueBindings;
    long messagesPrinted = 0L;
    long bindingsPrinted = 0L;

    public XmlDataExporter(OutputStream out, String bindingsDir, String journalDir, String pagingDir, String largeMessagesDir) {
        this.config.setBindingsDirectory(bindingsDir);
        this.config.setJournalDirectory(journalDir);
        this.config.setPagingDirectory(pagingDir);
        this.config.setLargeMessagesDirectory(largeMessagesDir);
        this.config.setJournalType(JournalType.NIO);
        final ExecutorService executor = Executors.newFixedThreadPool(1);
        ExecutorFactory executorFactory = new ExecutorFactory(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        };
        this.storageManager = new JournalStorageManager(this.config, executorFactory);
        this.messageRefs = new HashMap<Long, HashMap<Long, JournalStorageManager.ReferenceDescribe>>();
        this.messages = new HashMap();
        this.cursorRecords = new HashMap<Long, Set<PagePosition>>();
        this.pgTXs = new HashSet<Long>();
        this.queueBindings = new HashMap();
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter rawXmlWriter = factory.createXMLStreamWriter(out);
            PrettyPrintHandler handler = new PrettyPrintHandler(rawXmlWriter);
            this.xmlWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arg) {
        if (arg.length < 4) {
            System.out.println("Use: java -cp hornetq-core.jar <bindings directory> <message directory> <page directory> <large-message directory>");
            System.exit(-1);
        }
        try {
            XmlDataExporter xmlDataExporter = new XmlDataExporter(System.out, arg[0], arg[1], arg[2], arg[3]);
            xmlDataExporter.writeXMLData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeXMLData() throws Exception {
        long start = System.currentTimeMillis();
        this.getBindings();
        this.processMessageJournal();
        this.printDataAsXML();
        log.debug("\n\nProcessing took: " + (System.currentTimeMillis() - start) + "ms");
        log.debug("Output " + this.messagesPrinted + " messages and " + this.bindingsPrinted + " bindings.");
    }

    private void processMessageJournal() throws Exception {
        ArrayList<RecordInfo> acks = new ArrayList<RecordInfo>();
        LinkedList<RecordInfo> records = new LinkedList<RecordInfo>();
        Journal messageJournal = this.storageManager.getMessageJournal();
        log.debug("Reading journal from " + this.config.getJournalDirectory());
        messageJournal.start();
        ((JournalImpl)messageJournal).load(records, null, null, false);
        for (RecordInfo info : records) {
            byte[] data = info.data;
            HornetQBuffer buff = HornetQBuffers.wrappedBuffer(data);
            Object o = JournalStorageManager.newObjectEncoding(info, this.storageManager);
            if (info.getUserRecordType() == 31) {
                this.messages.put(info.id, ((JournalStorageManager.MessageDescribe)o).msg);
                continue;
            }
            if (info.getUserRecordType() == 30) {
                this.messages.put(info.id, ((JournalStorageManager.MessageDescribe)o).msg);
                continue;
            }
            if (info.getUserRecordType() == 32) {
                JournalStorageManager.ReferenceDescribe ref = (JournalStorageManager.ReferenceDescribe)o;
                HashMap<Long, JournalStorageManager.ReferenceDescribe> map = this.messageRefs.get(info.id);
                if (map == null) {
                    HashMap<Long, JournalStorageManager.ReferenceDescribe> newMap = new HashMap<Long, JournalStorageManager.ReferenceDescribe>();
                    newMap.put(ref.refEncoding.queueID, ref);
                    this.messageRefs.put(info.id, newMap);
                    continue;
                }
                map.put(ref.refEncoding.queueID, ref);
                continue;
            }
            if (info.getUserRecordType() == 33) {
                acks.add(info);
                continue;
            }
            if (info.userRecordType == 39) {
                JournalStorageManager.CursorAckRecordEncoding encoding = new JournalStorageManager.CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = this.cursorRecords.get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    this.cursorRecords.put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (info.userRecordType != 35) continue;
            if (info.isUpdate) {
                JournalStorageManager.PageUpdateTXEncoding pageUpdate = new JournalStorageManager.PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                this.pgTXs.add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(info.id);
            this.pgTXs.add(pageTransactionInfo.getTransactionID());
        }
        messageJournal.stop();
        this.removeAcked(acks);
    }

    private void removeAcked(ArrayList<RecordInfo> acks) {
        for (RecordInfo info : acks) {
            JournalStorageManager.AckDescribe ack = (JournalStorageManager.AckDescribe)JournalStorageManager.newObjectEncoding(info, null);
            HashMap<Long, JournalStorageManager.ReferenceDescribe> referenceDescribeHashMap = this.messageRefs.get(info.id);
            referenceDescribeHashMap.remove(ack.refEncoding.queueID);
            if (referenceDescribeHashMap.size() != 0) continue;
            this.messages.remove(info.id);
            this.messageRefs.remove(info.id);
        }
    }

    private void getBindings() throws Exception {
        LinkedList<RecordInfo> records = new LinkedList<RecordInfo>();
        Journal bindingsJournal = this.storageManager.getBindingsJournal();
        bindingsJournal.start();
        log.debug("Reading bindings journal from " + this.config.getBindingsDirectory());
        ((JournalImpl)bindingsJournal).load(records, null, null, false);
        for (RecordInfo info : records) {
            if (info.getUserRecordType() != 21) continue;
            JournalStorageManager.PersistentQueueBindingEncoding bindingEncoding = (JournalStorageManager.PersistentQueueBindingEncoding)JournalStorageManager.newObjectEncoding(info, null);
            this.queueBindings.put(bindingEncoding.getId(), bindingEncoding);
        }
        bindingsJournal.stop();
    }

    private void printDataAsXML() {
        try {
            this.xmlWriter.writeStartDocument("1.0");
            this.xmlWriter.writeStartElement("hornetq-journal");
            this.printBindingsAsXML();
            this.printAllMessagesAsXML();
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
            this.xmlWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBindingsAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("bindings");
        for (Map.Entry<Long, JournalStorageManager.PersistentQueueBindingEncoding> queueBindingEncodingEntry : this.queueBindings.entrySet()) {
            JournalStorageManager.PersistentQueueBindingEncoding bindingEncoding = this.queueBindings.get(queueBindingEncodingEntry.getKey());
            this.xmlWriter.writeEmptyElement("binding");
            this.xmlWriter.writeAttribute("address", bindingEncoding.getAddress().toString());
            String filter = "";
            if (bindingEncoding.getFilterString() != null) {
                filter = bindingEncoding.getFilterString().toString();
            }
            this.xmlWriter.writeAttribute("filter-string", filter);
            this.xmlWriter.writeAttribute("queue-name", bindingEncoding.getQueueName().toString());
            this.xmlWriter.writeAttribute("id", Long.toString(bindingEncoding.getId()));
            ++this.bindingsPrinted;
        }
        this.xmlWriter.writeEndElement();
    }

    private void printAllMessagesAsXML() throws XMLStreamException {
        this.xmlWriter.writeStartElement("messages");
        for (Map.Entry<Long, Message> messageMapEntry : this.messages.entrySet()) {
            this.printSingleMessageAsXML((ServerMessage)messageMapEntry.getValue(), this.extractQueueNames(this.messageRefs.get(messageMapEntry.getKey())));
        }
        this.printPagedMessagesAsXML();
        this.xmlWriter.writeEndElement();
    }

    private void printPagedMessagesAsXML() {
        try {
            SimpleString[] stores;
            ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1);
            final ExecutorService executor = Executors.newFixedThreadPool(10);
            ExecutorFactory executorFactory = new ExecutorFactory(){

                @Override
                public Executor getExecutor() {
                    return executor;
                }
            };
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO(this.config.getPagingDirectory(), 1000L, scheduled, executorFactory, false, null);
            HierarchicalObjectRepository<AddressSettings> addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
            addressSettingsRepository.setDefault(new AddressSettings());
            NullStorageManager sm = new NullStorageManager();
            PagingManagerImpl manager = new PagingManagerImpl(pageStoreFactory, sm, addressSettingsRepository);
            manager.start();
            for (SimpleString store : stores = manager.getStoreNames()) {
                PagingStore pageStore = manager.getPageStore(store);
                String folder = null;
                if (pageStore != null) {
                    folder = pageStore.getFolder();
                }
                log.debug("Reading page store " + store + " folder = " + folder);
                int pageId = (int)pageStore.getFirstPage();
                for (int i = 0; i < pageStore.getNumberOfPages(); ++i) {
                    log.debug("Reading page " + pageId);
                    Page page = pageStore.createPage(pageId);
                    page.open();
                    List<PagedMessage> messages = page.read(sm);
                    page.close();
                    int messageId = 0;
                    for (PagedMessage message : messages) {
                        message.initMessage(sm);
                        long[] queueIDs = message.getQueueIDs();
                        ArrayList<String> queueNames = new ArrayList<String>();
                        for (long queueID : queueIDs) {
                            PagePositionImpl posCheck = new PagePositionImpl(pageId, messageId);
                            boolean acked = false;
                            Set<PagePosition> positions = this.cursorRecords.get(queueID);
                            if (positions != null) {
                                acked = positions.contains(posCheck);
                            }
                            if (acked) continue;
                            queueNames.add(this.queueBindings.get(queueID).getQueueName().toString());
                        }
                        if (queueNames.size() > 0 && (message.getTransactionID() == -1L || this.pgTXs.contains(message.getTransactionID()))) {
                            this.printSingleMessageAsXML(message.getMessage(), queueNames);
                        }
                        ++messageId;
                    }
                    ++pageId;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSingleMessageAsXML(ServerMessage message, List<String> queues) throws XMLStreamException {
        this.xmlWriter.writeStartElement("message");
        this.printMessageAttributes(message);
        this.printMessageProperties(message);
        this.printMessageQueues(queues);
        this.printMessageBody(message);
        this.xmlWriter.writeEndElement();
        ++this.messagesPrinted;
    }

    private void printMessageBody(ServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeStartElement("body");
        if (message.isLargeMessage()) {
            this.printLargeMessageBody((LargeServerMessage)message);
        } else {
            this.xmlWriter.writeCData(XmlDataExporter.encode(message.getBodyBuffer().toByteBuffer().array()));
        }
        this.xmlWriter.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLargeMessageBody(LargeServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("isLarge", Boolean.TRUE.toString());
        BodyEncoder encoder = null;
        try {
            encoder = message.getBodyEncoder();
            encoder.open();
            long totalBytesWritten = 0L;
            long bodySize = encoder.getLargeBodySize();
            for (long i = 0L; i < bodySize; i += LARGE_MESSAGE_CHUNK_SIZE.longValue()) {
                Long remainder = bodySize - totalBytesWritten;
                Long bufferSize = remainder >= LARGE_MESSAGE_CHUNK_SIZE ? LARGE_MESSAGE_CHUNK_SIZE : remainder;
                HornetQBuffer buffer = HornetQBuffers.fixedBuffer(bufferSize.intValue());
                encoder.encode(buffer, bufferSize.intValue());
                this.xmlWriter.writeCData(XmlDataExporter.encode(buffer.toByteBuffer().array()));
                totalBytesWritten += bufferSize.longValue();
            }
            encoder.close();
        }
        catch (HornetQException e) {
            e.printStackTrace();
        }
        finally {
            if (encoder != null) {
                try {
                    encoder.close();
                }
                catch (HornetQException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printMessageQueues(List<String> queues) throws XMLStreamException {
        this.xmlWriter.writeStartElement("queues");
        for (String queueName : queues) {
            this.xmlWriter.writeEmptyElement("queue");
            this.xmlWriter.writeAttribute("name", queueName);
        }
        this.xmlWriter.writeEndElement();
    }

    private void printMessageProperties(ServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeStartElement("properties");
        for (SimpleString key : message.getPropertyNames()) {
            Object value = message.getObjectProperty(key);
            this.xmlWriter.writeEmptyElement("property");
            this.xmlWriter.writeAttribute("name", key.toString());
            if (value instanceof byte[]) {
                this.xmlWriter.writeAttribute("value", XmlDataExporter.encode((byte[])value));
            } else {
                this.xmlWriter.writeAttribute("value", value.toString());
            }
            if (value instanceof Boolean) {
                this.xmlWriter.writeAttribute("type", "boolean");
                continue;
            }
            if (value instanceof Byte) {
                this.xmlWriter.writeAttribute("type", "byte");
                continue;
            }
            if (value instanceof Short) {
                this.xmlWriter.writeAttribute("type", "short");
                continue;
            }
            if (value instanceof Integer) {
                this.xmlWriter.writeAttribute("type", "integer");
                continue;
            }
            if (value instanceof Long) {
                this.xmlWriter.writeAttribute("type", "long");
                continue;
            }
            if (value instanceof Float) {
                this.xmlWriter.writeAttribute("type", "float");
                continue;
            }
            if (value instanceof Double) {
                this.xmlWriter.writeAttribute("type", "double");
                continue;
            }
            if (value instanceof String) {
                this.xmlWriter.writeAttribute("type", "string");
                continue;
            }
            if (value instanceof SimpleString) {
                this.xmlWriter.writeAttribute("type", "simple-string");
                continue;
            }
            if (!(value instanceof byte[])) continue;
            this.xmlWriter.writeAttribute("type", "bytes");
        }
        this.xmlWriter.writeEndElement();
    }

    private void printMessageAttributes(ServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("id", Long.toString(message.getMessageID()));
        this.xmlWriter.writeAttribute("priority", Byte.toString(message.getPriority()));
        this.xmlWriter.writeAttribute("expiration", Long.toString(message.getExpiration()));
        this.xmlWriter.writeAttribute("timestamp", Long.toString(message.getTimestamp()));
        byte rawType = message.getType();
        String prettyType = "default";
        if (rawType == 4) {
            prettyType = "bytes";
        } else if (rawType == 5) {
            prettyType = "map";
        } else if (rawType == 2) {
            prettyType = "object";
        } else if (rawType == 6) {
            prettyType = "stream";
        } else if (rawType == 3) {
            prettyType = "text";
        }
        this.xmlWriter.writeAttribute("type", prettyType);
        if (message.getUserID() != null) {
            this.xmlWriter.writeAttribute("user-id", message.getUserID().toString());
        }
    }

    private List<String> extractQueueNames(HashMap<Long, JournalStorageManager.ReferenceDescribe> refMap) {
        ArrayList<String> queues = new ArrayList<String>();
        for (JournalStorageManager.ReferenceDescribe ref : refMap.values()) {
            queues.add(this.queueBindings.get(ref.refEncoding.queueID).getQueueName().toString());
        }
        return queues;
    }

    private static String encode(byte[] data) {
        return Base64.encodeBytes(data, 0, data.length, 24);
    }

    class PrettyPrintHandler
    implements InvocationHandler {
        private XMLStreamWriter target;
        private int depth = 0;
        private final char INDENT_CHAR = (char)32;
        private final String LINE_SEPARATOR = System.getProperty("line.separator");

        public PrettyPrintHandler(XMLStreamWriter target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String m = method.getName();
            if ("writeStartElement".equals(m)) {
                this.target.writeCharacters(this.LINE_SEPARATOR);
                this.target.writeCharacters(this.indent(this.depth));
                ++this.depth;
            } else if ("writeEndElement".equals(m)) {
                --this.depth;
                this.target.writeCharacters(this.LINE_SEPARATOR);
                this.target.writeCharacters(this.indent(this.depth));
            } else if ("writeEmptyElement".equals(m) || "writeCData".equals(m)) {
                this.target.writeCharacters(this.LINE_SEPARATOR);
                this.target.writeCharacters(this.indent(this.depth));
            }
            method.invoke((Object)this.target, args);
            return null;
        }

        private String indent(int depth) {
            char[] output = new char[depth *= 3];
            while (depth-- > 0) {
                output[depth] = 32;
            }
            return new String(output);
        }
    }
}

