/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.ServerSessionPacketHandler;
import org.hornetq.core.protocol.core.impl.HornetQPacketHandler;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;

public class CoreProtocolManager
implements ProtocolManager {
    private static final Logger log = Logger.getLogger(CoreProtocolManager.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final HornetQServer server;
    private final List<Interceptor> interceptors;
    private Map<String, ServerSessionPacketHandler> sessionHandlers = new ConcurrentHashMap<String, ServerSessionPacketHandler>();

    public CoreProtocolManager(HornetQServer server, List<Interceptor> interceptors) {
        this.server = server;
        this.interceptors = interceptors;
    }

    @Override
    public ConnectionEntry createConnectionEntry(final Acceptor acceptorUsed, Connection connection) {
        final Configuration config = this.server.getConfiguration();
        Executor connectionExecutor = this.server.getExecutorFactory().getExecutor();
        final RemotingConnectionImpl rc = new RemotingConnectionImpl(connection, this.interceptors, config.isAsyncConnectionExecutionEnabled() ? connectionExecutor : null, this.server.getNodeID());
        Channel channel1 = rc.getChannel(1L, -1);
        HornetQPacketHandler handler = new HornetQPacketHandler(this, this.server, channel1, rc);
        channel1.setHandler(handler);
        long ttl = 60000L;
        if (config.getConnectionTTLOverride() != -1L) {
            ttl = config.getConnectionTTLOverride();
        }
        final ConnectionEntry entry = new ConnectionEntry(rc, connectionExecutor, System.currentTimeMillis(), ttl);
        final Channel channel0 = rc.getChannel(0L, -1);
        channel0.setHandler(new ChannelHandler(){

            @Override
            public void handlePacket(Packet packet) {
                if (packet.getType() == 10) {
                    Ping ping = (Ping)packet;
                    if (config.getConnectionTTLOverride() == -1L) {
                        entry.ttl = ping.getConnectionTTL();
                    }
                    channel0.send(packet);
                } else if (packet.getType() == 112 || packet.getType() == 113) {
                    SubscribeClusterTopologyUpdatesMessage msg = (SubscribeClusterTopologyUpdatesMessage)packet;
                    if (packet.getType() == 113) {
                        channel0.getConnection().setClientVersion(((SubscribeClusterTopologyUpdatesMessageV2)msg).getClientVersion());
                    }
                    final ClusterTopologyListener listener = new ClusterTopologyListener(){

                        @Override
                        public void nodeUP(final long uniqueEventID, final String nodeID, final Pair<TransportConfiguration, TransportConfiguration> connectorPair, final boolean last) {
                            entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (channel0.supports((byte)114)) {
                                        channel0.send(new ClusterTopologyChangeMessage_V2(uniqueEventID, nodeID, connectorPair, last));
                                    } else {
                                        channel0.send(new ClusterTopologyChangeMessage(nodeID, connectorPair, last));
                                    }
                                }
                            });
                        }

                        @Override
                        public void nodeDown(final long uniqueEventID, final String nodeID) {
                            entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (channel0.supports((byte)114)) {
                                        channel0.send(new ClusterTopologyChangeMessage_V2(uniqueEventID, nodeID));
                                    } else {
                                        channel0.send(new ClusterTopologyChangeMessage(nodeID));
                                    }
                                }
                            });
                        }

                        public String toString() {
                            return "Remote Proxy on channel " + Integer.toHexString(System.identityHashCode(this));
                        }
                    };
                    if (acceptorUsed.getClusterConnection() != null) {
                        acceptorUsed.getClusterConnection().addClusterTopologyListener(listener);
                        rc.addCloseListener(new CloseListener(){

                            @Override
                            public void connectionClosed() {
                                acceptorUsed.getClusterConnection().removeClusterTopologyListener(listener);
                            }
                        });
                    } else {
                        entry.connectionExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                String nodeId = CoreProtocolManager.this.server.getNodeID().toString();
                                Pair<Object, Object> emptyConfig = new Pair<Object, Object>(null, null);
                                if (channel0.supports((byte)114)) {
                                    channel0.send(new ClusterTopologyChangeMessage_V2(System.currentTimeMillis(), nodeId, emptyConfig, true));
                                } else {
                                    channel0.send(new ClusterTopologyChangeMessage(nodeId, emptyConfig, true));
                                }
                            }
                        });
                    }
                } else if (packet.getType() == 111) {
                    NodeAnnounceMessage msg = (NodeAnnounceMessage)packet;
                    Pair<Object, TransportConfiguration> pair = msg.isBackup() ? new Pair<Object, TransportConfiguration>(null, msg.getConnector()) : new Pair<TransportConfiguration, TransportConfiguration>(msg.getConnector(), msg.getBackupConnector());
                    if (isTrace) {
                        log.trace("Server " + CoreProtocolManager.this.server + " receiving nodeUp from NodeID=" + msg.getNodeID() + ", pair=" + pair);
                    }
                    if (acceptorUsed != null) {
                        ClusterConnection clusterConn = acceptorUsed.getClusterConnection();
                        if (clusterConn != null) {
                            clusterConn.nodeAnnounced(msg.getCurrentEventID(), msg.getNodeID(), pair, msg.isBackup());
                        } else {
                            log.debug("Cluster connection is null on acceptor = " + acceptorUsed);
                        }
                    } else {
                        log.debug("there is no acceptor used configured at the CoreProtocolManager " + this);
                    }
                }
            }
        });
        return entry;
    }

    public ServerSessionPacketHandler getSessionHandler(String sessionName) {
        return this.sessionHandlers.get(sessionName);
    }

    public void addSessionHandler(String name, ServerSessionPacketHandler handler) {
        this.sessionHandlers.put(name, handler);
    }

    @Override
    public void removeHandler(String name) {
        this.sessionHandlers.remove(name);
    }

    @Override
    public void handleBuffer(RemotingConnection connection, HornetQBuffer buffer) {
    }

    @Override
    public int isReadyToHandle(HornetQBuffer buffer) {
        return -1;
    }
}

