/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConnectorServiceConfiguration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.ConnectorService;
import org.hornetq.core.server.ConnectorServiceFactory;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.utils.ConfigurationHelper;

public class ConnectorsService
implements HornetQComponent {
    private static final Logger log = Logger.getLogger(ConnectorsService.class);
    private final StorageManager storageManager;
    private final PostOffice postOffice;
    private final ScheduledExecutorService scheduledPool;
    private boolean isStarted = false;
    private final Configuration configuration;
    private final Set<ConnectorService> connectors = new HashSet<ConnectorService>();

    public ConnectorsService(Configuration configuration, StorageManager storageManager, ScheduledExecutorService scheduledPool, PostOffice postOffice) {
        this.configuration = configuration;
        this.storageManager = storageManager;
        this.scheduledPool = scheduledPool;
        this.postOffice = postOffice;
    }

    @Override
    public void start() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        List<ConnectorServiceConfiguration> configurationList = this.configuration.getConnectorServiceConfigurations();
        for (ConnectorServiceConfiguration info : configurationList) {
            Set<String> invalid;
            Class<?> clazz = loader.loadClass(info.getFactoryClassName());
            ConnectorServiceFactory factory = (ConnectorServiceFactory)clazz.newInstance();
            if (info.getParams() != null && !(invalid = ConfigurationHelper.checkKeys(factory.getAllowableProperties(), info.getParams().keySet())).isEmpty()) {
                log.warn(ConfigurationHelper.stringSetToCommaListString("The following keys are invalid for configuring the connector service: ", invalid) + " the connector will not be started.");
                continue;
            }
            invalid = ConfigurationHelper.checkKeysExist(factory.getRequiredProperties(), info.getParams().keySet());
            if (!invalid.isEmpty()) {
                log.warn(ConfigurationHelper.stringSetToCommaListString("The following keys are required for configuring the connector service: ", invalid) + " the connector will not be started.");
                continue;
            }
            ConnectorService connectorService = factory.createConnectorService(info.getConnectorName(), info.getParams(), this.storageManager, this.postOffice, this.scheduledPool);
            this.connectors.add(connectorService);
        }
        for (ConnectorService connector : this.connectors) {
            try {
                connector.start();
            }
            catch (Throwable e) {
                log.info("unable to start connector service: " + connector.getName(), e);
            }
        }
        this.isStarted = true;
    }

    @Override
    public void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        for (ConnectorService connector : this.connectors) {
            try {
                connector.stop();
            }
            catch (Throwable e) {
                log.info("unable to stop connector service: " + connector.getName(), e);
            }
        }
        this.connectors.clear();
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public Set<ConnectorService> getConnectors() {
        return this.connectors;
    }
}

