/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.util;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.model.ecore.EDataType;
import org.apache.axis.model.ecore.EFactory;
import org.apache.axis.model.ecore.EPackage;
import org.apache.axis.model.ecore.xmi.XMLResource;
import org.apache.axis.model.ecore.xmi.impl.XMLHelperImpl;
import org.apache.axis.model.xml.impl.XmlPackageImpl;

public class AxisXMLHelper
extends XMLHelperImpl {
    private String ignoreNamespaceForUnqualifiedQName;

    public AxisXMLHelper(XMLResource resource) {
        super(resource);
    }

    public void setOptions(Map options) {
        super.setOptions(options);
        this.ignoreNamespaceForUnqualifiedQName = (String)options.get("IGNORE_NAMESPACE_FOR_UNQUALIFIED_QNAME");
    }

    protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
        if (eDataType == XmlPackageImpl.eINSTANCE.getQName()) {
            String localName;
            String prefix;
            int idx = value.indexOf(58);
            if (idx == -1) {
                prefix = "";
                localName = value;
            } else {
                prefix = value.substring(0, idx);
                localName = value.substring(idx + 1);
            }
            String namespaceURI = this.getURI(prefix);
            if (namespaceURI == null) {
                if (prefix.length() == 0) {
                    namespaceURI = "";
                } else {
                    throw new IllegalArgumentException("The prefix '" + prefix + "' is not declared for the QName '" + value + "'");
                }
            }
            if (prefix.length() == 0 && namespaceURI.equals(this.ignoreNamespaceForUnqualifiedQName)) {
                namespaceURI = "";
            }
            return new QName(namespaceURI, localName, prefix);
        }
        return super.createFromString(eFactory, eDataType, value);
    }

    protected String updateQNamePrefix(EFactory factory, EDataType dataType, Object value, boolean list) {
        if (!list && value instanceof QName) {
            QName qname = (QName)value;
            String namespace = qname.getNamespaceURI();
            if (namespace.length() == 0) {
                return qname.getLocalPart();
            }
            EPackage ePackage = this.extendedMetaData.getPackage(namespace);
            if (ePackage == null) {
                ePackage = this.extendedMetaData.demandPackage(namespace);
            }
            String prefix = this.getPrefix(ePackage, true);
            if (!this.packages.containsKey(ePackage)) {
                this.packages.put(ePackage, prefix);
            }
            return prefix + ":" + qname.getLocalPart();
        }
        return super.updateQNamePrefix(factory, dataType, value, list);
    }
}

