/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v21.segment.ACC;
import ca.uhn.hl7v2.model.v21.segment.DG1;
import ca.uhn.hl7v2.model.v21.segment.GT1;
import ca.uhn.hl7v2.model.v21.segment.IN1;
import ca.uhn.hl7v2.model.v21.segment.NK1;
import ca.uhn.hl7v2.model.v21.segment.PR1;
import ca.uhn.hl7v2.model.v21.segment.PV1;
import ca.uhn.hl7v2.model.v21.segment.UB1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAR_P01_VISIT
extends AbstractGroup {
    public BAR_P01_VISIT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PV1.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(PR1.class, false, true, false);
            this.add(GT1.class, false, true, false);
            this.add(NK1.class, false, true, false);
            this.add(IN1.class, false, true, false);
            this.add(ACC.class, false, false, false);
            this.add(UB1.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BAR_P01_VISIT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.1";
    }

    public PV1 getPV1() {
        PV1 retVal = (PV1)this.getTyped("PV1", PV1.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = (DG1)this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = (DG1)this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public PR1 getPR1() {
        PR1 retVal = (PR1)this.getTyped("PR1", PR1.class);
        return retVal;
    }

    public PR1 getPR1(int rep) {
        PR1 retVal = (PR1)this.getTyped("PR1", rep, PR1.class);
        return retVal;
    }

    public int getPR1Reps() {
        return this.getReps("PR1");
    }

    public List<PR1> getPR1All() throws HL7Exception {
        return this.getAllAsList("PR1", PR1.class);
    }

    public void insertPR1(PR1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PR1", (Structure)structure, rep);
    }

    public PR1 insertPR1(int rep) throws HL7Exception {
        return (PR1)super.insertRepetition("PR1", rep);
    }

    public PR1 removePR1(int rep) throws HL7Exception {
        return (PR1)super.removeRepetition("PR1", rep);
    }

    public GT1 getGT1() {
        GT1 retVal = (GT1)this.getTyped("GT1", GT1.class);
        return retVal;
    }

    public GT1 getGT1(int rep) {
        GT1 retVal = (GT1)this.getTyped("GT1", rep, GT1.class);
        return retVal;
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public NK1 getNK1() {
        NK1 retVal = (NK1)this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = (NK1)this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public IN1 getIN1() {
        IN1 retVal = (IN1)this.getTyped("IN1", IN1.class);
        return retVal;
    }

    public IN1 getIN1(int rep) {
        IN1 retVal = (IN1)this.getTyped("IN1", rep, IN1.class);
        return retVal;
    }

    public int getIN1Reps() {
        return this.getReps("IN1");
    }

    public List<IN1> getIN1All() throws HL7Exception {
        return this.getAllAsList("IN1", IN1.class);
    }

    public void insertIN1(IN1 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN1", (Structure)structure, rep);
    }

    public IN1 insertIN1(int rep) throws HL7Exception {
        return (IN1)super.insertRepetition("IN1", rep);
    }

    public IN1 removeIN1(int rep) throws HL7Exception {
        return (IN1)super.removeRepetition("IN1", rep);
    }

    public ACC getACC() {
        ACC retVal = (ACC)this.getTyped("ACC", ACC.class);
        return retVal;
    }

    public UB1 getUB1() {
        UB1 retVal = (UB1)this.getTyped("UB1", UB1.class);
        return retVal;
    }
}

