/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLUserEvent;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.ValuedEnum;
import java.util.Arrays;
import org.bridj.BridJ;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLEvent
extends CLAbstractEntity<OpenCLLibrary.cl_event> {
    private static CLInfoGetter<OpenCLLibrary.cl_event> infos = new CLInfoGetter<OpenCLLibrary.cl_event>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_event entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetEventInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    private static CLInfoGetter<OpenCLLibrary.cl_event> profilingInfos = new CLInfoGetter<OpenCLLibrary.cl_event>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_event entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetEventProfilingInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    static boolean noEvents = false;

    CLEvent(OpenCLLibrary.cl_event evt) {
        super(evt, false);
    }

    CLEvent() {
        super(null, true);
    }

    public void setCompletionCallback(EventCallback callback) {
        this.setCallback(0, callback);
    }

    public void setCallback(int commandExecStatus, final EventCallback callback) {
        try {
            OpenCLLibrary.clSetEventCallback_arg1_callback cb = new OpenCLLibrary.clSetEventCallback_arg1_callback(){

                public void apply(OpenCLLibrary.cl_event evt, int executionStatus, Pointer voidPtr1) {
                    callback.callback(CLEvent.this, executionStatus);
                }
            };
            BridJ.protectFromGC((NativeObject)cb);
            CLException.error(OpenCLLibrary.clSetEventCallback((OpenCLLibrary.cl_event)((Object)this.getEntity()), commandExecStatus, (Pointer<OpenCLLibrary.clSetEventCallback_arg1_callback>)Pointer.pointerTo((NativeObject)cb), null));
        }
        catch (Throwable th) {
            throw new UnsupportedOperationException("Cannot set event callback (OpenCL 1.1 feature).", th);
        }
    }

    public static void setNoEvents(boolean noEvents) {
        CLEvent.noEvents = noEvents;
    }

    static CLEvent createEvent(CLQueue queue, OpenCLLibrary.cl_event evt) {
        return CLEvent.createEvent(queue, evt, false);
    }

    static CLEvent createEvent(final CLQueue queue, OpenCLLibrary.cl_event evt, boolean isUserEvent) {
        if (noEvents && queue != null) {
            if (evt != null) {
                OpenCLLibrary.clReleaseEvent(evt);
            }
            evt = null;
            if (isUserEvent) {
                return new CLUserEvent(){
                    volatile boolean waited = false;

                    public synchronized void waitFor() {
                        if (!this.waited) {
                            queue.finish();
                            this.waited = true;
                        }
                    }
                };
            }
            return new CLEvent(){
                volatile boolean waited = false;

                public synchronized void waitFor() {
                    if (!this.waited) {
                        queue.finish();
                        this.waited = true;
                    }
                }
            };
        }
        if (evt == null) {
            return null;
        }
        return isUserEvent ? new CLUserEvent(evt) : new CLEvent(evt);
    }

    static CLEvent createEventFromPointer(CLQueue queue, Pointer<OpenCLLibrary.cl_event> evt1) {
        if (evt1 == null) {
            return null;
        }
        return CLEvent.createEvent(queue, (OpenCLLibrary.cl_event)((Object)evt1.get()));
    }

    public void waitFor() {
        if (this.entity == null) {
            return;
        }
        CLEvent.waitFor(this);
    }

    public static void waitFor(CLEvent ... eventsToWaitFor) {
        if (eventsToWaitFor.length == 0) {
            return;
        }
        try {
            Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
            if (evts == null) {
                return;
            }
            CLException.error(OpenCLLibrary.clWaitForEvents((int)evts.getValidElements(), evts));
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while waiting for events " + Arrays.asList(eventsToWaitFor), ex);
        }
    }

    public void invokeUponCompletion(Runnable action) {
        CLEvent.invokeUponCompletion(action, this);
    }

    public static void invokeUponCompletion(final Runnable action, final CLEvent ... eventsToWaitFor) {
        if (action == null) {
            throw new IllegalArgumentException("Null action !");
        }
        new Thread(){

            public void run() {
                CLEvent.waitFor(eventsToWaitFor);
                action.run();
            }
        }.start();
    }

    static Pointer<OpenCLLibrary.cl_event> new_event_out(CLEvent[] eventsToWaitFor) {
        return noEvents || eventsToWaitFor == null ? null : Pointer.allocateTypedPointer(OpenCLLibrary.cl_event.class);
    }

    static Pointer<OpenCLLibrary.cl_event> to_cl_event_array(CLEvent ... events) {
        if (events == null) {
            return null;
        }
        if (noEvents) {
            for (CLEvent evt : events) {
                if (evt == null) continue;
                evt.waitFor();
            }
            return null;
        }
        int n = events.length;
        if (n == 0) {
            return null;
        }
        int nonNulls = 0;
        for (int i = 0; i < n; ++i) {
            if (events[i] == null || events[i].getEntity() == null) continue;
            ++nonNulls;
        }
        if (nonNulls == 0) {
            return null;
        }
        Pointer event_wait_list = Pointer.allocateArray(OpenCLLibrary.cl_event.class, (long)nonNulls);
        int iDest = 0;
        for (int i = 0; i < n; ++i) {
            CLEvent event = events[i];
            if (event == null || event.getEntity() == null) continue;
            event_wait_list.set((long)iDest, event.getEntity());
            ++iDest;
        }
        return event_wait_list;
    }

    @Override
    protected void clear() {
        CLException.error(OpenCLLibrary.clReleaseEvent((OpenCLLibrary.cl_event)((Object)this.getEntity())));
    }

    public CommandExecutionStatus getCommandExecutionStatus() {
        int v = infos.getInt((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4563);
        CommandExecutionStatus status = CommandExecutionStatus.getEnum(v);
        if (status == null) {
            CLException.error(v);
        }
        return status;
    }

    @InfoName(value="CL_EVENT_COMMAND_EXECUTION_STATUS")
    public int getCommandExecutionStatusValue() {
        return infos.getInt((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4563);
    }

    @InfoName(value="CL_EVENT_COMMAND_TYPE")
    public CommandType getCommandType() {
        return CommandType.getEnum(infos.getInt((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4561));
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_QUEUED")
    public long getProfilingCommandQueued() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4736);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_SUBMIT")
    public long getProfilingCommandSubmit() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4737);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_START")
    public long getProfilingCommandStart() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4738);
    }

    @InfoName(value="CL_CL_PROFILING_COMMAND_END")
    public long getProfilingCommandEnd() {
        return profilingInfos.getIntOrLong((OpenCLLibrary.cl_event)((Object)this.getEntity()), 4739);
    }

    public String toString() {
        return "Event {commandType: " + this.getCommandType() + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandType implements ValuedEnum
    {
        NDRangeKernel(4592L),
        Task(4593L),
        NativeKernel(4594L),
        ReadBuffer(4595L),
        WriteBuffer(4596L),
        CopyBuffer(4597L),
        ReadImage(4598L),
        WriteImage(4599L),
        CopyImage(4600L),
        CopyBufferToImage(4602L),
        CopyImageToBuffer(4601L),
        MapBuffer(4603L),
        CommandMapImage(4604L),
        UnmapMemObject(4605L),
        Marker(4606L),
        AcquireGLObjects(4607L),
        ReleaseGLObjects(4608L);

        long value;

        private CommandType(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static CommandType getEnum(long v) {
            return EnumValues.getEnum(v, CommandType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommandExecutionStatus implements ValuedEnum
    {
        Queued(3L),
        Submitted(2L),
        Running(1L),
        Complete(0L);

        long value;

        private CommandExecutionStatus(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static CommandExecutionStatus getEnum(long v) {
            return EnumValues.getEnum(v, CommandExecutionStatus.class);
        }
    }

    public static interface EventCallback {
        public void callback(CLEvent var1, int var2);
    }
}

