/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLException;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CLInfoGetter<T extends Pointer> {
    CLInfoGetter() {
    }

    protected abstract int getInfo(T var1, int var2, long var3, Pointer var5, Pointer<SizeT> var6);

    public String getString(T entity, int infoName) {
        Pointer pLen = Pointer.allocate(SizeT.class);
        CLException.error(this.getInfo(entity, infoName, 0L, null, (Pointer<SizeT>)pLen));
        int len = (int)pLen.getSizeT();
        if (len == 0) {
            return "";
        }
        Pointer buffer = Pointer.allocateBytes((long)(len + 1));
        CLException.error(this.getInfo(entity, infoName, ((SizeT)pLen.get()).intValue(), buffer, null));
        return buffer.getCString();
    }

    public Pointer getPointer(T entity, int infoName) {
        Pointer pLen = Pointer.allocate(SizeT.class);
        Pointer mem = Pointer.allocatePointer();
        CLException.error(this.getInfo(entity, infoName, Pointer.SIZE, mem, (Pointer<SizeT>)pLen));
        if (pLen.getSizeT() != (long)Pointer.SIZE) {
            throw new RuntimeException("Not a pointer : len = " + pLen.get());
        }
        return (Pointer)mem.get();
    }

    public Pointer<?> getMemory(T entity, int infoName) {
        Pointer pLen = Pointer.allocate(SizeT.class);
        CLException.error(this.getInfo(entity, infoName, 0L, null, (Pointer<SizeT>)pLen));
        int len = ((SizeT)pLen.get()).intValue();
        Pointer buffer = Pointer.allocateBytes((long)len);
        CLException.error(this.getInfo(entity, infoName, len, buffer, null));
        return buffer;
    }

    public long[] getNativeSizes(T entity, int infoName, int n) {
        int nBytes = SizeT.SIZE * n;
        Pointer pLen = Pointer.pointerToSizeT((long)nBytes);
        Pointer mem = Pointer.allocateSizeTs((long)n);
        CLException.error(this.getInfo(entity, infoName, nBytes, mem, (Pointer<SizeT>)pLen));
        if (((SizeT)pLen.get()).longValue() != (long)nBytes) {
            throw new RuntimeException("Not a Size[" + n + "] : len = " + pLen.get());
        }
        return mem.getSizeTs(n);
    }

    public int getOptionalFeatureInt(T entity, int infoName) {
        try {
            return this.getInt(entity, infoName);
        }
        catch (CLException.InvalidValue ex) {
            throw new UnsupportedOperationException("Cannot get value " + infoName, ex);
        }
        catch (CLException.InvalidOperation ex) {
            throw new UnsupportedOperationException("Cannot get value " + infoName, ex);
        }
    }

    public int getInt(T entity, int infoName) {
        return (int)this.getIntOrLong(entity, infoName);
    }

    public boolean getBool(T entity, int infoName) {
        Pointer pLen = Pointer.allocate(SizeT.class);
        Pointer mem = Pointer.allocateBytes((long)8L);
        CLException.error(this.getInfo(entity, infoName, 8L, mem, (Pointer<SizeT>)pLen));
        long len = pLen.getSizeT();
        switch ((int)len) {
            case 1: {
                return mem.getByte() != 0;
            }
            case 2: {
                return mem.getShort() != 0;
            }
            case 4: {
                return mem.getInt() != 0;
            }
            case 8: {
                return mem.getLong() != 0L;
            }
            case 0: {
                return true;
            }
        }
        throw new RuntimeException("Not a BOOL : len = " + len);
    }

    public long getIntOrLong(T entity, int infoName) {
        Pointer pLen = Pointer.allocate(SizeT.class);
        Pointer mem = Pointer.allocateLong();
        CLException.error(this.getInfo(entity, infoName, 8L, mem, (Pointer<SizeT>)pLen));
        switch (((SizeT)pLen.get()).intValue()) {
            case 4: {
                return mem.getInt();
            }
            case 8: {
                return mem.getLong();
            }
        }
        throw new RuntimeException("Not a native long : len = " + pLen.get());
    }
}

