/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.OpenGLContextUtils;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.ValuedEnum;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLPlatform
extends CLAbstractEntity<OpenCLLibrary.cl_platform_id> {
    private static CLInfoGetter<OpenCLLibrary.cl_platform_id> infos = new CLInfoGetter<OpenCLLibrary.cl_platform_id>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_platform_id entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetPlatformInfo(entity, infoTypeEnum, size, out, sizeOut);
        }
    };
    private String[] extensions;

    CLPlatform(OpenCLLibrary.cl_platform_id platform) {
        super(platform, true);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    StringBuilder toString(StringBuilder out) {
        out.append(this.getName()).append(" {vendor: ").append(this.getVendor()).append(", version: ").append(this.getVersion()).append(", profile: ").append(this.getProfile()).append(", extensions: ").append(Arrays.toString(this.getExtensions())).append("}");
        return out;
    }

    @Override
    protected void clear() {
    }

    public CLDevice[] listAllDevices(boolean onlyAvailable) {
        return this.listDevices(CLDevice.Type.All, onlyAvailable);
    }

    public CLDevice[] listGPUDevices(boolean onlyAvailable) {
        try {
            return this.listDevices(CLDevice.Type.GPU, onlyAvailable);
        }
        catch (CLException ex) {
            if (ex.getCode() == -1) {
                return new CLDevice[0];
            }
            throw new RuntimeException("Unexpected OpenCL error", ex);
        }
    }

    public CLDevice[] listCPUDevices(boolean onlyAvailable) {
        try {
            return this.listDevices(CLDevice.Type.CPU, onlyAvailable);
        }
        catch (CLException ex) {
            if (ex.getCode() == -1) {
                return new CLDevice[0];
            }
            throw new RuntimeException("Unexpected OpenCL error", ex);
        }
    }

    private CLDevice[] getDevices(Pointer<OpenCLLibrary.cl_device_id> ids, boolean onlyAvailable) {
        CLDevice[] devices;
        int nDevs = (int)ids.getValidElements();
        if (onlyAvailable) {
            ArrayList<CLDevice> list = new ArrayList<CLDevice>(nDevs);
            for (int i = 0; i < nDevs; ++i) {
                CLDevice device = new CLDevice(this, (OpenCLLibrary.cl_device_id)((Object)ids.get((long)i)));
                if (!device.isAvailable()) continue;
                list.add(device);
            }
            devices = list.toArray(new CLDevice[list.size()]);
        } else {
            devices = new CLDevice[nDevs];
            for (int i = 0; i < nDevs; ++i) {
                devices[i] = new CLDevice(this, (OpenCLLibrary.cl_device_id)((Object)ids.get((long)i)));
            }
        }
        return devices;
    }

    static long[] getContextProps(Map<ContextProperties, Object> contextProperties) {
        if (contextProperties == null) {
            return null;
        }
        long[] properties = new long[contextProperties.size() * 2 + 1];
        int iProp = 0;
        for (Map.Entry<ContextProperties, Object> e : contextProperties.entrySet()) {
            properties[iProp++] = e.getKey().value();
            Object v = e.getValue();
            if (v instanceof Number) {
                properties[iProp++] = ((Number)v).longValue();
                continue;
            }
            if (v instanceof Pointer) {
                properties[iProp++] = ((Pointer)v).getPeer();
                continue;
            }
            throw new IllegalArgumentException("Cannot convert value " + v + " to a context property value !");
        }
        return properties;
    }

    public static CLDevice getBestDevice(List<DeviceFeature> evals, Collection<CLDevice> devices) {
        ArrayList<CLDevice> list = new ArrayList<CLDevice>(devices);
        Collections.sort(list, new DeviceComparator(evals));
        return !list.isEmpty() ? (CLDevice)list.get(list.size() - 1) : null;
    }

    public CLDevice getBestDevice() {
        return CLPlatform.getBestDevice(Arrays.asList(DeviceFeature.MaxComputeUnits), Arrays.asList(this.listGPUDevices(true)));
    }

    public CLContext createContextFromCurrentGL() {
        return this.createGLCompatibleContext(this.listAllDevices(true));
    }

    static Map<ContextProperties, Object> getGLContextProperties(CLPlatform platform) {
        LinkedHashMap<ContextProperties, Object> out = new LinkedHashMap<ContextProperties, Object>();
        if (Platform.isMacOSX()) {
            Pointer<?> context = OpenGLContextUtils.CGLGetCurrentContext();
            Pointer<?> shareGroup = OpenGLContextUtils.CGLGetShareGroup(context);
            out.put(ContextProperties.CGLShareGroupApple, shareGroup.getPeer());
        } else if (Platform.isWindows()) {
            Pointer<?> context = OpenGLContextUtils.wglGetCurrentContext();
            Pointer<?> dc = OpenGLContextUtils.wglGetCurrentDC();
            out.put(ContextProperties.GLContext, context.getPeer());
            out.put(ContextProperties.WGLHDC, dc.getPeer());
            out.put(ContextProperties.Platform, ((OpenCLLibrary.cl_platform_id)((Object)platform.getEntity())).getPeer());
        } else if (Platform.isUnix()) {
            Pointer<?> context = OpenGLContextUtils.glXGetCurrentContext();
            Pointer<?> dc = OpenGLContextUtils.glXGetCurrentDisplay();
            out.put(ContextProperties.GLContext, context.getPeer());
            out.put(ContextProperties.GLXDisplay, dc.getPeer());
            out.put(ContextProperties.Platform, ((OpenCLLibrary.cl_platform_id)((Object)platform.getEntity())).getPeer());
        } else {
            throw new UnsupportedOperationException("Current GL context retrieval not implemented on this platform !");
        }
        return out;
    }

    @Deprecated
    public CLContext createGLCompatibleContext(CLDevice ... devices) {
        try {
            return this.createContext(CLPlatform.getGLContextProperties(this), devices);
        }
        catch (Throwable th) {
            for (CLDevice device : devices) {
                if (!device.isGLSharingSupported()) continue;
                try {
                    return this.createContext(CLPlatform.getGLContextProperties(this), device);
                }
                catch (Throwable th2) {
                    // empty catch block
                }
            }
            throw new UnsupportedOperationException("Failed to create an OpenGL-sharing-enabled OpenCL context out of devices " + Arrays.asList(devices));
        }
    }

    public CLContext createContext(Map<ContextProperties, Object> contextProperties, CLDevice ... devices) {
        int nDevs = devices.length;
        if (nDevs == 0) {
            throw new IllegalArgumentException("Cannot create a context with no associated device !");
        }
        Pointer ids = Pointer.allocateTypedPointers(OpenCLLibrary.cl_device_id.class, (long)nDevs);
        for (int i = 0; i < nDevs; ++i) {
            ids.set((long)i, devices[i].getEntity());
        }
        Pointer errRef = Pointer.allocateInt();
        long[] props = CLPlatform.getContextProps(contextProperties);
        Pointer propsRef = props == null ? null : Pointer.pointerToSizeTs((long[])props);
        OpenCLLibrary.cl_context context = OpenCLLibrary.clCreateContext((Pointer<Pointer<Integer>>)propsRef, nDevs, (Pointer<OpenCLLibrary.cl_device_id>)ids, null, null, (Pointer<Integer>)errRef);
        CLException.error((Integer)errRef.get());
        return new CLContext(this, (Pointer<OpenCLLibrary.cl_device_id>)ids, context);
    }

    public CLDevice[] listDevices(CLDevice.Type type, boolean onlyAvailable) {
        Pointer pCount = Pointer.allocateInt();
        CLException.error(OpenCLLibrary.clGetDeviceIDs((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), type.value(), 0, null, (Pointer<Integer>)pCount));
        int nDevs = (Integer)pCount.get();
        if (nDevs <= 0) {
            return new CLDevice[0];
        }
        Pointer ids = Pointer.allocateTypedPointers(OpenCLLibrary.cl_device_id.class, (long)nDevs);
        CLException.error(OpenCLLibrary.clGetDeviceIDs((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), type.value(), nDevs, (Pointer<OpenCLLibrary.cl_device_id>)ids, (Pointer<Integer>)pCount));
        return this.getDevices((Pointer<OpenCLLibrary.cl_device_id>)ids, onlyAvailable);
    }

    @InfoName(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return infos.getString((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), 2304);
    }

    @InfoName(value="CL_PLATFORM_VERSION")
    public String getVersion() {
        return infos.getString((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), 2305);
    }

    @InfoName(value="CL_PLATFORM_NAME")
    public String getName() {
        return infos.getString((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), 2306);
    }

    @InfoName(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return infos.getString((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), 2307);
    }

    @InfoName(value="CL_PLATFORM_EXTENSIONS")
    public String[] getExtensions() {
        if (this.extensions == null) {
            this.extensions = infos.getString((OpenCLLibrary.cl_platform_id)((Object)this.getEntity()), 2308).split("\\s+");
        }
        return this.extensions;
    }

    boolean hasExtension(String name) {
        name = name.trim();
        for (String x : this.getExtensions()) {
            if (!name.equals(x.trim())) continue;
            return true;
        }
        return false;
    }

    @InfoName(value="cl_nv_device_attribute_query")
    public boolean isNVDeviceAttributeQuerySupported() {
        return this.hasExtension("cl_nv_device_attribute_query");
    }

    @InfoName(value="cl_nv_compiler_options")
    public boolean isNVCompilerOptionsSupported() {
        return this.hasExtension("cl_nv_compiler_options");
    }

    @InfoName(value="cl_khr_byte_addressable_store")
    public boolean isByteAddressableStoreSupported() {
        return this.hasExtension("cl_khr_byte_addressable_store");
    }

    @InfoName(value="cl_khr_gl_sharing")
    public boolean isGLSharingSupported() {
        return this.hasExtension("cl_khr_gl_sharing") || this.hasExtension("cl_APPLE_gl_sharing");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextProperties implements ValuedEnum
    {
        GLContext(8200L),
        EGLDisplay(8201L),
        GLXDisplay(8202L),
        WGLHDC(8203L),
        Platform(4228L),
        CGLShareGroupApple(0x10000000L),
        CGLShareGroup(8204L);

        long value;

        private ContextProperties(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static long getValue(EnumSet<ContextProperties> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<ContextProperties> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, ContextProperties.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeviceComparator
    implements Comparator<CLDevice> {
        private final List<DeviceFeature> evals;

        public DeviceComparator(List<DeviceFeature> evals) {
            this.evals = evals;
        }

        @Override
        public int compare(CLDevice a, CLDevice b) {
            for (DeviceFeature eval : this.evals) {
                Comparable vb;
                Comparable va;
                int c;
                if (eval == null || (c = (va = eval.extractValue(a)).compareTo(vb = eval.extractValue(b))) == 0) continue;
                return c;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeviceFeature {
        CPU{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.getType().contains(CLDevice.Type.CPU) ? 1 : 0);
            }
        }
        ,
        GPU{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.getType().contains(CLDevice.Type.GPU) ? 1 : 0);
            }
        }
        ,
        Accelerator{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.getType().contains(CLDevice.Type.Accelerator) ? 1 : 0);
            }
        }
        ,
        MaxComputeUnits{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.getMaxComputeUnits());
            }
        }
        ,
        NativeEndianness{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.getKernelsDefaultByteOrder() == ByteOrder.nativeOrder() ? 1 : 0);
            }
        }
        ,
        DoubleSupport{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.isDoubleSupported() ? 1 : 0);
            }
        }
        ,
        ImageSupport{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.hasImageSupport() ? 1 : 0);
            }
        }
        ,
        OutOfOrderQueueSupport{

            Comparable extractValue(CLDevice device) {
                return Integer.valueOf(device.hasOutOfOrderQueueSupport() ? 1 : 0);
            }
        }
        ,
        MostImageFormats{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Comparable extractValue(CLDevice device) {
                if (!device.hasImageSupport()) {
                    return Integer.valueOf(0);
                }
                CLContext context = JavaCL.createContext(null, device);
                try {
                    Integer n = context.getSupportedImageFormats(CLMem.Flags.ReadWrite, CLMem.ObjectType.Image2D).length;
                    return n;
                }
                finally {
                    context.release();
                }
            }
        };


        Comparable extractValue(CLDevice device) {
            throw new RuntimeException();
        }
    }
}

