/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.util.OpenCLType;
import com.nativelibs4java.util.IOUtils;
import com.nativelibs4java.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.Platform;
import org.bridj.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReductionUtils {
    static final int DEFAULT_MAX_REDUCTION_SIZE = 4;
    static String source;
    static final String sourcePath;

    static synchronized String getSource() throws IOException {
        InputStream in = Platform.getClassLoader(ReductionUtils.class).getResourceAsStream(sourcePath);
        if (in == null) {
            throw new FileNotFoundException(sourcePath);
        }
        source = IOUtils.readText(in);
        return source;
    }

    public static Pair<String, Map<String, Object>> getReductionCodeAndMacros(Operation op, OpenCLType valueType, int channels) throws IOException {
        String seed;
        String operation;
        LinkedHashMap<String, String> macros = new LinkedHashMap<String, String>();
        String cType = valueType.toCType() + (channels == 1 ? "" : Integer.valueOf(channels));
        macros.put("OPERAND_TYPE", cType);
        block0 : switch (op) {
            case Add: {
                operation = "_add_";
                seed = "0";
                break;
            }
            case Multiply: {
                operation = "_mul_";
                seed = "1";
                break;
            }
            case Min: {
                operation = "_min_";
                switch (valueType) {
                    case Int: {
                        seed = "2147483647";
                        break block0;
                    }
                    case Long: {
                        seed = "9223372036854775807LL";
                        break block0;
                    }
                    case Short: {
                        seed = "32767";
                        break block0;
                    }
                    case Float: {
                        seed = "MAXFLOAT";
                        break block0;
                    }
                    case Double: {
                        seed = "MAXDOUBLE";
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unhandled seed type: " + (Object)((Object)valueType));
            }
            case Max: {
                operation = "_max_";
                switch (valueType) {
                    case Int: {
                        seed = "-2147483648";
                        break block0;
                    }
                    case Long: {
                        seed = "-9223372036854775808LL";
                        break block0;
                    }
                    case Short: {
                        seed = "-32768";
                        break block0;
                    }
                    case Float: {
                        seed = "-MAXFLOAT";
                        break block0;
                    }
                    case Double: {
                        seed = "-MAXDOUBLE";
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unhandled seed type: " + (Object)((Object)valueType));
            }
            default: {
                throw new IllegalArgumentException("Unhandled operation: " + (Object)((Object)op));
            }
        }
        macros.put("OPERATION", operation);
        macros.put("SEED", seed);
        return new Pair<String, Map<String, Object>>(ReductionUtils.getSource(), macros);
    }

    static int getNextPowerOfTwo(int i) {
        int shifted = 0;
        boolean lost = false;
        while (true) {
            int next;
            if ((next = i >> 1) == 0) {
                if (lost) {
                    return 1 << shifted + 1;
                }
                return 1 << shifted;
            }
            lost = lost || next << 1 != i;
            ++shifted;
            i = next;
        }
    }

    public static <B> Reductor<B> createReductor(final CLContext context, Operation op, final OpenCLType valueType, final int valueChannels) throws CLBuildException {
        try {
            Pair<String, Map<String, Object>> codeAndMacros = ReductionUtils.getReductionCodeAndMacros(op, valueType, valueChannels);
            CLProgram program = context.createProgram(codeAndMacros.getFirst());
            program.defineMacros(codeAndMacros.getValue());
            program.build();
            CLKernel[] kernels = program.createKernels();
            if (kernels.length != 1) {
                throw new RuntimeException("Expected 1 kernel, found : " + kernels.length);
            }
            final CLKernel kernel = kernels[0];
            return new Reductor<B>(){

                @Override
                public int getChannels() {
                    return valueChannels;
                }

                @Override
                public CLEvent reduce(CLQueue queue, CLBuffer<B> input, long inputLength, Pointer<B> output, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    Pair outAndEvts = this.reduceHelper(queue, input, (int)inputLength, maxReductionSize, eventsToWaitFor);
                    return outAndEvts.getFirst().read(queue, 0L, (long)valueChannels, output, false, outAndEvts.getSecond());
                }

                @Override
                public Pointer<B> reduce(CLQueue queue, CLBuffer<B> input, long inputLength, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    Pointer output = Pointer.allocateArray(valueType.type, (long)valueChannels).order(context.getByteOrder());
                    CLEvent evt = this.reduce(queue, input, inputLength, output, maxReductionSize, eventsToWaitFor);
                    evt.waitFor();
                    return output;
                }

                @Override
                public Pointer<B> reduce(CLQueue queue, CLBuffer<B> input, CLEvent ... eventsToWaitFor) {
                    return this.reduce(queue, input, input.getElementCount(), 4, eventsToWaitFor);
                }

                @Override
                public CLEvent reduce(CLQueue queue, CLBuffer<B> input, long inputLength, CLBuffer<B> output, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    Pair outAndEvts = this.reduceHelper(queue, input, (int)inputLength, maxReductionSize, eventsToWaitFor);
                    return outAndEvts.getFirst().copyTo(queue, 0L, valueChannels, output, 0L, outAndEvts.getSecond());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Pair<CLBuffer<B>, CLEvent[]> reduceHelper(CLQueue queue, CLBuffer<B> input, int inputLength, int maxReductionSize, CLEvent ... eventsToWaitFor) {
                    if (inputLength == 1) {
                        return new Pair(input, new CLEvent[0]);
                    }
                    if (inputLength == 1) {
                        return new Pair(input, new CLEvent[0]);
                    }
                    CLBuffer[] tempBuffers = new CLBuffer[2];
                    int depth = 0;
                    CLBuffer<?> currentOutput = null;
                    CLEvent[] eventsArr = new CLEvent[1];
                    int[] blockCountArr = new int[1];
                    int maxWIS = (int)queue.getDevice().getMaxWorkItemSizes()[0];
                    while (inputLength > 1) {
                        int blocksInCurrentDepth = inputLength / maxReductionSize;
                        if (inputLength > blocksInCurrentDepth * maxReductionSize) {
                            ++blocksInCurrentDepth;
                        }
                        int iOutput = depth & 1;
                        CLBuffer currentInput = depth == 0 ? input : tempBuffers[iOutput ^ 1];
                        currentOutput = tempBuffers[iOutput];
                        if (currentOutput == null) {
                            currentOutput = tempBuffers[iOutput] = context.createBuffer(CLMem.Usage.InputOutput, valueType.type, (long)(blocksInCurrentDepth * valueChannels));
                        }
                        CLKernel cLKernel = kernel;
                        synchronized (cLKernel) {
                            kernel.setArgs(currentInput, blocksInCurrentDepth, inputLength, maxReductionSize, currentOutput);
                            int workgroupSize = blocksInCurrentDepth;
                            if (workgroupSize == 1) {
                                workgroupSize = 2;
                            }
                            blockCountArr[0] = workgroupSize;
                            eventsArr[0] = kernel.enqueueNDRange(queue, blockCountArr, (int[])null, eventsToWaitFor);
                        }
                        eventsToWaitFor = eventsArr;
                        inputLength = blocksInCurrentDepth;
                        ++depth;
                    }
                    return new Pair<Object, CLEvent[]>(currentOutput, eventsToWaitFor);
                }
            };
        }
        catch (IOException ex) {
            Logger.getLogger(ReductionUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Failed to create a " + (Object)((Object)op) + " reductor for type " + (Object)((Object)valueType) + valueChannels, ex);
        }
    }

    static {
        sourcePath = ReductionUtils.class.getPackage().getName().replace('.', '/') + "/" + "Reduction.c";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Reductor<B> {
        public int getChannels();

        public CLEvent reduce(CLQueue var1, CLBuffer<B> var2, long var3, CLBuffer<B> var5, int var6, CLEvent ... var7);

        public Pointer<B> reduce(CLQueue var1, CLBuffer<B> var2, long var3, int var5, CLEvent ... var6);

        public CLEvent reduce(CLQueue var1, CLBuffer<B> var2, long var3, Pointer<B> var5, int var6, CLEvent ... var7);

        public Pointer<B> reduce(CLQueue var1, CLBuffer<B> var2, CLEvent ... var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        Add,
        Multiply,
        Min,
        Max;

    }
}

