/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util.fft;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.util.Transformer;
import java.util.HashMap;
import java.util.Map;
import org.bridj.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFFTPow2<T, A>
extends Transformer.AbstractTransformer<T, A> {
    private Map<Integer, CLBuffer<Integer>> cachedOffsetsBufs = new HashMap<Integer, CLBuffer<Integer>>();
    Map<Integer, CLBuffer<T>> cachedTwiddleFactors = new HashMap<Integer, CLBuffer<T>>();

    AbstractFFTPow2(CLContext context, Class<T> primitiveClass) {
        super(context, primitiveClass);
    }

    protected synchronized CLBuffer<Integer> getOffsetsBuf(int length) {
        CLBuffer<Integer> offsetsBuf = this.cachedOffsetsBufs.get(length);
        if (offsetsBuf == null) {
            int[] offsets = new int[length];
            this.fft_compute_offsetsX(offsets, length, 1, 0, 0);
            offsetsBuf = this.context.createBuffer(CLMem.Usage.InputOutput, Pointer.pointerToInts((int[])offsets), true);
            this.cachedOffsetsBufs.put(length, offsetsBuf);
        }
        return offsetsBuf;
    }

    protected abstract CLEvent cooleyTukeyFFTTwiddleFactors(CLQueue var1, int var2, CLBuffer<T> var3, CLEvent ... var4) throws CLException;

    protected abstract CLEvent cooleyTukeyFFTCopy(CLQueue var1, CLBuffer<T> var2, CLBuffer<T> var3, int var4, CLBuffer<Integer> var5, boolean var6, CLEvent ... var7) throws CLException;

    protected abstract CLEvent cooleyTukeyFFT(CLQueue var1, CLBuffer<T> var2, int var3, CLBuffer<T> var4, int var5, int[] var6, CLEvent ... var7) throws CLException;

    protected synchronized CLBuffer<T> getTwiddleFactorsBuf(CLQueue queue, int N) throws CLException {
        CLBuffer<T> buf = this.cachedTwiddleFactors.get(N);
        if (buf == null) {
            int halfN = N / 2;
            buf = this.context.createBuffer(CLMem.Usage.InputOutput, this.primitiveClass, (long)N);
            CLEvent.waitFor(this.cooleyTukeyFFTTwiddleFactors(queue, N, buf, new CLEvent[0]));
            this.cachedTwiddleFactors.put(N, buf);
        }
        return buf;
    }

    private void fft_compute_offsetsX(int[] offsetsX, int N, int s, int offsetX, int offsetY) {
        if (N == 1) {
            offsetsX[offsetY] = offsetX;
        } else {
            int halfN = N / 2;
            int twiceS = s * 2;
            this.fft_compute_offsetsX(offsetsX, halfN, twiceS, offsetX, offsetY);
            this.fft_compute_offsetsX(offsetsX, halfN, twiceS, offsetX + s, offsetY + halfN);
        }
    }

    @Override
    public CLEvent transform(CLQueue queue, CLBuffer<T> inBuf, CLBuffer<T> outBuf, boolean inverse, CLEvent ... eventsToWaitFor) throws CLException {
        int length = (int)inBuf.getElementCount() / 2;
        if (Integer.bitCount(length) != 1) {
            throw new UnsupportedOperationException("Only supports FFTs of power-of-two-sized arrays (was given array of length " + length + ")");
        }
        CLBuffer<Integer> offsetsBuf = this.getOffsetsBuf(length);
        CLEvent copyEvt = this.cooleyTukeyFFTCopy(queue, inBuf, outBuf, length, offsetsBuf, inverse, eventsToWaitFor);
        CLEvent dftEvt = this.fft(queue, inBuf, length, 1, inverse ? 1 : 0, 1, outBuf, copyEvt);
        return dftEvt;
    }

    private CLEvent fft(CLQueue queue, CLBuffer<T> X, int N, int s, int inverse, int blocks, CLBuffer<T> Y, CLEvent ... eventsToWaitFor) throws CLException {
        if (N == 1) {
            return null;
        }
        int halfN = N / 2;
        int twiceS = s * 2;
        CLEvent[] evts = halfN > 1 ? new CLEvent[]{this.fft(queue, X, halfN, twiceS, inverse, blocks * 2, Y, eventsToWaitFor)} : eventsToWaitFor;
        return this.cooleyTukeyFFT(queue, Y, N, this.getTwiddleFactorsBuf(queue, N), inverse, new int[]{halfN, blocks}, evts);
    }
}

