/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util.fft;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.util.fft.AbstractFFTPow2;
import com.nativelibs4java.opencl.util.fft.FloatFFTProgram;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatFFTPow2
extends AbstractFFTPow2<Float, float[]> {
    final FloatFFTProgram program;

    public FloatFFTPow2(CLContext context) throws IOException {
        super(context, Float.class);
        this.program = new FloatFFTProgram(context);
        this.program.getProgram().setFastRelaxedMath();
    }

    public FloatFFTPow2() throws IOException {
        this(JavaCL.createBestContext());
    }

    @Override
    protected CLEvent cooleyTukeyFFTTwiddleFactors(CLQueue queue, int N, CLBuffer<Float> buf, CLEvent ... evts) throws CLException {
        return this.program.cooleyTukeyFFTTwiddleFactors(queue, N, buf, new int[]{N / 2}, null, evts);
    }

    @Override
    protected CLEvent cooleyTukeyFFTCopy(CLQueue queue, CLBuffer<Float> inBuf, CLBuffer<Float> outBuf, int length, CLBuffer<Integer> offsetsBuf, boolean inverse, CLEvent ... evts) throws CLException {
        return this.program.cooleyTukeyFFTCopy(queue, inBuf, outBuf, length, offsetsBuf, inverse ? 1.0f / (float)length : 1.0f, new int[]{length}, null, evts);
    }

    @Override
    protected CLEvent cooleyTukeyFFT(CLQueue queue, CLBuffer<Float> Y, int N, CLBuffer<Float> twiddleFactors, int inverse, int[] dims, CLEvent ... evts) throws CLException {
        return this.program.cooleyTukeyFFT(queue, Y, N, twiddleFactors, inverse, dims, null, evts);
    }
}

