/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.StringBuilder;

class TextMarkup {
    private static final Color tempColor = new Color();
    private static final StringBuilder tempColorBuffer = new StringBuilder();
    private static Pool<ColorChunk> colorChunkPool;
    private static Application app;
    private Array<ColorChunk> colorChunks = new Array();
    private Array<Color> currentColorStack = new Array();
    private Color lastColor = Color.WHITE;
    private Color defaultColor = Color.WHITE;

    public int parseColorTag(CharSequence str, int nomarkupStart, int start, int end) {
        block18: {
            if (start >= end) break block18;
            Color hexColor = tempColor;
            if (str.charAt(start) == '#') {
                int colorInt = 0;
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) {
                            return -1;
                        }
                        if (i <= start + 7) {
                            Color.rgb888ToColor(hexColor, colorInt);
                            hexColor.a = 1.0f;
                        } else {
                            Color.rgba8888ToColor(hexColor, colorInt);
                        }
                        if (nomarkupStart >= 0) {
                            this.beginChunk(hexColor, nomarkupStart);
                        }
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                        continue;
                    }
                    if (ch >= 'A' && ch <= 'F') {
                        colorInt = colorInt * 16 + (ch - 55);
                        continue;
                    }
                    return -1;
                }
            } else {
                tempColorBuffer.setLength(0);
                for (int i = start; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i == start) {
                            if (nomarkupStart >= 0) {
                                this.endChunk(nomarkupStart);
                            }
                        } else {
                            String colorString = tempColorBuffer.toString();
                            Color newColor = Colors.get(colorString);
                            if (newColor == null) {
                                return -1;
                            }
                            if (nomarkupStart >= 0) {
                                this.beginChunk(newColor, nomarkupStart);
                            }
                        }
                        return i - start;
                    }
                    tempColorBuffer.append(ch);
                }
            }
        }
        return -1;
    }

    public TextMarkup() {
        if (Gdx.app != app) {
            colorChunkPool = new Pool<ColorChunk>(32){

                @Override
                protected ColorChunk newObject() {
                    return new ColorChunk();
                }
            };
            app = Gdx.app;
        }
    }

    public void beginChunk(Color color, int start) {
        ColorChunk newChunk = colorChunkPool.obtain();
        newChunk.color.set(color);
        newChunk.start = start;
        this.colorChunks.add(newChunk);
        this.currentColorStack.add(this.lastColor);
        this.lastColor = newChunk.color;
    }

    public void endChunk(int start) {
        if (this.currentColorStack.size > 0) {
            this.lastColor = this.currentColorStack.pop();
            ColorChunk newChunk = colorChunkPool.obtain();
            newChunk.color.set(this.lastColor);
            newChunk.start = start;
            this.colorChunks.add(newChunk);
        }
    }

    public void tint(BitmapFontCache cache, Color tint) {
        int current = 0;
        float floatColor = tempColor.set(this.defaultColor).mul(tint).toFloatBits();
        for (ColorChunk chunk : this.colorChunks) {
            int next = chunk.start;
            if (current < next) {
                cache.setColors(floatColor, current, next);
                current = next;
            }
            floatColor = tempColor.set(chunk.color).mul(tint).toFloatBits();
        }
        int charsCount = cache.getCharsCount();
        if (current < charsCount) {
            cache.setColors(floatColor, current, charsCount);
        }
    }

    public void clear() {
        int size = this.colorChunks.size;
        for (int i = 0; i < size; ++i) {
            colorChunkPool.free(this.colorChunks.get(i));
            this.colorChunks.set(i, null);
        }
        this.colorChunks.size = 0;
        this.currentColorStack.clear();
        this.setDefaultChunk(this.defaultColor, 0);
    }

    public Color getLastColor() {
        return this.lastColor;
    }

    private void setDefaultColor(Color defaultColor) {
        if (this.currentColorStack.size == 0) {
            this.defaultColor = defaultColor;
            this.lastColor = defaultColor;
        }
    }

    public void setDefaultChunk(float color, int start) {
        int abgr = NumberUtils.floatToIntColor(color);
        this.setDefaultChunk(abgr, start);
    }

    public void setDefaultChunk(int abgr, int start) {
        ColorChunk newChunk = colorChunkPool.obtain();
        Color color = newChunk.color;
        color.r = (float)(abgr & 0xFF) / 255.0f;
        color.g = (float)(abgr >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(abgr >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(abgr >>> 24 & 0xFF) / 255.0f;
        newChunk.start = start;
        this.colorChunks.add(newChunk);
        this.setDefaultColor(newChunk.color);
    }

    public void setDefaultChunk(Color color, int start) {
        ColorChunk newChunk = colorChunkPool.obtain();
        newChunk.color.set(color);
        newChunk.start = start;
        this.colorChunks.add(newChunk);
        this.setDefaultColor(newChunk.color);
    }

    static {
        app = null;
    }

    public static class ColorChunk {
        public int start;
        public final Color color = new Color();
    }
}

