/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.SIU_S12_PIDPD1PV1PV2OBXDG1;
import ca.uhn.hl7v2.model.v231.group.SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.SCH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIU_S12
extends AbstractMessage {
    public SIU_S12() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public SIU_S12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SCH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(SIU_S12_PIDPD1PV1PV2OBXDG1.class, false, true);
            this.add(SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SIU_S12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SCH getSCH() {
        return (SCH)this.getTyped("SCH", SCH.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 getPIDPD1PV1PV2OBXDG1() {
        return (SIU_S12_PIDPD1PV1PV2OBXDG1)this.getTyped("PIDPD1PV1PV2OBXDG1", SIU_S12_PIDPD1PV1PV2OBXDG1.class);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 getPIDPD1PV1PV2OBXDG1(int rep) {
        return (SIU_S12_PIDPD1PV1PV2OBXDG1)this.getTyped("PIDPD1PV1PV2OBXDG1", rep, SIU_S12_PIDPD1PV1PV2OBXDG1.class);
    }

    public int getPIDPD1PV1PV2OBXDG1Reps() {
        return this.getReps("PIDPD1PV1PV2OBXDG1");
    }

    public List<SIU_S12_PIDPD1PV1PV2OBXDG1> getPIDPD1PV1PV2OBXDG1All() throws HL7Exception {
        return this.getAllAsList("PIDPD1PV1PV2OBXDG1", SIU_S12_PIDPD1PV1PV2OBXDG1.class);
    }

    public void insertPIDPD1PV1PV2OBXDG1(SIU_S12_PIDPD1PV1PV2OBXDG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("PIDPD1PV1PV2OBXDG1", (Structure)structure, rep);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 insertPIDPD1PV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SIU_S12_PIDPD1PV1PV2OBXDG1)super.insertRepetition("PIDPD1PV1PV2OBXDG1", rep);
    }

    public SIU_S12_PIDPD1PV1PV2OBXDG1 removePIDPD1PV1PV2OBXDG1(int rep) throws HL7Exception {
        return (SIU_S12_PIDPD1PV1PV2OBXDG1)super.removeRepetition("PIDPD1PV1PV2OBXDG1", rep);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE getRGSAISNTEAIGNTEAILNTEAIPNTE() {
        return (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)this.getTyped("RGSAISNTEAIGNTEAILNTEAIPNTE", SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE.class);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE getRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) {
        return (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)this.getTyped("RGSAISNTEAIGNTEAILNTEAIPNTE", rep, SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE.class);
    }

    public int getRGSAISNTEAIGNTEAILNTEAIPNTEReps() {
        return this.getReps("RGSAISNTEAIGNTEAILNTEAIPNTE");
    }

    public List<SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE> getRGSAISNTEAIGNTEAILNTEAIPNTEAll() throws HL7Exception {
        return this.getAllAsList("RGSAISNTEAIGNTEAILNTEAIPNTE", SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE.class);
    }

    public void insertRGSAISNTEAIGNTEAILNTEAIPNTE(SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", (Structure)structure, rep);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE insertRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) throws HL7Exception {
        return (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)super.insertRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
    }

    public SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE removeRGSAISNTEAIGNTEAILNTEAIPNTE(int rep) throws HL7Exception {
        return (SIU_S12_RGSAISNTEAIGNTEAILNTEAIPNTE)super.removeRepetition("RGSAISNTEAIGNTEAILNTEAIPNTE", rep);
    }
}

