/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net;

import java.io.IOException;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.pdu.AAbort;
import org.dcm4che2.net.pdu.AAssociateAC;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.pdu.AAssociateRQ;

public class State {
    public static final State STA1 = new Sta1();
    public static final State STA2 = new Sta2();
    public static final State STA3 = new Sta3();
    public static final State STA4 = new Sta4();
    public static final State STA5 = new Sta5();
    public static final State STA6 = new Sta6();
    public static final State STA7 = new Sta7();
    public static final State STA8 = new Sta8();
    public static final State STA10 = new Sta10();
    public static final State STA11 = new Sta11();
    public static final State STA13 = new Sta13();
    protected final String name;

    State(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    void receivedAssociateRQ(Association as, AAssociateRQ rq) throws IOException {
        as.unexpectedPDU("A-ASSOCIATE-RQ");
    }

    void receivedAssociateAC(Association as, AAssociateAC ac) throws IOException {
        as.unexpectedPDU("A-ASSOCIATE-AC");
    }

    void receivedAssociateRJ(Association as, AAssociateRJ rj) throws IOException {
        as.unexpectedPDU("A-ASSOCIATE-RJ");
    }

    void receivedPDataTF(Association as) throws IOException {
        as.unexpectedPDU("P-DATA-TF");
    }

    void receivedReleaseRQ(Association as) throws IOException {
        as.unexpectedPDU("A-RELEASE-RQ");
    }

    void receivedReleaseRP(Association as) throws IOException {
        as.unexpectedPDU("A-RELEASE-RP");
    }

    void sendAssociateRQ(Association as, AAssociateRQ rq) throws IOException {
        throw new IllegalStateException(this.toString());
    }

    void sendPDataTF(Association as) throws IOException {
        as.illegalStateForSending("P-DATA-TF");
    }

    void sendReleaseRQ(Association as) throws IOException {
        as.illegalStateForSending("A-RELEASE-RQ");
    }

    void abort(Association as, AAbort aa) {
        as.writeAbort(aa);
    }

    boolean isReadyForDataTransfer() {
        return false;
    }

    boolean isReadyForDataSend() {
        return false;
    }

    boolean isReadyForDataReceive() {
        return false;
    }

    private static class Sta13
    extends State {
        public Sta13() {
            super("Sta13 ");
        }

        void abort(Association as, AAbort aa) {
        }
    }

    private static class Sta11
    extends State {
        public Sta11() {
            super("Sta11");
        }

        void receivedReleaseRP(Association as) throws IOException {
            as.onReleaseRP();
        }
    }

    private static class Sta10
    extends State {
        public Sta10() {
            super("Sta10");
        }

        void receivedReleaseRP(Association as) throws IOException {
            as.onCollisionReleaseRP();
        }
    }

    private static class Sta8
    extends State {
        public Sta8() {
            super("Sta8");
        }

        void sendPDataTF(Association as) throws IOException {
            as.writePDataTF();
        }

        boolean isReadyForDataSend() {
            return true;
        }
    }

    private static class Sta7
    extends State {
        Sta7() {
            super("Sta7");
        }

        void receivedPDataTF(Association as) throws IOException {
            as.onPDataTF();
        }

        void receivedReleaseRQ(Association as) throws IOException {
            as.onCollisionReleaseRQ();
        }

        void receivedReleaseRP(Association as) throws IOException {
            as.onReleaseRP();
        }

        boolean isReadyForDataReceive() {
            return true;
        }
    }

    private static class Sta6
    extends State {
        Sta6() {
            super("Sta6");
        }

        void receivedPDataTF(Association as) throws IOException {
            as.onPDataTF();
        }

        void sendPDataTF(Association as) throws IOException {
            as.writePDataTF();
        }

        void receivedReleaseRQ(Association as) throws IOException {
            as.onReleaseRQ();
        }

        void sendReleaseRQ(Association as) throws IOException {
            as.writeReleaseRQ();
        }

        boolean isReadyForDataTransfer() {
            return true;
        }

        boolean isReadyForDataSend() {
            return true;
        }

        boolean isReadyForDataReceive() {
            return true;
        }
    }

    private static class Sta5
    extends State {
        Sta5() {
            super("Sta5");
        }

        void receivedAssociateAC(Association as, AAssociateAC ac) throws IOException {
            as.onAssociateAC(ac);
        }

        void receivedAssociateRJ(Association as, AAssociateRJ rj) throws IOException {
            as.onAssociateRJ(rj);
        }
    }

    private static class Sta4
    extends State {
        Sta4() {
            super("Sta4");
        }

        void sendAssociateRQ(Association as, AAssociateRQ rq) throws IOException {
            as.writeAssociationRQ(rq);
        }
    }

    private static class Sta3
    extends State {
        Sta3() {
            super("Sta3");
        }
    }

    private static class Sta2
    extends State {
        Sta2() {
            super("Sta2");
        }

        void receivedAssociateRQ(Association as, AAssociateRQ rq) throws IOException {
            as.onAAssociateRQ(rq);
        }
    }

    private static class Sta1
    extends State {
        Sta1() {
            super("Sta1");
        }

        void abort(Association as, AAbort aa) {
        }
    }
}

