/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.net.pdu;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonExtendedNegotiation {
    private String sopCUID;
    private String serviceCUID;
    private final Set<String> relSopCUIDs = new LinkedHashSet<String>();

    public final String getSOPClassUID() {
        return this.sopCUID;
    }

    public final void setSOPClassUID(String sopCUID) {
        this.sopCUID = sopCUID;
    }

    public final String getServiceClassUID() {
        return this.serviceCUID;
    }

    public final void setServiceClassUID(String serviceCUID) {
        this.serviceCUID = serviceCUID;
    }

    public final Collection<String> getRelatedGeneralSOPClassUIDs() {
        return Collections.unmodifiableCollection(this.relSopCUIDs);
    }

    public final boolean addRelatedGeneralSOPClassUID(String relSopCUID) {
        if (relSopCUID == null) {
            throw new NullPointerException();
        }
        return this.relSopCUIDs.add(relSopCUID);
    }

    public final boolean removeRelatedGeneralSOPClassUID(String relSopCUID) {
        return this.relSopCUIDs.remove(relSopCUID);
    }

    public int length() {
        if (this.sopCUID == null || this.serviceCUID == null) {
            throw new IllegalStateException();
        }
        int len = 4 + this.sopCUID.length() + this.serviceCUID.length();
        for (String cuid : this.relSopCUIDs) {
            len += 2 + cuid.length();
        }
        return len;
    }
}

