/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.CommandFailureException;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.Mongo;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.QueryResultIterator;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DB {
    private static final Set<String> _obedientCommands = new HashSet<String>();
    final Mongo _mongo;
    final String _name;
    @Deprecated
    protected boolean _readOnly = false;
    private WriteConcern _concern;
    private ReadPreference _readPref;
    final Bytes.OptionHolder _options;
    private volatile CommandResult authenticationTestCommandResult;

    public DB(Mongo mongo, String name) {
        if (!this.isValidName(name)) {
            throw new IllegalArgumentException("Invalid database name format. Database name is either empty or it contains spaces.");
        }
        this._mongo = mongo;
        this._name = name;
        this._options = new Bytes.OptionHolder(this._mongo._netOptions);
    }

    ReadPreference getCommandReadPreference(DBObject command, ReadPreference requestedPreference) {
        boolean primaryRequired;
        if (this._mongo.getReplicaSetStatus() == null) {
            return requestedPreference;
        }
        String comString = command.keySet().iterator().next();
        if (comString.equals("getnonce") || comString.equals("authenticate")) {
            return ReadPreference.primaryPreferred();
        }
        if (comString.equals("mapreduce")) {
            BSONObject outMap;
            Object out = command.get("out");
            primaryRequired = out instanceof BSONObject ? (outMap = (BSONObject)out).get("inline") == null : true;
        } else if (comString.equals("aggregate")) {
            List pipeline = (List)command.get("pipeline");
            primaryRequired = ((DBObject)pipeline.get(pipeline.size() - 1)).get("$out") != null;
        } else {
            boolean bl = primaryRequired = !_obedientCommands.contains(comString.toLowerCase());
        }
        if (primaryRequired) {
            return ReadPreference.primary();
        }
        if (requestedPreference == null) {
            return ReadPreference.primary();
        }
        return requestedPreference;
    }

    public abstract void requestStart();

    public abstract void requestDone();

    public abstract void requestEnsureConnection();

    protected abstract DBCollection doGetCollection(String var1);

    public DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        return c;
    }

    public DBCollection createCollection(String name, DBObject options) {
        if (options != null) {
            BasicDBObject createCmd = new BasicDBObject("create", name);
            createCmd.putAll(options);
            CommandResult result = this.command(createCmd);
            result.throwOnError();
        }
        return this.getCollection(name);
    }

    public DBCollection getCollectionFromString(String s) {
        DBCollection foo = null;
        int idx = s.indexOf(".");
        while (idx >= 0) {
            String b = s.substring(0, idx);
            s = s.substring(idx + 1);
            foo = foo == null ? this.getCollection(b) : foo.getCollection(b);
            idx = s.indexOf(".");
        }
        if (foo != null) {
            return foo.getCollection(s);
        }
        return this.getCollection(s);
    }

    public CommandResult command(DBObject cmd) {
        return this.command(cmd, 0);
    }

    public CommandResult command(DBObject cmd, DBEncoder encoder) {
        return this.command(cmd, 0, encoder);
    }

    @Deprecated
    public CommandResult command(DBObject cmd, int options, DBEncoder encoder) {
        return this.command(cmd, options, this.getReadPreference(), encoder);
    }

    @Deprecated
    public CommandResult command(DBObject cmd, int options, ReadPreference readPreference) {
        return this.command(cmd, options, readPreference, DefaultDBEncoder.FACTORY.create());
    }

    @Deprecated
    public CommandResult command(DBObject cmd, int options, ReadPreference readPreference, DBEncoder encoder) {
        ReadPreference effectiveReadPrefs = this.getCommandReadPreference(cmd, readPreference);
        cmd = this.wrapCommand(cmd, effectiveReadPrefs);
        QueryResultIterator i = this.getCollection("$cmd").find(cmd, new BasicDBObject(), 0, -1, 0, options, effectiveReadPrefs, DefaultDBDecoder.FACTORY.create(), encoder);
        if (!i.hasNext()) {
            return null;
        }
        CommandResult cr = new CommandResult(i.getServerAddress());
        cr.putAll(i.next());
        return cr;
    }

    public CommandResult command(DBObject cmd, ReadPreference readPreference, DBEncoder encoder) {
        return this.command(cmd, 0, readPreference, encoder);
    }

    private DBObject wrapCommand(DBObject cmd, ReadPreference readPreference) {
        if (this.getMongo().isMongosConnection() && !ReadPreference.primary().equals(readPreference) && !ReadPreference.secondaryPreferred().equals(readPreference) && cmd instanceof BasicDBObject) {
            cmd = new BasicDBObject("$query", cmd).append("$readPreference", readPreference.toDBObject());
        }
        return cmd;
    }

    @Deprecated
    public CommandResult command(DBObject cmd, int options) {
        return this.command(cmd, options, this.getReadPreference());
    }

    public CommandResult command(DBObject cmd, ReadPreference readPreference) {
        return this.command(cmd, 0, readPreference);
    }

    public CommandResult command(String cmd) {
        return this.command(new BasicDBObject(cmd, Boolean.TRUE));
    }

    @Deprecated
    public CommandResult command(String cmd, int options) {
        return this.command((DBObject)new BasicDBObject(cmd, Boolean.TRUE), options);
    }

    public CommandResult command(String cmd, ReadPreference readPreference) {
        return this.command((DBObject)new BasicDBObject(cmd, Boolean.TRUE), 0, readPreference);
    }

    public CommandResult doEval(String code, Object ... args) {
        return this.command(BasicDBObjectBuilder.start().add("$eval", code).add("args", args).get());
    }

    public Object eval(String code, Object ... args) {
        CommandResult res = this.doEval(code, args);
        res.throwOnError();
        return res.get("retval");
    }

    public CommandResult getStats() {
        CommandResult result = this.command("dbstats");
        result.throwOnError();
        return result;
    }

    public String getName() {
        return this._name;
    }

    @Deprecated
    public void setReadOnly(Boolean b) {
        this._readOnly = b;
    }

    public Set<String> getCollectionNames() {
        DBCollection namespaces = this.getCollection("system.namespaces");
        if (namespaces == null) {
            throw new RuntimeException("this is impossible");
        }
        QueryResultIterator i = namespaces.find(new BasicDBObject(), null, 0, 0, 0, this.getOptions(), this.getReadPreference(), null);
        if (i == null) {
            return new HashSet<String>();
        }
        ArrayList<String> tables = new ArrayList<String>();
        while (i.hasNext()) {
            int idx;
            DBObject o = (DBObject)i.next();
            if (o.get("name") == null) {
                throw new MongoException("how is name null : " + o);
            }
            String n = o.get("name").toString();
            String root = n.substring(0, idx = n.indexOf("."));
            if (!root.equals(this._name) || n.indexOf("$") >= 0) continue;
            String table = n.substring(idx + 1);
            tables.add(table);
        }
        Collections.sort(tables);
        return new LinkedHashSet<String>(tables);
    }

    public boolean collectionExists(String collectionName) {
        if (collectionName == null || "".equals(collectionName)) {
            return false;
        }
        Set<String> collections = this.getCollectionNames();
        if (collections.isEmpty()) {
            return false;
        }
        for (String collection : collections) {
            if (!collectionName.equalsIgnoreCase(collection)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._name;
    }

    @Deprecated
    public CommandResult getLastError() {
        return this.command(new BasicDBObject("getlasterror", (Object)1));
    }

    @Deprecated
    public CommandResult getLastError(WriteConcern concern) {
        return this.command(concern.getCommand());
    }

    @Deprecated
    public CommandResult getLastError(int w, int wtimeout, boolean fsync) {
        return this.command(new WriteConcern(w, wtimeout, fsync).getCommand());
    }

    public void setWriteConcern(WriteConcern concern) {
        if (concern == null) {
            throw new IllegalArgumentException();
        }
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._mongo.getWriteConcern();
    }

    public void setReadPreference(ReadPreference preference) {
        this._readPref = preference;
    }

    public ReadPreference getReadPreference() {
        if (this._readPref != null) {
            return this._readPref;
        }
        return this._mongo.getReadPreference();
    }

    public void dropDatabase() {
        CommandResult res = this.command(new BasicDBObject("dropDatabase", (Object)1));
        res.throwOnError();
        this._mongo._dbs.remove(this.getName());
    }

    @Deprecated
    public boolean isAuthenticated() {
        return this.getAuthenticationCredentials() != null;
    }

    @Deprecated
    public boolean authenticate(String username, char[] password) {
        return this.authenticateCommandHelper((String)username, (char[])password).failure == null;
    }

    @Deprecated
    public synchronized CommandResult authenticateCommand(String username, char[] password) {
        CommandResultPair commandResultPair = this.authenticateCommandHelper(username, password);
        if (commandResultPair.failure != null) {
            throw commandResultPair.failure;
        }
        return commandResultPair.result;
    }

    private CommandResultPair authenticateCommandHelper(String username, char[] password) {
        MongoCredential credentials = MongoCredential.createMongoCRCredential(username, this.getName(), password);
        if (this.getAuthenticationCredentials() != null) {
            if (this.getAuthenticationCredentials().equals(credentials)) {
                if (this.authenticationTestCommandResult != null) {
                    return new CommandResultPair(this.authenticationTestCommandResult);
                }
            } else {
                throw new IllegalStateException("can't authenticate twice on the same database");
            }
        }
        try {
            this.authenticationTestCommandResult = this.doAuthenticate(credentials);
            return new CommandResultPair(this.authenticationTestCommandResult);
        }
        catch (CommandFailureException commandFailureException) {
            return new CommandResultPair(commandFailureException);
        }
    }

    abstract CommandResult doAuthenticate(MongoCredential var1);

    @Deprecated
    public WriteResult addUser(String username, char[] passwd) {
        return this.addUser(username, passwd, false);
    }

    @Deprecated
    public WriteResult addUser(String username, char[] passwd, boolean readOnly) {
        DBCollection c = this.getCollection("system.users");
        DBObject o = c.findOne(new BasicDBObject("user", username));
        if (o == null) {
            o = new BasicDBObject("user", username);
        }
        o.put("pwd", this._hash(username, passwd));
        o.put("readOnly", readOnly);
        return c.save(o);
    }

    @Deprecated
    public WriteResult removeUser(String username) {
        DBCollection c = this.getCollection("system.users");
        return c.remove(new BasicDBObject("user", username));
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    @Deprecated
    public CommandResult getPreviousError() {
        return this.command(new BasicDBObject("getpreverror", (Object)1));
    }

    @Deprecated
    public void resetError() {
        this.command(new BasicDBObject("reseterror", (Object)1));
    }

    @Deprecated
    public void forceError() {
        this.command(new BasicDBObject("forceerror", (Object)1));
    }

    public Mongo getMongo() {
        return this._mongo;
    }

    public DB getSisterDB(String name) {
        return this._mongo.getDB(name);
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._options.add(option);
    }

    public void setOptions(int options) {
        this._options.set(options);
    }

    public void resetOptions() {
        this._options.reset();
    }

    public int getOptions() {
        return this._options.get();
    }

    private boolean isValidName(String dbname) {
        return dbname.length() != 0 && !dbname.contains(" ");
    }

    @Deprecated
    public abstract void cleanCursors(boolean var1);

    MongoCredential getAuthenticationCredentials() {
        return this.getMongo().getAuthority().getCredentialsStore().get(this.getName());
    }

    static {
        _obedientCommands.add("group");
        _obedientCommands.add("aggregate");
        _obedientCommands.add("collstats");
        _obedientCommands.add("dbstats");
        _obedientCommands.add("count");
        _obedientCommands.add("distinct");
        _obedientCommands.add("geonear");
        _obedientCommands.add("geosearch");
        _obedientCommands.add("geowalk");
        _obedientCommands.add("text");
        _obedientCommands.add("parallelcollectionscan");
    }

    class CommandResultPair {
        CommandResult result;
        CommandFailureException failure;

        public CommandResultPair(CommandResult result) {
            this.result = result;
        }

        public CommandResultPair(CommandFailureException failure) {
            this.failure = failure;
        }
    }
}

