/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.Connection;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.DBPortPool;
import com.mongodb.Mongo;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.NativeAuthenticationHelper;
import com.mongodb.OutMessage;
import com.mongodb.PooledConnectionProvider;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.bson.util.Assertions;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DBPort
implements Connection {
    public static final int PORT = 27017;
    static final boolean USE_NAGLE = false;
    static final long CONN_RETRY_TIME_MS = 15000L;
    private static Logger _rootLogger = Logger.getLogger("com.mongodb.port");
    private volatile boolean closed;
    private final long openedAt;
    private volatile long lastUsedAt;
    private final int generation;
    private final PooledConnectionProvider provider;
    private final ServerAddress _sa;
    private final ServerAddress _addr;
    private final MongoOptions _options;
    private final Logger _logger;
    private final DBDecoder _decoder;
    private volatile Socket _socket;
    private volatile InputStream _in;
    private volatile OutputStream _out;
    private final Set<String> authenticatedDatabases = Collections.synchronizedSet(new HashSet());
    private volatile long usageCount;
    private volatile ActiveState _activeState;

    public DBPort(ServerAddress addr) {
        this(addr, null, new MongoOptions(), 0);
    }

    DBPort(ServerAddress addr, PooledConnectionProvider pool, MongoOptions options, int generation) {
        this._options = options;
        this._sa = addr;
        this._addr = addr;
        this.provider = pool;
        this.generation = generation;
        this._logger = Logger.getLogger(_rootLogger.getName() + "." + addr.toString());
        try {
            this.ensureOpen();
            this._decoder = this._options.dbDecoderFactory.create();
            this.lastUsedAt = this.openedAt = System.currentTimeMillis();
        }
        catch (IOException e) {
            throw new MongoException.Network("Exception opening the socket", e);
        }
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public long getOpenedAt() {
        return this.openedAt;
    }

    @Override
    public long getLastUsedAt() {
        return this.lastUsedAt;
    }

    Response call(OutMessage msg, DBCollection coll) throws IOException {
        Assertions.isTrue("open", !this.closed);
        return this.call(msg, coll, null);
    }

    Response call(final OutMessage msg, final DBCollection coll, final DBDecoder decoder) throws IOException {
        Assertions.isTrue("open", !this.closed);
        return this.doOperation(new Operation<Response>(){

            @Override
            public Response execute() throws IOException {
                DBPort.this.setActiveState(new ActiveState(msg));
                msg.prepare();
                msg.pipe(DBPort.this._out);
                return new Response(DBPort.this._sa, coll, DBPort.this._in, decoder == null ? DBPort.this._decoder : decoder);
            }
        });
    }

    void say(final OutMessage msg) throws IOException {
        Assertions.isTrue("open", !this.closed);
        this.doOperation(new Operation<Void>(){

            @Override
            public Void execute() throws IOException {
                DBPort.this.setActiveState(new ActiveState(msg));
                msg.prepare();
                msg.pipe(DBPort.this._out);
                return null;
            }
        });
    }

    synchronized <T> T doOperation(Operation<T> operation) throws IOException {
        Assertions.isTrue("open", !this.closed);
        ++this.usageCount;
        try {
            T t = operation.execute();
            return t;
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        finally {
            this.lastUsedAt = System.currentTimeMillis();
            this._activeState = null;
        }
    }

    void setActiveState(ActiveState activeState) {
        Assertions.isTrue("open", !this.closed);
        this._activeState = activeState;
    }

    synchronized CommandResult getLastError(DB db, WriteConcern concern) throws IOException {
        Assertions.isTrue("open", !this.closed);
        return this.runCommand(db, concern.getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Response findOne(DB db, String coll, DBObject q) throws IOException {
        OutMessage msg = OutMessage.query(db.getCollection(coll), 0, 0, -1, q, null, 0x400000);
        try {
            Response response = this.call(msg, db.getCollection(coll), null);
            return response;
        }
        finally {
            msg.doneWithMessage();
        }
    }

    synchronized CommandResult runCommand(DB db, DBObject cmd) throws IOException {
        Assertions.isTrue("open", !this.closed);
        Response res = this.findOne(db, "$cmd", cmd);
        return this.convertToCommandResult(cmd, res);
    }

    private CommandResult convertToCommandResult(DBObject cmd, Response res) {
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            throw new MongoInternalException("something is wrong.  size:" + res.size());
        }
        DBObject data = res.get(0);
        if (data == null) {
            throw new MongoInternalException("something is wrong, no command result");
        }
        CommandResult cr = new CommandResult(res.serverUsed());
        cr.putAll(data);
        return cr;
    }

    synchronized CommandResult tryGetLastError(DB db, long last, WriteConcern concern) throws IOException {
        Assertions.isTrue("open", !this.closed);
        if (last != this.usageCount) {
            return null;
        }
        return this.getLastError(db, concern);
    }

    OutputStream getOutputStream() throws IOException {
        Assertions.isTrue("open", !this.closed);
        return this._out;
    }

    InputStream getInputStream() throws IOException {
        Assertions.isTrue("open", !this.closed);
        return this._in;
    }

    public synchronized void ensureOpen() throws IOException {
        if (this._socket != null) {
            return;
        }
        long sleepTime = 100L;
        long maxAutoConnectRetryTime = 15000L;
        if (this._options.maxAutoConnectRetryTime > 0L) {
            maxAutoConnectRetryTime = this._options.maxAutoConnectRetryTime;
        }
        boolean successfullyConnected = false;
        long start = System.currentTimeMillis();
        do {
            try {
                this._socket = this._options.socketFactory.createSocket();
                this._socket.connect(this._addr.getSocketAddress(), this._options.connectTimeout);
                this._socket.setTcpNoDelay(true);
                this._socket.setKeepAlive(this._options.socketKeepAlive);
                this._socket.setSoTimeout(this._options.socketTimeout);
                this._in = new BufferedInputStream(this._socket.getInputStream());
                this._out = this._socket.getOutputStream();
                successfullyConnected = true;
            }
            catch (IOException e) {
                this.close();
                if (!this._options.autoConnectRetry || this.provider != null && !this.provider.hasWorked()) {
                    throw e;
                }
                long waitSoFar = System.currentTimeMillis() - start;
                if (waitSoFar >= maxAutoConnectRetryTime) {
                    throw e;
                }
                if (sleepTime + waitSoFar > maxAutoConnectRetryTime) {
                    sleepTime = maxAutoConnectRetryTime - waitSoFar;
                }
                this._logger.log(Level.WARNING, "Exception connecting to " + this.serverAddress().getHost() + ": " + e + ".  Total wait time so far is " + waitSoFar + " ms.  Will retry after sleeping for " + sleepTime + " ms.");
                ThreadUtil.sleep(sleepTime);
                sleepTime *= 2L;
            }
        } while (!successfullyConnected);
    }

    public int hashCode() {
        return this._addr.hashCode();
    }

    public String host() {
        return this._addr.toString();
    }

    public ServerAddress serverAddress() {
        return this._sa;
    }

    public String toString() {
        return "{DBPort  " + this.host() + "}";
    }

    ActiveState getActiveState() {
        Assertions.isTrue("open", !this.closed);
        return this._activeState;
    }

    int getLocalPort() {
        Assertions.isTrue("open", !this.closed);
        return this._socket != null ? this._socket.getLocalPort() : -1;
    }

    ServerAddress getAddress() {
        return this._addr;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
        this.authenticatedDatabases.clear();
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._in = null;
        this._out = null;
        this._socket = null;
    }

    CommandResult authenticate(Mongo mongo, MongoCredential credentials) {
        Authenticator authenticator;
        if (credentials.getMechanism().equals("MONGODB-CR")) {
            authenticator = new NativeAuthenticator(mongo, credentials);
        } else if (credentials.getMechanism().equals("GSSAPI")) {
            authenticator = new GSSAPIAuthenticator(mongo, credentials);
        } else if (credentials.getMechanism().equals("PLAIN")) {
            authenticator = new PlainAuthenticator(mongo, credentials);
        } else if (credentials.getMechanism().equals("MONGODB-X509")) {
            authenticator = new X509Authenticator(mongo, credentials);
        } else {
            throw new IllegalArgumentException("Unsupported authentication protocol: " + credentials.getMechanism());
        }
        CommandResult res = ((Authenticator)authenticator).authenticate();
        this.authenticatedDatabases.add(credentials.getSource());
        return res;
    }

    void checkAuth(Mongo mongo) throws IOException {
        HashSet<String> unauthenticatedDatabases = new HashSet<String>(mongo.getAuthority().getCredentialsStore().getDatabases());
        unauthenticatedDatabases.removeAll(this.authenticatedDatabases);
        for (String databaseName : unauthenticatedDatabases) {
            this.authenticate(mongo, mongo.getAuthority().getCredentialsStore().get(databaseName));
        }
    }

    public DBPortPool getPool() {
        return null;
    }

    public long getUsageCount() {
        return this.usageCount;
    }

    PooledConnectionProvider getProvider() {
        return this.provider;
    }

    Set<String> getAuthenticatedDatabases() {
        return Collections.unmodifiableSet(this.authenticatedDatabases);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Operation<T> {
        public T execute() throws IOException;
    }

    abstract class Authenticator {
        protected final Mongo mongo;
        protected final MongoCredential credential;

        Authenticator(Mongo mongo, MongoCredential credential) {
            this.mongo = mongo;
            this.credential = credential;
        }

        abstract CommandResult authenticate();
    }

    class NativeAuthenticator
    extends Authenticator {
        NativeAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
        }

        public CommandResult authenticate() {
            try {
                DB db = this.mongo.getDB(this.credential.getSource());
                CommandResult res = DBPort.this.runCommand(db, NativeAuthenticationHelper.getNonceCommand());
                res.throwOnError();
                res = DBPort.this.runCommand(db, NativeAuthenticationHelper.getAuthCommand(this.credential.getUserName(), this.credential.getPassword(), res.getString("nonce")));
                res.throwOnError();
                return res;
            }
            catch (IOException e) {
                throw new MongoException.Network("IOException authenticating the connection", e);
            }
        }
    }

    class X509Authenticator
    extends Authenticator {
        X509Authenticator(Mongo mongo, MongoCredential credential) {
            super(mongo, credential);
        }

        CommandResult authenticate() {
            try {
                DB db = this.mongo.getDB(this.credential.getSource());
                CommandResult res = DBPort.this.runCommand(db, this.getAuthCommand());
                res.throwOnError();
                return res;
            }
            catch (IOException e) {
                throw new MongoException.Network("IOException authenticating the connection", e);
            }
        }

        private DBObject getAuthCommand() {
            return new BasicDBObject("authenticate", (Object)1).append("user", this.credential.getUserName()).append("mechanism", "MONGODB-X509");
        }
    }

    abstract class SaslAuthenticator
    extends Authenticator {
        SaslAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
        }

        public CommandResult authenticate() {
            SaslClient saslClient = this.createSaslClient();
            try {
                byte[] response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(new byte[0]) : null;
                CommandResult res = this.sendSaslStart(response);
                res.throwOnError();
                int conversationId = (Integer)res.get("conversationId");
                while (!((Boolean)res.get("done")).booleanValue()) {
                    response = saslClient.evaluateChallenge((byte[])res.get("payload"));
                    if (response == null) {
                        throw new MongoException("SASL protocol error: no client response to challenge");
                    }
                    res = this.sendSaslContinue(conversationId, response);
                    res.throwOnError();
                }
                CommandResult commandResult = res;
                return commandResult;
            }
            catch (IOException e) {
                throw new MongoException.Network("IOException authenticating the connection", e);
            }
            finally {
                try {
                    saslClient.dispose();
                }
                catch (SaslException e) {}
            }
        }

        protected abstract SaslClient createSaslClient();

        protected DB getDatabase() {
            return this.mongo.getDB(this.credential.getSource());
        }

        private CommandResult sendSaslStart(byte[] outToken) throws IOException {
            BasicDBObject cmd = new BasicDBObject("saslStart", (Object)1).append("mechanism", this.getMechanismName()).append("payload", outToken != null ? outToken : new byte[]{});
            return DBPort.this.runCommand(this.getDatabase(), cmd);
        }

        private CommandResult sendSaslContinue(int conversationId, byte[] outToken) throws IOException {
            DB adminDB = this.getDatabase();
            BasicDBObject cmd = new BasicDBObject("saslContinue", (Object)1).append("conversationId", conversationId).append("payload", outToken);
            return DBPort.this.runCommand(adminDB, cmd);
        }

        public abstract String getMechanismName();
    }

    class GSSAPIAuthenticator
    extends SaslAuthenticator {
        public static final String GSSAPI_OID = "1.2.840.113554.1.2.2";
        public static final String GSSAPI_MECHANISM = "GSSAPI";
        public static final String SERVICE_NAME_KEY = "SERVICE_NAME";
        public static final String SERVICE_NAME_DEFAULT_VALUE = "mongodb";
        public static final String CANONICALIZE_HOST_NAME_KEY = "CANONICALIZE_HOST_NAME";

        GSSAPIAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
            if (!this.credential.getMechanism().equals(GSSAPI_MECHANISM)) {
                throw new MongoException("Incorrect mechanism: " + this.credential.getMechanism());
            }
        }

        protected SaslClient createSaslClient() {
            try {
                HashMap<String, GSSCredential> props = new HashMap<String, GSSCredential>();
                props.put("javax.security.sasl.credentials", this.getGSSCredential(this.credential.getUserName()));
                return Sasl.createSaslClient(new String[]{GSSAPI_MECHANISM}, this.credential.getUserName(), this.credential.getMechanismProperty(SERVICE_NAME_KEY, SERVICE_NAME_DEFAULT_VALUE), this.getHostName(), props, null);
            }
            catch (SaslException e) {
                throw new MongoException("Exception initializing SASL client", e);
            }
            catch (GSSException e) {
                throw new MongoException("Exception initializing GSSAPI credentials", e);
            }
            catch (UnknownHostException e) {
                throw new MongoException("Unknown host " + DBPort.this.serverAddress().getHost(), e);
            }
        }

        public String getMechanismName() {
            return GSSAPI_MECHANISM;
        }

        private String getHostName() throws UnknownHostException {
            return this.credential.getMechanismProperty(CANONICALIZE_HOST_NAME_KEY, false) != false ? InetAddress.getByName(DBPort.this.serverAddress().getHost()).getCanonicalHostName() : DBPort.this.serverAddress().getHost();
        }

        private GSSCredential getGSSCredential(String userName) throws GSSException {
            Oid krb5Mechanism = new Oid(GSSAPI_OID);
            GSSManager manager = GSSManager.getInstance();
            GSSName name = manager.createName(userName, GSSName.NT_USER_NAME);
            return manager.createCredential(name, Integer.MAX_VALUE, krb5Mechanism, 1);
        }
    }

    class PlainAuthenticator
    extends SaslAuthenticator {
        private static final String MECHANISM = "PLAIN";
        private static final String DEFAULT_PROTOCOL = "mongodb";

        PlainAuthenticator(Mongo mongo, MongoCredential credentials) {
            super(mongo, credentials);
        }

        protected SaslClient createSaslClient() {
            try {
                return Sasl.createSaslClient(new String[]{MECHANISM}, this.credential.getUserName(), DEFAULT_PROTOCOL, DBPort.this.serverAddress().getHost(), null, new CallbackHandler(){

                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof PasswordCallback) {
                                ((PasswordCallback)callback).setPassword(PlainAuthenticator.this.credential.getPassword());
                                continue;
                            }
                            if (!(callback instanceof NameCallback)) continue;
                            ((NameCallback)callback).setName(PlainAuthenticator.this.credential.getUserName());
                        }
                    }
                });
            }
            catch (SaslException e) {
                throw new MongoException("Exception initializing SASL client", e);
            }
        }

        public String getMechanismName() {
            return MECHANISM;
        }
    }

    class ActiveState {
        private final String namespace;
        private final OutMessage.OpCode opCode;
        private final DBObject query;
        private int numDocuments;
        private final long startTime;
        private final String threadName;

        ActiveState(OutMessage outMessage) {
            this.namespace = outMessage.getNamespace();
            this.opCode = outMessage.getOpCode();
            this.query = outMessage.getQuery();
            this.numDocuments = outMessage.getNumDocuments();
            this.startTime = System.nanoTime();
            this.threadName = Thread.currentThread().getName();
        }

        String getNamespace() {
            return this.namespace;
        }

        OutMessage.OpCode getOpCode() {
            return this.opCode;
        }

        DBObject getQuery() {
            return this.query;
        }

        int getNumDocuments() {
            return this.numDocuments;
        }

        long getStartTime() {
            return this.startTime;
        }

        String getThreadName() {
            return this.threadName;
        }
    }
}

