/*
 * Decompiled with CFR 0.152.
 */
package com.lti.utils.synchronization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedObjectHolder<T> {
    private T object;

    public SynchronizedObjectHolder() {
    }

    public SynchronizedObjectHolder(T value) {
        this.setObject(value);
    }

    public synchronized void setObject(T value) {
        this.object = value;
        this.notifyAll();
    }

    public synchronized T getObject() {
        return this.object;
    }

    public synchronized void waitUntilNotNull() throws InterruptedException {
        while (this.object == null) {
            this.wait();
        }
    }

    public synchronized boolean waitUntilNotNull(int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.object == null) {
            long now = System.currentTimeMillis();
            long diff = now - start;
            long wait = (long)timeout - diff;
            if (wait <= 0L) {
                return false;
            }
            this.wait(wait);
        }
        return true;
    }
}

