/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CannotRealizeException;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.DataSinkProxy;
import javax.media.IncompatibleSourceException;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSinkException;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceCloneable;
import javax.media.protocol.URLDataSource;
import net.sf.fmj.utility.LoggerSingleton;

public final class Manager {
    public static final String FMJ_TAG = "FMJ";
    private static final Logger logger = LoggerSingleton.logger;
    public static final int MAX_SECURITY = 1;
    public static final int CACHING = 2;
    public static final int LIGHTWEIGHT_RENDERER = 3;
    public static final int PLUGIN_PLAYER = 4;
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static TimeBase systemTimeBase = new SystemTimeBase();
    private static final Map hints = new HashMap();
    public static final boolean RETHROW_IO_EXCEPTIONS = true;

    public static String getVersion() {
        try {
            Properties p = new Properties();
            p.load(Manager.class.getResourceAsStream("/fmj.build.properties"));
            String s = p.getProperty("build");
            if (s != null && !s.equals("")) {
                return "FMJ " + s.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "FMJ non-release x.x";
    }

    public static Player createPlayer(URL sourceURL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(sourceURL));
    }

    public static Player createPlayer(MediaLocator sourceLocator) throws IOException, NoPlayerException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        Vector dataSourceList = Manager.getDataSourceList(protocol);
        for (int i = 0; i < dataSourceList.size(); ++i) {
            String dataSourceClassName = (String)dataSourceList.get(i);
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return Manager.createPlayer(dataSource);
            }
            catch (NoPlayerException e) {
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.finer("createPlayer: " + e);
                continue;
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new NoPlayerException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return Manager.createPlayer(dataSource);
    }

    private static Player createPlayer(DataSource source, String contentType) throws IOException, NoPlayerException {
        Vector handlerClassList = Manager.getHandlerClassList(contentType);
        for (int i = 0; i < handlerClassList.size(); ++i) {
            String handlerClassName = (String)handlerClassList.get(i);
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!Player.class.isAssignableFrom(handlerClass) && !MediaProxy.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(source);
                if (handler instanceof Player) {
                    return (Player)handler;
                }
                if (!(handler instanceof MediaProxy)) continue;
                MediaProxy mediaProxy = (MediaProxy)handler;
                return Manager.createPlayer(mediaProxy.getDataSource());
            }
            catch (ClassNotFoundException e) {
                logger.finer("createPlayer: " + e);
                continue;
            }
            catch (IncompatibleSourceException e) {
                logger.finer("createPlayer(" + source + ", " + contentType + "): " + e);
                continue;
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoPlayerException e) {
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoPlayerException("No player found for " + source.getLocator());
    }

    public static Player createPlayer(DataSource source) throws IOException, NoPlayerException {
        try {
            return Manager.createPlayer(source, source.getContentType());
        }
        catch (NoPlayerException e) {
        }
        catch (IOException e) {
            logger.log(Level.FINE, "" + e, e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.FINER, "" + e, e);
        }
        return Manager.createPlayer(source, UNKNOWN_CONTENT_NAME);
    }

    public static Player createRealizedPlayer(URL sourceURL) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(sourceURL);
        Manager.blockingRealize(player);
        return player;
    }

    public static Player createRealizedPlayer(MediaLocator ml) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(ml);
        Manager.blockingRealize(player);
        return player;
    }

    public static Player createRealizedPlayer(DataSource source) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(source);
        Manager.blockingRealize(player);
        return player;
    }

    public static Processor createProcessor(URL sourceURL) throws IOException, NoProcessorException {
        return Manager.createProcessor(new MediaLocator(sourceURL));
    }

    public static Processor createProcessor(MediaLocator sourceLocator) throws IOException, NoProcessorException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        Vector dataSourceList = Manager.getDataSourceList(protocol);
        for (int i = 0; i < dataSourceList.size(); ++i) {
            String dataSourceClassName = (String)dataSourceList.get(i);
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return Manager.createProcessor(dataSource);
            }
            catch (ClassNotFoundException e) {
                logger.finer("createProcessor: " + e);
                continue;
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoProcessorException e) {
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new NoProcessorException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return Manager.createProcessor(dataSource);
    }

    private static Processor createProcessor(DataSource source, String contentType) throws IOException, NoProcessorException {
        Vector handlerClassList = Manager.getProcessorClassList(contentType);
        for (int i = 0; i < handlerClassList.size(); ++i) {
            String handlerClassName = (String)handlerClassList.get(i);
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!Processor.class.isAssignableFrom(handlerClass) && !MediaProxy.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(source);
                if (handler instanceof Processor) {
                    return (Processor)handler;
                }
                if (!(handler instanceof MediaProxy)) continue;
                MediaProxy mediaProxy = (MediaProxy)handler;
                return Manager.createProcessor(mediaProxy.getDataSource());
            }
            catch (ClassNotFoundException e) {
                logger.finer("createProcessor: " + e);
                continue;
            }
            catch (IncompatibleSourceException e) {
                logger.finer("createProcessor(" + source + ", " + contentType + "): " + e);
                continue;
            }
            catch (NoProcessorException e) {
                continue;
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoProcessorException();
    }

    public static Processor createProcessor(DataSource source) throws IOException, NoProcessorException {
        try {
            return Manager.createProcessor(source, source.getContentType());
        }
        catch (IOException e) {
            logger.log(Level.FINE, "" + e, e);
            throw e;
        }
        catch (NoProcessorException e) {
        }
        catch (Exception e) {
            logger.log(Level.FINE, "" + e, e);
        }
        return Manager.createProcessor(source, UNKNOWN_CONTENT_NAME);
    }

    public static Processor createRealizedProcessor(ProcessorModel model) throws IOException, NoProcessorException, CannotRealizeException {
        Processor processor = model.getInputDataSource() != null ? Manager.createProcessor(model.getInputDataSource()) : Manager.createProcessor(model.getInputLocator());
        processor.setContentDescriptor(model.getContentDescriptor());
        Manager.blockingRealize(processor);
        return processor;
    }

    public static DataSource createDataSource(URL sourceURL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(sourceURL));
    }

    public static DataSource createDataSource(MediaLocator sourceLocator) throws IOException, NoDataSourceException {
        URL url;
        String protocol = sourceLocator.getProtocol();
        Vector dataSourceList = Manager.getDataSourceList(protocol);
        for (int i = 0; i < dataSourceList.size(); ++i) {
            String dataSourceClassName = (String)dataSourceList.get(i);
            try {
                Class<?> dataSourceClass = Class.forName(dataSourceClassName);
                DataSource dataSource = (DataSource)dataSourceClass.newInstance();
                dataSource.setLocator(sourceLocator);
                dataSource.connect();
                return dataSource;
            }
            catch (ClassNotFoundException e) {
                logger.finer("createDataSource: " + e);
                continue;
            }
            catch (IOException e) {
                logger.log(Level.FINE, "" + e, e);
                throw e;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        try {
            url = sourceLocator.getURL();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new NoDataSourceException();
        }
        URLDataSource dataSource = new URLDataSource(url);
        dataSource.connect();
        return dataSource;
    }

    public static DataSource createMergingDataSource(DataSource[] sources) throws IncompatibleSourceException {
        throw new UnsupportedOperationException();
    }

    public static DataSource createCloneableDataSource(DataSource source) {
        if (source instanceof SourceCloneable) {
            return source;
        }
        throw new UnsupportedOperationException();
    }

    public static TimeBase getSystemTimeBase() {
        return systemTimeBase;
    }

    private static DataSink createDataSink(DataSource datasource, String protocol) throws NoDataSinkException {
        Vector handlerClassList = Manager.getDataSinkClassList(protocol);
        for (int i = 0; i < handlerClassList.size(); ++i) {
            String handlerClassName = (String)handlerClassList.get(i);
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!DataSink.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(datasource);
                if (!(handler instanceof DataSink)) continue;
                return (DataSink)handler;
            }
            catch (ClassNotFoundException e) {
                logger.finer("createDataSink: " + e);
                continue;
            }
            catch (IncompatibleSourceException e) {
                logger.finer("createDataSink(" + datasource + ", " + protocol + "): " + e);
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoDataSinkException();
    }

    public static DataSink createDataSink(DataSource datasource, MediaLocator destLocator) throws NoDataSinkException {
        String protocol = destLocator.getProtocol();
        Vector handlerClassList = Manager.getDataSinkClassList(protocol);
        for (int i = 0; i < handlerClassList.size(); ++i) {
            String handlerClassName = (String)handlerClassList.get(i);
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                if (!DataSink.class.isAssignableFrom(handlerClass) && !DataSinkProxy.class.isAssignableFrom(handlerClass)) continue;
                MediaHandler handler = (MediaHandler)handlerClass.newInstance();
                handler.setSource(datasource);
                if (handler instanceof DataSink) {
                    DataSink dataSink = (DataSink)handler;
                    dataSink.setOutputLocator(destLocator);
                    return dataSink;
                }
                if (!(handler instanceof DataSinkProxy)) continue;
                DataSinkProxy mediaProxy = (DataSinkProxy)handler;
                Vector handlerClassList2 = Manager.getDataSinkClassList(protocol + "." + Manager.toPackageFriendly(mediaProxy.getContentType(destLocator)));
                for (int j = 0; j < handlerClassList2.size(); ++j) {
                    String handlerClassName2 = (String)handlerClassList2.get(j);
                    try {
                        Class<?> handlerClass2 = Class.forName(handlerClassName2);
                        if (!DataSink.class.isAssignableFrom(handlerClass2)) continue;
                        MediaHandler handler2 = (MediaHandler)handlerClass2.newInstance();
                        handler2.setSource(mediaProxy.getDataSource());
                        if (!(handler2 instanceof DataSink)) continue;
                        DataSink dataSink = (DataSink)handler2;
                        dataSink.setOutputLocator(destLocator);
                        return (DataSink)handler2;
                    }
                    catch (ClassNotFoundException e) {
                        logger.finer("createDataSink: " + e);
                        continue;
                    }
                    catch (IncompatibleSourceException e) {
                        logger.finer("createDataSink(" + datasource + ", " + destLocator + "), proxy=" + mediaProxy.getDataSource() + ": " + e);
                        continue;
                    }
                    catch (NoClassDefFoundError e) {
                        logger.log(Level.FINE, "" + e, e);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.FINE, "" + e, e);
                    }
                }
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.finer("createDataSink: " + e);
                continue;
            }
            catch (IncompatibleSourceException e) {
                logger.finer("createDataSink(" + datasource + ", " + destLocator + "): " + e);
                continue;
            }
            catch (NoClassDefFoundError e) {
                logger.log(Level.FINE, "" + e, e);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "" + e, e);
            }
        }
        throw new NoDataSinkException();
    }

    private static void blockingRealize(Controller controller) throws CannotRealizeException {
        try {
            new BlockingRealizer(controller).realize();
        }
        catch (InterruptedException e) {
            throw new CannotRealizeException("Interrupted");
        }
    }

    public static String getCacheDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void setHint(int hint, Object value) {
        hints.put(new Integer(hint), value);
    }

    public static Object getHint(int hint) {
        return hints.get(new Integer(hint));
    }

    public static Vector getDataSourceList(String protocolName) {
        return Manager.getClassList(protocolName, PackageManager.getProtocolPrefixList(), "protocol", "DataSource");
    }

    private static char toPackageFriendly(char c) {
        if (c >= 'a' && c <= 'z') {
            return c;
        }
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c == '.') {
            return c;
        }
        if (c == '/') {
            return '.';
        }
        return '_';
    }

    private static String toPackageFriendly(String contentName) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < contentName.length(); ++i) {
            char c = contentName.charAt(i);
            b.append(Manager.toPackageFriendly(c));
        }
        return b.toString();
    }

    public static Vector getClassList(String contentName, Vector packages, String component2, String className) {
        Vector<String> result = new Vector<String>();
        result.add("media." + component2 + "." + contentName + "." + className);
        for (int i = 0; i < packages.size(); ++i) {
            result.add((String)packages.get(i) + ".media." + component2 + "." + contentName + "." + className);
        }
        return result;
    }

    public static Vector getDataSinkClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "datasink", "Handler");
    }

    public static Vector getHandlerClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "content", "Handler");
    }

    public static Vector getProcessorClassList(String contentName) {
        return Manager.getClassList(Manager.toPackageFriendly(contentName), PackageManager.getContentPrefixList(), "processor", "Handler");
    }

    static {
        hints.put(new Integer(1), Boolean.FALSE);
        hints.put(new Integer(2), Boolean.TRUE);
        hints.put(new Integer(3), Boolean.FALSE);
        hints.put(new Integer(4), Boolean.FALSE);
    }

    private static class BlockingRealizer
    implements ControllerListener {
        private final Controller controller;
        private volatile boolean realized = false;
        private volatile boolean busy = true;
        private volatile String cannotRealizeExceptionMessage;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void realize() throws CannotRealizeException, InterruptedException {
            this.controller.addControllerListener(this);
            this.controller.realize();
            while (!this.busy) {
                try {
                    BlockingRealizer blockingRealizer = this;
                    synchronized (blockingRealizer) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.controller.removeControllerListener(this);
                    throw e;
                }
            }
            this.controller.removeControllerListener(this);
            if (!this.realized) {
                throw new CannotRealizeException(this.cannotRealizeExceptionMessage);
            }
        }

        public synchronized void controllerUpdate(ControllerEvent event) {
            if (event instanceof RealizeCompleteEvent) {
                this.realized = true;
                this.busy = false;
                this.notify();
            } else if (event instanceof StopEvent || event instanceof ControllerClosedEvent) {
                if (event instanceof StopEvent) {
                    this.cannotRealizeExceptionMessage = "Cannot realize: received StopEvent: " + event;
                    logger.info(this.cannotRealizeExceptionMessage);
                } else {
                    this.cannotRealizeExceptionMessage = "Cannot realize: received ControllerClosedEvent: " + event + "; message: " + ((ControllerClosedEvent)event).getMessage();
                    logger.info(this.cannotRealizeExceptionMessage);
                }
                this.realized = false;
                this.busy = false;
                this.notify();
            }
        }

        public BlockingRealizer(Controller controller) {
            this.controller = controller;
        }
    }
}

