/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.fmj.utility.FormatUtils;

public class YUVFormat
extends VideoFormat {
    public static final int YUV_411 = 1;
    public static final int YUV_420 = 2;
    public static final int YUV_422 = 4;
    public static final int YUV_111 = 8;
    public static final int YUV_YVU9 = 16;
    public static final int YUV_YUYV = 32;
    public static final int YUV_SIGNED = 64;
    protected int strideY = -1;
    protected int strideUV = -1;
    protected int yuvType = -1;
    protected int offsetY = -1;
    protected int offsetU = -1;
    protected int offsetV = -1;
    private static String ENCODING = "yuv";

    public YUVFormat() {
        super(ENCODING);
        this.dataType = Format.byteArray;
    }

    public YUVFormat(int yuvType) {
        super(ENCODING);
        this.yuvType = yuvType;
        this.dataType = byteArray;
    }

    public YUVFormat(Dimension size, int maxDataLength, Class dataType, float frameRate, int yuvType, int strideY, int strideUV, int offsetY, int offsetU, int offsetV) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.yuvType = yuvType;
        this.strideY = strideY;
        this.strideUV = strideUV;
        this.offsetY = offsetY;
        this.offsetU = offsetU;
        this.offsetV = offsetV;
    }

    public int getYuvType() {
        return this.yuvType;
    }

    public int getStrideY() {
        return this.strideY;
    }

    public int getStrideUV() {
        return this.strideUV;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetU() {
        return this.offsetU;
    }

    public int getOffsetV() {
        return this.offsetV;
    }

    public Object clone() {
        return new YUVFormat(FormatUtils.clone(this.size), this.maxDataLength, this.dataType, this.frameRate, this.yuvType, this.strideY, this.strideUV, this.offsetY, this.offsetU, this.offsetV);
    }

    protected void copy(Format f) {
        super.copy(f);
        YUVFormat oCast = (YUVFormat)f;
        this.yuvType = oCast.yuvType;
        this.strideY = oCast.strideY;
        this.strideUV = oCast.strideUV;
        this.offsetY = oCast.offsetY;
        this.offsetU = oCast.offsetU;
        this.offsetV = oCast.offsetV;
    }

    public boolean equals(Object format) {
        if (!super.equals(format)) {
            return false;
        }
        if (!(format instanceof YUVFormat)) {
            return false;
        }
        YUVFormat oCast = (YUVFormat)format;
        return this.yuvType == oCast.yuvType && this.strideY == oCast.strideY && this.strideUV == oCast.strideUV && this.offsetY == oCast.offsetY && this.offsetU == oCast.offsetU && this.offsetV == oCast.offsetV;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            FormatUtils.traceMatches(this, format, false);
            return false;
        }
        if (!(format instanceof YUVFormat)) {
            boolean result = true;
            FormatUtils.traceMatches(this, format, true);
            return true;
        }
        YUVFormat oCast = (YUVFormat)format;
        boolean result = FormatUtils.matches(this.yuvType, oCast.yuvType) && FormatUtils.matches(this.strideY, oCast.strideY) && FormatUtils.matches(this.strideUV, oCast.strideUV) && FormatUtils.matches(this.offsetY, oCast.offsetY) && FormatUtils.matches(this.offsetU, oCast.offsetU) && FormatUtils.matches(this.offsetV, oCast.offsetV);
        FormatUtils.traceMatches(this, format, result);
        return result;
    }

    public Format intersects(Format other) {
        Format result = super.intersects(other);
        if (other instanceof YUVFormat) {
            YUVFormat resultCast = (YUVFormat)result;
            YUVFormat oCast = (YUVFormat)other;
            if (this.getClass().isAssignableFrom(other.getClass())) {
                if (FormatUtils.specified(this.yuvType)) {
                    resultCast.yuvType = this.yuvType;
                }
                if (FormatUtils.specified(this.strideY)) {
                    resultCast.strideY = this.strideY;
                }
                if (FormatUtils.specified(this.strideUV)) {
                    resultCast.strideUV = this.strideUV;
                }
                if (FormatUtils.specified(this.offsetY)) {
                    resultCast.offsetY = this.offsetY;
                }
                if (FormatUtils.specified(this.offsetU)) {
                    resultCast.offsetU = this.offsetU;
                }
                if (FormatUtils.specified(this.offsetV)) {
                    resultCast.offsetV = this.offsetV;
                }
            } else {
                if (!FormatUtils.specified(resultCast.yuvType)) {
                    resultCast.yuvType = oCast.yuvType;
                }
                if (!FormatUtils.specified(resultCast.strideY)) {
                    resultCast.strideY = oCast.strideY;
                }
                if (!FormatUtils.specified(resultCast.strideUV)) {
                    resultCast.strideUV = oCast.strideUV;
                }
                if (!FormatUtils.specified(resultCast.offsetY)) {
                    resultCast.offsetY = oCast.offsetY;
                }
                if (!FormatUtils.specified(resultCast.offsetU)) {
                    resultCast.offsetU = oCast.offsetU;
                }
                if (!FormatUtils.specified(resultCast.offsetV)) {
                    resultCast.offsetV = oCast.offsetV;
                }
            }
        }
        FormatUtils.traceIntersects(this, other, result);
        return result;
    }

    public Format relax() {
        YUVFormat result = (YUVFormat)super.relax();
        result.strideY = -1;
        result.strideUV = -1;
        result.offsetY = -1;
        result.offsetU = -1;
        result.offsetV = -1;
        return result;
    }

    public String toString() {
        return "YUV Video Format: Size = " + this.size + " MaxDataLength = " + this.maxDataLength + " DataType = " + this.dataType + " yuvType = " + this.yuvType + " StrideY = " + this.strideY + " StrideUV = " + this.strideUV + " OffsetY = " + this.offsetY + " OffsetU = " + this.offsetU + " OffsetV = " + this.offsetV + "\n";
    }
}

