/*
 * Decompiled with CFR 0.152.
 */
package javax.media.pim;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Renderer;
import javax.media.pim.PlugInInfo;
import net.sf.fmj.media.RegistryDefaults;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInManager
extends javax.media.PlugInManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static boolean TRACE = false;
    private static final Vector[] classLists = new Vector[]{new Vector(), new Vector(), new Vector(), new Vector(), new Vector()};
    private static final HashMap[] pluginMaps = new HashMap[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};
    private static Registry registry = Registry.getInstance();

    private PlugInManager() {
    }

    public static synchronized Vector<String> getPlugInList(Format input, Format output, int type) {
        if (TRACE) {
            logger.info("getting plugin list...");
        }
        if (!PlugInManager.isValid(type)) {
            return new Vector<String>();
        }
        Vector<String> result = new Vector<String>();
        Vector<String> classList = PlugInManager.getVector(type);
        HashMap pluginMap = pluginMaps[type - 1];
        for (int i = 0; i < classList.size(); ++i) {
            int j;
            boolean match;
            String classname = classList.get(i);
            PlugInInfo plugInInfo = (PlugInInfo)pluginMap.get(classname);
            if (plugInInfo == null) continue;
            if (input != null) {
                if (plugInInfo.inputFormats == null) continue;
                match = false;
                for (j = 0; j < plugInInfo.inputFormats.length; ++j) {
                    if (!input.matches(plugInInfo.inputFormats[j])) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            if (output != null) {
                if (plugInInfo.outputFormats == null) continue;
                match = false;
                for (j = 0; j < plugInInfo.outputFormats.length; ++j) {
                    if (!output.matches(plugInInfo.outputFormats[j])) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            result.add(plugInInfo.className);
        }
        return result;
    }

    public static synchronized void setPlugInList(Vector plugins, int type) {
        Vector vector = classLists[type - 1];
        vector.clear();
        vector.addAll(plugins);
        registry.setPluginList(type, plugins);
    }

    public static synchronized void commit() throws IOException {
        registry.commit();
    }

    public static synchronized boolean addPlugIn(String classname, Format[] in, Format[] out, int type) {
        try {
            Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            logger.finer("addPlugIn failed for nonexistant class: " + classname);
            return false;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to addPlugIn for " + classname + " due to inability to get its class: " + t, t);
            return false;
        }
        if (PlugInManager.find(classname, type) != null) {
            return false;
        }
        PlugInInfo plugInInfo = new PlugInInfo(classname, in, out);
        Vector classList = classLists[type - 1];
        HashMap pluginMap = pluginMaps[type - 1];
        classList.add(classname);
        pluginMap.put(classname, plugInInfo);
        registry.setPluginList(type, classList);
        return true;
    }

    public static synchronized boolean removePlugIn(String classname, int type) {
        Vector classList = classLists[type - 1];
        HashMap pluginMap = pluginMaps[type - 1];
        boolean result = classList.remove(classname) || pluginMap.remove(classname) != null;
        registry.setPluginList(type, classList);
        return result;
    }

    public static synchronized Format[] getSupportedInputFormats(String className, int type) {
        PlugInInfo pi = PlugInManager.find(className, type);
        if (pi == null) {
            return null;
        }
        return pi.inputFormats;
    }

    public static synchronized Format[] getSupportedOutputFormats(String className, int type) {
        PlugInInfo pi = PlugInManager.find(className, type);
        if (pi == null) {
            return null;
        }
        return pi.outputFormats;
    }

    private static boolean isValid(int type) {
        return type >= 1 && type <= 5;
    }

    private static Vector<String> getVector(int type) {
        if (!PlugInManager.isValid(type)) {
            return null;
        }
        return classLists[type - 1];
    }

    private static synchronized PlugInInfo find(String classname, int type) {
        PlugInInfo info = (PlugInInfo)pluginMaps[type - 1].get(classname);
        return info;
    }

    private static final PlugInInfo getPluginInfo(String pluginName) {
        Object pluginObject;
        try {
            Class<?> cls = Class.forName(pluginName);
            pluginObject = cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.warning("Problem loading plugin " + pluginName + ": " + e.getMessage());
            return null;
        }
        catch (InstantiationException e) {
            logger.warning("Problem loading plugin " + pluginName + ": " + e.getMessage());
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warning("Problem loading plugin " + pluginName + ": " + e.getMessage());
            return null;
        }
        Format[] in = null;
        Format[] out = null;
        if (pluginObject instanceof Demultiplexer) {
            Demultiplexer demux = (Demultiplexer)pluginObject;
            in = demux.getSupportedInputContentDescriptors();
        } else if (pluginObject instanceof Codec) {
            Codec codec = (Codec)pluginObject;
            in = codec.getSupportedInputFormats();
            out = codec.getSupportedOutputFormats(null);
        } else if (pluginObject instanceof Multiplexer) {
            Multiplexer mux = (Multiplexer)pluginObject;
            in = mux.getSupportedInputFormats();
            out = mux.getSupportedOutputContentDescriptors(null);
        } else if (pluginObject instanceof Renderer) {
            Renderer renderer = (Renderer)pluginObject;
            in = renderer.getSupportedInputFormats();
            out = null;
        } else if (pluginObject instanceof Effect) {
            Effect effect = (Effect)pluginObject;
            in = effect.getSupportedInputFormats();
            out = effect.getSupportedOutputFormats(null);
        }
        return new PlugInInfo(pluginName, in, out);
    }

    static {
        try {
            if (TRACE) {
                logger.info("initializing...");
            }
            for (int i = 0; i < 5; ++i) {
                Vector classList = classLists[i];
                HashMap pluginMap = pluginMaps[i];
                for (String classname : registry.getPluginList(i + 1)) {
                    classList.add(classname);
                    PlugInInfo info = PlugInManager.getPluginInfo(classname);
                    if (info == null) continue;
                    pluginMap.put(info.className, info);
                }
            }
            boolean jmfDefaults = false;
            try {
                jmfDefaults = System.getProperty("net.sf.fmj.utility.JmfRegistry.JMFDefaults", "false").equals("true");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            int flags = jmfDefaults ? 1 : 7;
            RegistryDefaults.registerPlugins(flags);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Unable to initialize javax.media.pim.PlugInManager (static): " + t, t);
            throw new RuntimeException(t);
        }
    }
}

