/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.ilbc;

import com.ibm.media.codec.audio.AudioCodec;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.media.codec.audio.Utils;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_constants;
import net.java.sip.communicator.impl.media.codec.audio.ilbc.ilbc_decoder;

public class JavaDecoder
extends AudioCodec {
    private Format lastFormat = null;
    private ilbc_decoder dec = null;

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, -1, -1)};
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "iLbc Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, 1, 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
    }

    public void close() {
    }

    private void initConverter(AudioFormat inFormat, int inputLength) {
        this.lastFormat = inFormat;
        if (inputLength == ilbc_constants.NO_OF_BYTES_20MS) {
            this.dec = new ilbc_decoder(20, 1);
        } else if (inputLength == ilbc_constants.NO_OF_BYTES_30MS) {
            this.dec = new ilbc_decoder(30, 1);
        }
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        byte[] inData = (byte[])inputBuffer.getData();
        int inpLength = inputBuffer.getLength();
        int inOffset = inputBuffer.getOffset();
        Format newFormat = inputBuffer.getFormat();
        if (this.lastFormat != newFormat) {
            this.initConverter((AudioFormat)newFormat, inpLength);
        }
        if (inpLength <= 0) {
            return 4;
        }
        short[] data = Utils.byteToShortArray(inData, inOffset, inpLength, false);
        short[] decodedData = new short[this.dec.ULP_inst.blockl];
        this.dec.decode(decodedData, data, (short)1);
        int outLength = this.dec.ULP_inst.blockl * 2;
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        Utils.shortArrToByteArr(decodedData, outData, true);
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }
}

