/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.codegen;

import com.sun.media.format.WavAudioFormat;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.H261Format;
import javax.media.format.H263Format;
import javax.media.format.IndexedColorFormat;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.codegen.CGUtils;
import net.sf.fmj.utility.StringUtils;

public class MediaCGUtils {
    public static String formatToStr(Format f) {
        if (f == null) {
            return "null";
        }
        Class<?> c = f.getClass();
        if (c == RGBFormat.class) {
            RGBFormat o = (RGBFormat)f;
            return "new RGBFormat(" + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + o.getBitsPerPixel() + ", " + CGUtils.toHexLiteral(o.getRedMask()) + ", " + CGUtils.toHexLiteral(o.getGreenMask()) + ", " + CGUtils.toHexLiteral(o.getBlueMask()) + ", " + o.getPixelStride() + ", " + o.getLineStride() + ", " + o.getFlipped() + ", " + o.getEndian() + ")";
        }
        if (c == YUVFormat.class) {
            YUVFormat o = (YUVFormat)f;
            return "new YUVFormat(" + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + o.getYuvType() + ", " + o.getStrideY() + ", " + o.getStrideUV() + ", " + o.getOffsetY() + ", " + o.getOffsetU() + ", " + o.getOffsetV() + ")";
        }
        if (c == JPEGFormat.class) {
            JPEGFormat o = (JPEGFormat)f;
            return "new JPEGFormat(" + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + o.getQFactor() + ", " + o.getDecimation() + ")";
        }
        if (c == IndexedColorFormat.class) {
            IndexedColorFormat o = (IndexedColorFormat)f;
            return "new IndexedColorFormat(" + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + o.getLineStride() + ", " + o.getMapSize() + ", " + CGUtils.toLiteral(o.getRedValues()) + ", " + CGUtils.toLiteral(o.getGreenValues()) + ", " + CGUtils.toLiteral(o.getBlueValues()) + ")";
        }
        if (c == H263Format.class) {
            H263Format o = (H263Format)f;
            return "new H263Format(" + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + o.getAdvancedPrediction() + ", " + o.getArithmeticCoding() + ", " + o.getErrorCompensation() + ", " + o.getHrDB() + ", " + o.getPBFrames() + ", " + o.getUnrestrictedVector() + ")";
        }
        if (c == H261Format.class) {
            H261Format o = (H261Format)f;
            return "new H261Format(" + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + o.getStillImageTransmission() + ")";
        }
        if (c == AudioFormat.class) {
            AudioFormat o = (AudioFormat)f;
            return "new AudioFormat(" + CGUtils.toLiteral(o.getEncoding()) + ", " + CGUtils.toLiteral(o.getSampleRate()) + ", " + CGUtils.toLiteral(o.getSampleSizeInBits()) + ", " + CGUtils.toLiteral(o.getChannels()) + ", " + CGUtils.toLiteral(o.getEndian()) + ", " + CGUtils.toLiteral(o.getSigned()) + ", " + CGUtils.toLiteral(o.getFrameSizeInBits()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ")";
        }
        if (c == VideoFormat.class) {
            VideoFormat o = (VideoFormat)f;
            return "new VideoFormat(" + CGUtils.toLiteral(o.getEncoding()) + ", " + MediaCGUtils.toLiteral(o.getSize()) + ", " + o.getMaxDataLength() + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getFrameRate()) + ")";
        }
        if (c == Format.class) {
            Format o = f;
            return "new Format(" + CGUtils.toLiteral(o.getEncoding()) + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ")";
        }
        if (c == FileTypeDescriptor.class) {
            FileTypeDescriptor o = (FileTypeDescriptor)f;
            return "new FileTypeDescriptor(" + CGUtils.toLiteral(o.getEncoding()) + ")";
        }
        if (c == ContentDescriptor.class) {
            ContentDescriptor o = (ContentDescriptor)f;
            return "new ContentDescriptor(" + CGUtils.toLiteral(o.getEncoding()) + ")";
        }
        if (c == WavAudioFormat.class) {
            WavAudioFormat o = (WavAudioFormat)f;
            return "new com.sun.media.format.WavAudioFormat(" + CGUtils.toLiteral(o.getEncoding()) + ", " + CGUtils.toLiteral(o.getSampleRate()) + ", " + CGUtils.toLiteral(o.getSampleSizeInBits()) + ", " + CGUtils.toLiteral(o.getChannels()) + ", " + CGUtils.toLiteral(o.getFrameSizeInBits()) + ", " + CGUtils.toLiteral(o.getAverageBytesPerSecond()) + ", " + CGUtils.toLiteral(o.getEndian()) + ", " + CGUtils.toLiteral(o.getSigned()) + ", " + CGUtils.toLiteral((float)o.getFrameRate()) + ", " + MediaCGUtils.dataTypeToStr(o.getDataType()) + ", " + CGUtils.toLiteral(o.getCodecSpecificHeader()) + ")";
        }
        throw new IllegalArgumentException("" + f.getClass());
    }

    public static String toLiteral(Dimension size) {
        if (size == null) {
            return "null";
        }
        return "new java.awt.Dimension(" + size.width + ", " + size.height + ")";
    }

    public static String dataTypeToStr(Class dataType) {
        if (dataType == null) {
            return "null";
        }
        if (dataType == Format.byteArray) {
            return "Format.byteArray";
        }
        if (dataType == Format.shortArray) {
            return "Format.shortArray";
        }
        if (dataType == Format.intArray) {
            return "Format.intArray";
        }
        throw new IllegalArgumentException();
    }

    public static String plugInResultToStr(int result) {
        switch (result) {
            case 0: {
                return "BUFFER_PROCESSED_OK";
            }
            case 1: {
                return "BUFFER_PROCESSED_FAILED";
            }
            case 2: {
                return "INPUT_BUFFER_NOT_CONSUMED";
            }
            case 4: {
                return "OUTPUT_BUFFER_NOT_FILLED";
            }
            case 8: {
                return "PLUGIN_TERMINATED";
            }
        }
        return "" + result;
    }

    public static String bufferToStr(Buffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        b.append(buffer);
        b.append(" seq=" + buffer.getSequenceNumber());
        b.append(" off=" + buffer.getOffset());
        b.append(" len=" + buffer.getLength());
        b.append(" flags=[" + MediaCGUtils.bufferFlagsToStr(buffer.getFlags()) + "]");
        b.append(" fmt=[" + buffer.getFormat() + "]");
        if (buffer.getData() != null && buffer.getData() instanceof byte[]) {
            b.append(" data=[" + buffer.getData() + " " + StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()) + "]");
        } else if (buffer.getData() != null) {
            b.append(" data=[" + buffer.getData() + "]");
        } else {
            b.append(" data=[null]");
        }
        return b.toString();
    }

    public static String bufferFlagsToStr(int flags) {
        ArrayList<String> strings = new ArrayList<String>();
        if ((flags & 1) != 0) {
            strings.add("FLAG_EOM");
        }
        if ((flags & 2) != 0) {
            strings.add("FLAG_DISCARD");
        }
        if ((flags & 4) != 0) {
            strings.add("FLAG_SILENCE");
        }
        if ((flags & 8) != 0) {
            strings.add("FLAG_SID");
        }
        if ((flags & 0x10) != 0) {
            strings.add("FLAG_KEY_FRAME");
        }
        if ((flags & 0x40) != 0) {
            strings.add("FLAG_NO_WAIT");
        }
        if ((flags & 0x60) != 0) {
            strings.add("FLAG_NO_SYNC");
        }
        if ((flags & 0x80) != 0) {
            strings.add("FLAG_SYSTEM_TIME");
        }
        if ((flags & 0x100) != 0) {
            strings.add("FLAG_RELATIVE_TIME");
        }
        if ((flags & 0x200) != 0) {
            strings.add("FLAG_FLUSH");
        }
        if ((flags & 0x400) != 0) {
            strings.add("FLAG_SYSTEM_MARKER");
        }
        if ((flags & 0x800) != 0) {
            strings.add("FLAG_RTP_MARKER");
        }
        if ((flags & 0x1000) != 0) {
            strings.add("FLAG_RTP_TIME");
        }
        if ((flags & 0x2000) != 0) {
            strings.add("FLAG_BUF_OVERFLOWN");
        }
        if ((flags & 0x4000) != 0) {
            strings.add("FLAG_BUF_UNDERFLOWN");
        }
        if ((flags & 0x8000) != 0) {
            strings.add("FLAG_LIVE_DATA");
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < strings.size(); ++i) {
            if (b.length() != 0) {
                b.append(" | ");
            }
            b.append(strings.get(i));
        }
        return b.toString();
    }
}

