/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ds.media.content.unknown;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.StandardControlPanel;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;
import net.sf.jdshow.Com;
import net.sf.jdshow.ComException;
import net.sf.jdshow.IGraphBuilder;
import net.sf.jdshow.IMediaControl;
import net.sf.jdshow.IMediaSeeking;
import net.sf.jdshow.IVideoWindow;
import net.sf.jdshow.JAWTUtils;
import net.sf.jdshow.WindowedRendering;

public class Handler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = true;
    private IGraphBuilder graphBuilder;
    private IMediaControl mediaControl;
    private IMediaSeeking mediaSeeking;
    private MyCanvas visualComponent;
    private boolean visualComponentBound = false;
    private Dimension videoSize;

    public void setSource(DataSource source) throws IncompatibleSourceException {
        logger.fine("DataSource: " + source);
        if (!source.getLocator().getProtocol().equals("file")) {
            throw new IncompatibleSourceException("Only file URLs supported: " + source);
        }
        String path = URLUtils.extractValidPathFromFileUrl(source.getLocator().toExternalForm());
        if (path == null) {
            throw new IncompatibleSourceException("Unable to extract valid file path from URL: " + source.getLocator().toExternalForm());
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (IOException e1) {
            String msg = "Unable to get canonical path from " + path + ": " + e1;
            logger.log(Level.WARNING, msg, e1);
            throw new IncompatibleSourceException(msg);
        }
        logger.info("Path: " + path);
        try {
            System.loadLibrary("jdshow");
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException();
        }
        this.visualComponent = new MyCanvas();
        this.visualComponent.addComponentListener(new MyComponentListener());
        try {
            Com.CoInitialize();
            long[] p = new long[1];
            int hr = Com.CoCreateInstance(Com.CLSID_FilterGraph, 0L, 23, Com.IID_IGraphBuilder, p);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            this.graphBuilder = new IGraphBuilder(p[0]);
            hr = this.graphBuilder.RenderFile(path, "");
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            hr = this.graphBuilder.QueryInterface(Com.IID_IMediaControl, p);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            this.mediaControl = new IMediaControl(p[0]);
            hr = this.graphBuilder.QueryInterface(Com.IID_IMediaSeeking, p);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            this.mediaSeeking = new IMediaSeeking(p[0]);
            hr = this.graphBuilder.QueryInterface(Com.IID_IVideoWindow, p);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            IVideoWindow videoWindow = new IVideoWindow(p[0]);
            long[] width = new long[1];
            hr = videoWindow.get_Width(width);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            long[] height = new long[1];
            hr = videoWindow.get_Height(height);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            this.videoSize = new Dimension((int)width[0], (int)height[0]);
            videoWindow.Release();
        }
        catch (ComException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new IncompatibleSourceException(e.getMessage());
        }
        super.setSource(source);
    }

    public void doPlayerClose() {
        logger.info("Handler.doPlayerClose");
    }

    public boolean doPlayerDeallocate() {
        logger.info("Handler.doPlayerDeallocate");
        this.mediaControl.Release();
        this.graphBuilder.Release();
        this.mediaSeeking.Release();
        Com.CoUninitialize();
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        return true;
    }

    public void doPlayerSetMediaTime(Time t) {
        logger.info("Handler.doPlayerSetMediaTime" + t);
        try {
            long[] current = new long[1];
            long[] stop = new long[1];
            int hr = this.mediaSeeking.GetPositions(current, stop);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
            current[0] = t.getNanoseconds() / 100L;
            hr = this.mediaSeeking.SetPositions(current, 1, stop, 0);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
        }
        catch (ComException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
    }

    public float doPlayerSetRate(float rate) {
        logger.info("Handler.doPlayerSetRate " + rate);
        try {
            int hr = this.mediaSeeking.SetRate(rate);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
        }
        catch (ComException e) {
            logger.log(Level.WARNING, "" + e, e);
            return this.getRate();
        }
        return rate;
    }

    public boolean doPlayerStop() {
        logger.info("Handler.doPlayerStop");
        this.mediaControl.Stop();
        return true;
    }

    public boolean doPlayerSyncStart(Time t) {
        logger.info("Handler.doPlayerSyncStart" + t);
        try {
            int hr = this.mediaControl.Run();
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
        }
        catch (ComException e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        if (this.mediaSeeking != null) {
            try {
                long[] duration = new long[1];
                int hr = this.mediaSeeking.GetDuration(duration);
                if (Com.FAILED(hr)) {
                    throw new ComException(hr);
                }
                return new Time(duration[0] * 100L);
            }
            catch (ComException e) {
                logger.log(Level.WARNING, "" + e, e);
                return DURATION_UNKNOWN;
            }
        }
        return DURATION_UNKNOWN;
    }

    public synchronized Time getMediaTime() {
        if (this.mediaSeeking != null) {
            try {
                long[] current = new long[1];
                int hr = this.mediaSeeking.GetCurrentPosition(current);
                if (Com.FAILED(hr)) {
                    throw new ComException(hr);
                }
                return new Time(current[0] * 100L);
            }
            catch (ComException e) {
                logger.log(Level.WARNING, "" + e, e);
                return DURATION_UNKNOWN;
            }
        }
        return super.getMediaTime();
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    private boolean bindVisualComponent() {
        if (this.visualComponentBound) {
            return false;
        }
        long hwnd = JAWTUtils.getWindowHandle(this.visualComponent);
        try {
            int hr = WindowedRendering.InitWindowedRendering2(hwnd, this.graphBuilder);
            if (Com.FAILED(hr)) {
                throw new ComException(hr);
            }
        }
        catch (ComException e) {
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        this.visualComponentBound = true;
        return true;
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = new StandardControlPanel(this, 67);
            this.setControlPanelComponent(c);
        }
        return c;
    }

    private class MyCanvas
    extends Canvas {
        private MyCanvas() {
        }

        public Dimension getPreferredSize() {
            if (Handler.this.videoSize == null) {
                return new Dimension(0, 0);
            }
            return Handler.this.videoSize;
        }
    }

    private class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
            logger.fine("componentHidden");
        }

        public void componentMoved(ComponentEvent e) {
            int x = 100;
            logger.fine("componentMoved: " + e.getID());
            Handler.this.bindVisualComponent();
        }

        public void componentResized(ComponentEvent e) {
            logger.fine("componentResized");
            Handler.this.bindVisualComponent();
        }

        public void componentShown(ComponentEvent e) {
            logger.fine("componentShown");
        }
    }
}

