/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.RateChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class RateControl
implements ActionListener,
ControllerListener,
Control {
    private JPanel controlComponent = new JPanel();
    private JTextField rateField = new JTextField(6);
    private Controller controller;

    public RateControl(Controller controller) {
        this.controller = controller;
        this.setUpControlComponent();
        SwingUtilities.invokeLater(new LoadRateThread());
        this.rateField.addActionListener(this);
        controller.addControllerListener(this);
    }

    private void setUpControlComponent() {
        JLabel rateLabel = new JLabel("Rate:", 4);
        JPanel mainPanel = new JPanel();
        int GAP = 10;
        EmptyBorder emptyBorder = new EmptyBorder(GAP, GAP, GAP, GAP);
        CompoundBorder etchedBorder = new CompoundBorder(new EtchedBorder(), emptyBorder);
        TitledBorder titledBorder = new TitledBorder(etchedBorder, "Rate Control");
        mainPanel.setBorder(titledBorder);
        mainPanel.setLayout(new BorderLayout(GAP, GAP));
        mainPanel.add((Component)rateLabel, "Center");
        mainPanel.add((Component)this.rateField, "East");
        this.controlComponent.add(mainPanel);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.rateField) {
            return;
        }
        try {
            String rateString = this.rateField.getText();
            float rate = Float.valueOf(rateString).floatValue();
            this.controller.setRate(rate);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.loadRate();
    }

    public void controllerUpdate(ControllerEvent e) {
        if (e.getSourceController() == this.controller && e instanceof RateChangeEvent) {
            SwingUtilities.invokeLater(new LoadRateThread());
        }
    }

    private void loadRate() {
        this.rateField.setText(Float.toString(this.controller.getRate()));
    }

    public Component getControlComponent() {
        return this.controlComponent;
    }

    class LoadRateThread
    implements Runnable {
        LoadRateThread() {
        }

        public void run() {
            RateControl.this.loadRate();
        }
    }
}

