/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controlpanel;

import java.awt.Component;
import java.awt.FlowLayout;
import javax.media.Player;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.sf.fmj.ejmf.toolkit.gui.controlpanel.AbstractControls;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractListenerControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;

public abstract class AbstractControlPanel
extends JPanel {
    public static final int USE_START_CONTROL = 1;
    public static final int USE_STOP_CONTROL = 2;
    public static final int USE_REVERSE_CONTROL = 4;
    public static final int USE_PAUSE_CONTROL = 8;
    public static final int USE_GAIN_CONTROL = 16;
    public static final int USE_FF_CONTROL = 32;
    public static final int USE_PROGRESS_CONTROL = 64;
    public static final int USE_GAINMETER_CONTROL = 128;
    private AbstractControls controls;
    private Player player;
    protected final Skin skin;

    protected AbstractControlPanel(Skin skin, Player player, int flags) {
        this.skin = skin;
        this.setControlPanelLayout();
        this.setControlPanelBorder();
        this.player = player;
        this.controls = this.createControls(player);
        this.addComponents(flags);
    }

    protected AbstractControlPanel(Skin skin, Player player) {
        this(skin, player, -1);
    }

    protected void setControlPanelBorder() {
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    protected void setControlPanelLayout() {
        FlowLayout flow = new FlowLayout();
        flow.setHgap(5);
        this.setLayout(flow);
    }

    protected abstract void addComponents(int var1);

    protected abstract AbstractControls createControls(Player var1);

    protected void removeControlComponents() {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            this.remove(i);
        }
    }

    protected void replaceControlComponent(Component c, Component withComponent) {
        int count = this.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (c != this.getComponent(i)) continue;
            this.replaceControlComponent(withComponent, i);
            break;
        }
    }

    protected void replaceControlComponent(Component withComponent, int atIndex) {
        this.remove(atIndex);
        this.add(withComponent, atIndex);
    }

    public AbstractListenerControl getControl(String name) {
        return this.controls.getControl(name);
    }

    protected AbstractControls getControls() {
        return this.controls;
    }
}

