/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.Controller;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;
import net.sf.fmj.ejmf.toolkit.media.event.ManagedControllerErrorEvent;

public abstract class AbstractPlayer
extends AbstractController
implements Player,
ControllerListener {
    private DataSource source;
    private Vector controllers = new Vector();
    private Time duration = new Time(0L);
    private ControllerErrorEvent controllerError;
    private GainControl gainControl;
    private Component visualComponent;
    private Component controlPanelComponent;

    public abstract boolean doPlayerRealize();

    public abstract boolean doPlayerPrefetch();

    public abstract boolean doPlayerSyncStart(Time var1);

    public abstract boolean doPlayerDeallocate();

    public abstract boolean doPlayerStop();

    public abstract void doPlayerClose();

    public abstract void doPlayerSetMediaTime(Time var1);

    public abstract float doPlayerSetRate(float var1);

    public abstract Time getPlayerStartLatency();

    public abstract Time getPlayerDuration();

    public final synchronized Time getDuration() {
        if (this.duration == null) {
            this.updateDuration();
        }
        return this.duration;
    }

    private final synchronized void updateDuration() {
        Time duration = this.getPlayerDuration();
        if (duration != DURATION_UNKNOWN) {
            int n = this.controllers.size();
            for (int i = 0; i < n; ++i) {
                Controller c = (Controller)this.controllers.elementAt(i);
                Time d = c.getDuration();
                if (d == DURATION_UNKNOWN) {
                    duration = d;
                    break;
                }
                if (duration == DURATION_UNBOUNDED || d != DURATION_UNBOUNDED && d.getNanoseconds() <= duration.getNanoseconds()) continue;
                duration = d;
            }
        }
        boolean newDuration = false;
        if (duration == DURATION_UNKNOWN || duration == DURATION_UNBOUNDED || this.duration == DURATION_UNKNOWN || this.duration == DURATION_UNBOUNDED) {
            if (this.duration != duration) {
                newDuration = true;
            }
        } else if (this.duration == null || duration.getNanoseconds() != this.duration.getNanoseconds()) {
            newDuration = true;
        }
        if (newDuration) {
            this.duration = duration;
            this.postEvent(new DurationUpdateEvent(this, duration));
        }
    }

    public synchronized void setMediaTime(Time t) {
        boolean isStarted;
        boolean bl = isStarted = this.getState() == 600;
        if (isStarted) {
            this.stopInRestart();
        }
        super.setMediaTime(t);
        if (isStarted) {
            this.start();
        }
    }

    public synchronized float setRate(float rate) {
        boolean isStarted;
        boolean bl = isStarted = this.getState() == 600;
        if (isStarted) {
            this.stopInRestart();
        }
        float newRate = super.setRate(rate);
        if (isStarted) {
            this.start();
        }
        return newRate;
    }

    public synchronized Time getStartLatency() {
        int currentState = this.getState();
        if (currentState == 100 || currentState == 200) {
            throw new NotRealizedError("Cannot get start latency from an Unrealized Controller");
        }
        Time latency = this.getPlayerStartLatency();
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller c = (Controller)this.controllers.elementAt(i);
            Time l = c.getStartLatency();
            if (l == LATENCY_UNKNOWN || latency != LATENCY_UNKNOWN && l.getNanoseconds() <= latency.getNanoseconds()) continue;
            latency = l;
        }
        return latency;
    }

    public final void start() {
        int state = this.getState();
        int target = this.getTargetState();
        if (state == 600) {
            this.postStartEvent();
            return;
        }
        if (target < 600) {
            this.setTargetState(600);
        }
        Thread thread = new Thread(){

            public void run() {
                if (AbstractPlayer.this.getState() < 600) {
                    AbstractPlayer.this.synchronousStart();
                }
            }
        };
        thread.setName("SynchronousStart Thread for " + this);
        this.getThreadQueue().addThread(thread);
    }

    public synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        if (this.controllers.contains(newController) || this == newController) {
            return;
        }
        int currentState = this.getState();
        if (currentState == 100 || currentState == 200) {
            throw new NotRealizedError("Cannot add Controller to an Unrealized Player");
        }
        if (currentState == 600) {
            throw new ClockStartedError("Cannot add Controller to a Started Player");
        }
        int controllerState = newController.getState();
        if (controllerState == 100 || controllerState == 200) {
            throw new NotRealizedError("Cannot add Unrealized Controller to a Player");
        }
        if (controllerState == 600) {
            throw new ClockStartedError("Cannot add Started Controller to a Player");
        }
        newController.setTimeBase(this.getTimeBase());
        this.stop();
        newController.stop();
        currentState = this.getState();
        controllerState = newController.getState();
        if (controllerState < 500 && currentState > 300) {
            this.deallocate();
        }
        newController.setMediaTime(this.getMediaTime());
        newController.setStopTime(Clock.RESET);
        float rate = this.getRate();
        if (rate != newController.setRate(rate)) {
            newController.setRate(1.0f);
            this.setRate(1.0f);
        }
        this.controllers.addElement(newController);
        newController.addControllerListener(this);
        this.updateDuration();
    }

    public synchronized void removeController(Controller oldController) {
        int currentState = this.getState();
        if (currentState == 100 || currentState == 200) {
            throw new NotRealizedError("Cannot remove Controller from an Unrealized Player");
        }
        if (currentState == 600) {
            throw new ClockStartedError("Cannot remove Controller from a Started Player");
        }
        if (this.controllers.indexOf(oldController) == -1) {
            return;
        }
        this.stop();
        this.controllers.removeElement(oldController);
        oldController.removeControllerListener(this);
        try {
            oldController.setTimeBase(null);
        }
        catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {
            // empty catch block
        }
        this.updateDuration();
    }

    protected Vector getControllers() {
        return (Vector)this.controllers.clone();
    }

    protected void setGainControl(GainControl c) {
        if (this.gainControl != null) {
            this.removeControl(this.gainControl);
        }
        this.addControl(c);
        this.gainControl = c;
    }

    public GainControl getGainControl() {
        int currentState = this.getState();
        if (currentState == 100 || currentState == 200) {
            throw new NotRealizedError("Cannot get gain control on an Unrealized Player");
        }
        return this.gainControl;
    }

    protected void setVisualComponent(Component c) {
        this.visualComponent = c;
    }

    public Component getVisualComponent() {
        int currentState = this.getState();
        if (currentState == 100 || currentState == 200) {
            throw new NotRealizedError("Cannot get visual Component on an Unrealized Player");
        }
        return this.visualComponent;
    }

    protected void setControlPanelComponent(Component c) {
        this.controlPanelComponent = c;
    }

    public Component getControlPanelComponent() {
        int currentState = this.getState();
        if (currentState == 100 || currentState == 200) {
            throw new NotRealizedError("Cannot get control panel Component on an Unrealized Player");
        }
        return this.controlPanelComponent;
    }

    public void setSource(DataSource source) throws IncompatibleSourceException {
        if (this.source != null) {
            throw new IncompatibleSourceException("Datasource already set in MediaHandler " + this.getClass().getName());
        }
        this.source = source;
    }

    public DataSource getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void controllerUpdate(ControllerEvent e) {
        Vector vector = this.controllers;
        synchronized (vector) {
            if (e instanceof TransitionEvent) {
                this.controllers.notifyAll();
            } else if (e instanceof ControllerErrorEvent) {
                this.setControllerError((ControllerErrorEvent)e);
                this.controllers.notifyAll();
            }
        }
    }

    public final boolean doRealize() {
        try {
            this.source.start();
        }
        catch (IOException e) {
            this.postEvent(new ResourceUnavailableEvent(this, "Could not start DataSource"));
            return false;
        }
        if (!this.doPlayerRealize()) {
            return false;
        }
        this.updateDuration();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doPrefetch() {
        this.resetControllerError();
        for (int i = 0; i < this.controllers.size(); ++i) {
            Controller c = (Controller)this.controllers.elementAt(i);
            c.prefetch();
        }
        if (!this.doPlayerPrefetch()) {
            return false;
        }
        Vector vector = this.controllers;
        synchronized (vector) {
            while (this.controllerError == null && !this.isStateReached(500)) {
                try {
                    this.controllers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        this.updateDuration();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doSyncStart(Time t) {
        this.resetControllerError();
        for (int i = 0; i < this.controllers.size(); ++i) {
            Controller c = (Controller)this.controllers.elementAt(i);
            c.syncStart(t);
        }
        if (!this.doPlayerSyncStart(t)) {
            return false;
        }
        Vector vector = this.controllers;
        synchronized (vector) {
            while (this.controllerError == null && !this.isStateReached(600)) {
                try {
                    this.controllers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        return true;
    }

    public final boolean doDeallocate() {
        int i;
        this.resetControllerError();
        int size = this.controllers.size();
        Thread[] threads = new Thread[size];
        for (i = 0; i < size; ++i) {
            final Controller c = (Controller)this.controllers.elementAt(i);
            threads[i] = new Thread(){

                public void run() {
                    c.deallocate();
                }
            };
            threads[i].start();
        }
        if (!this.doPlayerDeallocate()) {
            return false;
        }
        for (i = 0; i < size; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        return true;
    }

    public final boolean doStop() {
        int i;
        this.resetControllerError();
        int size = this.controllers.size();
        Thread[] threads = new Thread[size];
        for (i = 0; i < size; ++i) {
            final Controller c = (Controller)this.controllers.elementAt(i);
            threads[i] = new Thread(){

                public void run() {
                    c.stop();
                }
            };
            threads[i].start();
        }
        if (!this.doPlayerStop()) {
            return false;
        }
        for (i = 0; i < size; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.controllerError != null) {
            this.postManagedControllerErrorEvent();
            return false;
        }
        return true;
    }

    public final synchronized void doClose() {
        Vector controllers = this.getControllers();
        int n = controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller c = (Controller)controllers.elementAt(i);
            c.close();
        }
        try {
            this.source.stop();
            this.source.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.doPlayerClose();
        controllers = null;
        this.source = null;
        this.gainControl = null;
        this.controllerError = null;
    }

    public final synchronized void doSetMediaTime(Time t) {
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller c = (Controller)this.controllers.elementAt(i);
            c.setMediaTime(t);
        }
        this.doPlayerSetMediaTime(t);
    }

    public final synchronized float doSetRate(float rate) {
        float actual;
        int n = this.controllers.size();
        for (int i = 0; i < n; ++i) {
            Controller c = (Controller)this.controllers.elementAt(i);
            actual = c.setRate(rate);
            if (rate == 1.0f || actual == rate) continue;
            this.doSetRate(1.0f);
            return 1.0f;
        }
        actual = this.doPlayerSetRate(rate);
        if (!this.controllers.isEmpty() && rate != 1.0f && actual != rate) {
            this.doSetRate(1.0f);
            return 1.0f;
        }
        return actual;
    }

    private void setControllerError(ControllerErrorEvent e) {
        this.controllerError = e;
    }

    private void resetControllerError() {
        this.setControllerError(null);
    }

    private ControllerErrorEvent getControllerError() {
        return this.controllerError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStateReached(int state) {
        Vector vector = this.controllers;
        synchronized (vector) {
            int n = this.controllers.size();
            for (int i = 0; i < n; ++i) {
                Controller controller = (Controller)this.controllers.elementAt(i);
                if (controller.getState() >= state) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areControllersStopped() {
        Vector vector = this.controllers;
        synchronized (vector) {
            int n = this.controllers.size();
            for (int i = 0; i < n; ++i) {
                Controller controller = (Controller)this.controllers.elementAt(i);
                if (controller.getState() != 600) continue;
                return false;
            }
            return true;
        }
    }

    private void postManagedControllerErrorEvent() {
        String message = "Managing Player " + this.getClass().getName() + " received ControllerErrorEvent from " + this.controllerError.getSourceController().getClass().getName();
        this.postEvent(new ManagedControllerErrorEvent(this, this.controllerError, message));
        this.resetControllerError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endOfMedia() throws ClockStoppedException {
        Vector vector = this.controllers;
        synchronized (vector) {
            while (!this.areControllersStopped()) {
                try {
                    this.controllers.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        super.endOfMedia();
    }

    protected void synchronousStart() {
        if (this.getState() < 500) {
            this.synchronousPrefetch();
            if (this.getState() < 500) {
                return;
            }
        }
        this.synchronousSyncStart(this.getTimeBase().getTime());
    }
}

