/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import net.sf.fmj.utility.LoggerSingleton;

public class ControllerEventQueue
extends Thread {
    private static final Logger logger = LoggerSingleton.logger;
    Vector eventQueue = new Vector();
    Vector listeners;

    public ControllerEventQueue(Vector listeners, String threadName) {
        this.setName(threadName);
        this.listeners = listeners;
        this.setDaemon(true);
    }

    public synchronized void postEvent(ControllerEvent event) {
        this.eventQueue.addElement(event);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorEvents() {
        block5: while (true) {
            Vector v;
            ControllerEventQueue controllerEventQueue = this;
            synchronized (controllerEventQueue) {
                while (this.eventQueue.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                v = (Vector)this.eventQueue.clone();
                this.eventQueue.removeAllElements();
            }
            int i = 0;
            while (true) {
                if (i >= v.size()) continue block5;
                ControllerEvent event = (ControllerEvent)v.elementAt(i);
                this.dispatchEvent(event);
                ++i;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(ControllerEvent event) {
        Vector l;
        Vector vector = this.listeners;
        synchronized (vector) {
            l = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            Object o = l.elementAt(i);
            if (!(o instanceof ControllerListener)) continue;
            ControllerListener listener = (ControllerListener)o;
            try {
                listener.controllerUpdate(event);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception occurred during event dispatching:" + e, e);
            }
        }
    }

    public void run() {
        this.monitorEvents();
    }
}

