/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.RateChangeEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;

public class StopTimeMonitor
extends Thread
implements ControllerListener {
    private boolean wokenUp;
    private AbstractController controller;

    public StopTimeMonitor(AbstractController controller, String threadName) {
        this.setName(threadName);
        this.controller = controller;
        controller.addControllerListener(this);
        this.setDaemon(true);
    }

    public synchronized void controllerUpdate(ControllerEvent e) {
        if (e instanceof StopTimeChangeEvent || e instanceof RateChangeEvent || e instanceof MediaTimeSetEvent || e instanceof StartEvent || e instanceof StopEvent && !(e instanceof DeallocateEvent)) {
            this.wokenUp = true;
            this.notifyAll();
        }
    }

    private synchronized void monitorStopTime() {
        while (true) {
            long waittime;
            Time stopTime;
            if (this.controller.getState() != 600 || (stopTime = this.controller.getStopTime()) == Clock.RESET) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
                continue;
            }
            this.wokenUp = false;
            try {
                waittime = this.getWaitTime(stopTime);
            }
            catch (ClockStoppedException e) {
                continue;
            }
            if (waittime > 0L) {
                try {
                    this.wait(waittime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.wokenUp) continue;
            this.controller.stopAtTime();
            this.controller.setStopTime(Clock.RESET);
        }
    }

    private long getWaitTime(Time stopTime) throws ClockStoppedException {
        long stop = this.controller.mapToTimeBase(stopTime).getNanoseconds();
        long now = this.controller.getTimeBase().getNanoseconds();
        return (stop - now) / 1000000L;
    }

    public void run() {
        this.monitorStopTime();
    }
}

