/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import com.lti.utils.collections.Queue;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.AVUtilLibrary;
import net.sf.ffmpeg_java.FFMPEGLibrary;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolHandler;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolMgr;
import net.sf.fmj.ffmpeg_java.PullDataSourceCallbackURLProtocolHandler;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.utility.LoggerSingleton;

public class FFMPEGParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean PROCEED_IF_NO_AUDIO_CODEC = true;
    private final AVFormatLibrary AVFORMAT;
    private final AVCodecLibrary AVCODEC;
    private final AVUtilLibrary AVUTIL;
    private AVFormatLibrary.AVFormatContext formatCtx;
    private final boolean USE_DATASOURCE_URL_ONLY = false;
    private ContentDescriptor[] supportedInputContentDescriptors = null;
    static final String FIRST_FFMPEG_DEMUX_NAME = "aac";
    private static final Object AV_SYNC_OBJ = new Boolean(true);
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private Queue[] packetQueues;

    public FFMPEGParser() {
        try {
            this.AVFORMAT = AVFormatLibrary.INSTANCE;
            this.AVCODEC = AVCodecLibrary.INSTANCE;
            this.AVUTIL = AVUtilLibrary.INSTANCE;
            this.AVFORMAT.av_register_all();
            this.queryInputContentDescriptors();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to initialize ffmpeg libraries: " + t);
            throw new RuntimeException(t);
        }
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    protected void queryInputContentDescriptors() {
        ArrayList<ContentDescriptor> contentDescriptors = new ArrayList<ContentDescriptor>();
        int i = 1;
        AVFormatLibrary.AVInputFormat avInputFormat = this.AVFORMAT.av_find_input_format(FIRST_FFMPEG_DEMUX_NAME);
        while (avInputFormat != null) {
            String mimeType = null;
            AVFormatLibrary.AVOutputFormat avOutputFormat = this.AVFORMAT.guess_format(avInputFormat.name, null, null);
            mimeType = avOutputFormat != null && avOutputFormat.mime_type != null && avOutputFormat.mime_type.length() > 0 ? avOutputFormat.mime_type : "ffmpeg/" + avInputFormat.name;
            logger.log(Level.FINEST, i++ + ". " + avInputFormat.long_name + " : " + mimeType);
            contentDescriptors.add(new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType)));
            if (avInputFormat.next != null && avInputFormat.next.isValid()) {
                avInputFormat = new AVFormatLibrary.AVInputFormat(avInputFormat.next);
                continue;
            }
            avInputFormat = null;
        }
        contentDescriptors.add(new ContentDescriptor("video.quicktime"));
        contentDescriptors.add(new ContentDescriptor("video.x_ms_wmv"));
        contentDescriptors.add(new ContentDescriptor("video.mp4"));
        contentDescriptors.add(new ContentDescriptor("video.3gpp"));
        contentDescriptors.add(new ContentDescriptor("video.mp2p"));
        this.supportedInputContentDescriptors = contentDescriptors.toArray(new ContentDescriptor[0]);
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String protocol = source.getLocator().getProtocol();
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceUnavailableException {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            int i;
            String callbackURL;
            try {
                this.AVCODEC.avcodec_init();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "" + t, t);
                throw new ResourceUnavailableException("avcodec_init or av_register_all failed");
            }
            if (this.AVCODEC.avcodec_version() != 3352580) {
                logger.warning("ffmpeg-java and ffmpeg versions do not match: avcodec_version=" + this.AVCODEC.avcodec_version() + " LIBAVCODEC_VERSION_INT=" + 3352580);
            }
            CallbackURLProtocolMgr.register((AVFormatLibrary)this.AVFORMAT);
            String urlStr = callbackURL = CallbackURLProtocolMgr.addCallbackURLProtocolHandler((CallbackURLProtocolHandler)new PullDataSourceCallbackURLProtocolHandler(this.source));
            PointerByReference ppFormatCtx = new PointerByReference();
            int ret = this.AVFORMAT.av_open_input_file(ppFormatCtx, urlStr, null, 0, null);
            if (ret != 0) {
                throw new ResourceUnavailableException("av_open_input_file failed: " + ret);
            }
            this.formatCtx = new AVFormatLibrary.AVFormatContext(ppFormatCtx.getValue());
            if (this.AVFORMAT.av_find_stream_info(this.formatCtx) < 0) {
                throw new ResourceUnavailableException("Couldn't find stream information");
            }
            this.AVFORMAT.dump_format(this.formatCtx, 0, urlStr, 0);
            VideoTrack videoTrack = null;
            AudioTrack audioTrack = null;
            for (i = 0; i < this.formatCtx.nb_streams; ++i) {
                AVFormatLibrary.AVStream stream = new AVFormatLibrary.AVStream(this.formatCtx.getStreams()[i]);
                AVCodecLibrary.AVCodecContext codecCtx = new AVCodecLibrary.AVCodecContext(stream.codec);
                if (codecCtx.codec_id == 0) {
                    logger.info("Codec id is zero (no codec) - skipping stream " + i);
                    continue;
                }
                if (codecCtx.codec_type == 0 && videoTrack == null) {
                    videoTrack = new VideoTrack(i, stream, codecCtx);
                    continue;
                }
                if (codecCtx.codec_type != 1 || audioTrack != null) continue;
                try {
                    audioTrack = new AudioTrack(i, stream, codecCtx);
                    continue;
                }
                catch (ResourceUnavailableException e) {
                    logger.log(Level.WARNING, "Skipping audio track: " + e, e);
                }
            }
            if (audioTrack == null && videoTrack == null) {
                throw new ResourceUnavailableException("No audio or video track found");
            }
            this.tracks = audioTrack != null && videoTrack != null ? new PullSourceStreamTrack[]{videoTrack, audioTrack} : (audioTrack != null ? new PullSourceStreamTrack[]{audioTrack} : new PullSourceStreamTrack[]{videoTrack});
            this.packetQueues = new Queue[this.formatCtx.nb_streams];
            for (i = 0; i < this.packetQueues.length; ++i) {
                this.packetQueues[i] = new Queue();
            }
        }
        super.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            if (this.tracks != null) {
                for (int i = 0; i < this.tracks.length; ++i) {
                    if (this.tracks[i] == null) continue;
                    this.tracks[i].deallocate();
                    this.tracks[i] = null;
                }
                this.tracks = null;
            }
            if (this.formatCtx != null) {
                this.AVFORMAT.av_close_input_file(this.formatCtx);
                this.formatCtx = null;
            }
        }
        super.close();
    }

    public void start() throws IOException {
    }

    public boolean isPositionable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time setPosition(Time where, int rounding) {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            int result = this.AVFORMAT.av_seek_frame(this.formatCtx, -1, where.getNanoseconds() / 1000L, 0);
            if (result < 0) {
                logger.severe("av_seek_frame failed with code " + result);
            }
            return where;
        }
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public static VideoFormat convertCodecPixelFormat(int pixFmt, int width, int height, double frameRate) {
        if (pixFmt != 2) {
            throw new IllegalArgumentException();
        }
        int bitsPerPixel = 24;
        int red = 1;
        int green = 2;
        int blue = 3;
        return new RGBFormat(new Dimension(width, height), -1, byte[].class, (float)frameRate, bitsPerPixel, red, green, blue);
    }

    static FFMPEGLibrary.AVRational getTimeBase(AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) {
        if (stream.r_frame_rate.num != 0 && stream.r_frame_rate.den != 0) {
            FFMPEGLibrary.AVRational result = new FFMPEGLibrary.AVRational();
            result.num = stream.r_frame_rate.den;
            result.den = stream.r_frame_rate.num;
            return result;
        }
        if (stream.time_base.num != 0 && stream.time_base.den != 0) {
            return stream.time_base;
        }
        return codecCtx.time_base;
    }

    static double getFPS(AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) {
        FFMPEGLibrary.AVRational time_base = FFMPEGParser.getTimeBase(stream, codecCtx);
        return (double)time_base.den / (double)time_base.num;
    }

    static long getTimestamp(AVCodecLibrary.AVFrame frame, AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx, long frameNo, long packetDts) {
        FFMPEGLibrary.AVRational time_base = FFMPEGParser.getTimeBase(stream, codecCtx);
        if (packetDts == Long.MIN_VALUE) {
            return 1000000000L * frameNo * (long)time_base.num / (long)time_base.den;
        }
        return 1000000000L * frameNo * (long)time_base.num / (long)time_base.den;
    }

    public static AudioFormat convertCodecAudioFormat(AVCodecLibrary.AVCodecContext codecCtx) {
        return new AudioFormat("LINEAR", codecCtx.sample_rate, 16, codecCtx.channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AVFormatLibrary.AVPacket nextPacket(int streamIndex) {
        Object object = AV_SYNC_OBJ;
        synchronized (object) {
            AVFormatLibrary.AVPacket packet;
            if (!this.packetQueues[streamIndex].isEmpty()) {
                return (AVFormatLibrary.AVPacket)this.packetQueues[streamIndex].dequeue();
            }
            while (this.AVFORMAT.av_read_frame(this.formatCtx, packet = new AVFormatLibrary.AVPacket()) >= 0) {
                if (packet.stream_index == streamIndex) {
                    return packet;
                }
                this.packetQueues[packet.stream_index].enqueue(packet);
            }
            return null;
        }
    }

    private class AudioTrack
    extends PullSourceStreamTrack {
        private final int audioStreamIndex;
        AVFormatLibrary.AVStream stream;
        private AVCodecLibrary.AVCodecContext codecCtx;
        private final AVCodecLibrary.AVCodec codec;
        private Pointer buffer;
        private int bufferSize;
        private final AudioFormat format;
        private long frameNo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AudioTrack(int audioStreamIndex, AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) throws ResourceUnavailableException {
            this.audioStreamIndex = audioStreamIndex;
            this.stream = stream;
            this.codecCtx = codecCtx;
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                this.codec = FFMPEGParser.this.AVCODEC.avcodec_find_decoder(codecCtx.codec_id);
                if (this.codec == null) {
                    throw new ResourceUnavailableException("Codec not found for codec_id " + codecCtx.codec_id + " (0x" + Integer.toHexString(codecCtx.codec_id) + ")");
                }
                if (FFMPEGParser.this.AVCODEC.avcodec_open(codecCtx, this.codec) < 0) {
                    throw new ResourceUnavailableException("Could not open codec");
                }
                this.bufferSize = 192000;
                this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(this.bufferSize);
                this.format = FFMPEGParser.convertCodecAudioFormat(codecCtx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deallocate() {
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                if (this.codecCtx != null) {
                    FFMPEGParser.this.AVCODEC.avcodec_close(this.codecCtx);
                    this.codecCtx = null;
                }
                if (this.buffer != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                    this.buffer = null;
                }
            }
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            AVFormatLibrary.AVPacket packet = FFMPEGParser.this.nextPacket(this.audioStreamIndex);
            if (packet != null) {
                Object object = AV_SYNC_OBJ;
                synchronized (object) {
                    IntByReference frameSize = new IntByReference();
                    frameSize.setValue(this.bufferSize);
                    FFMPEGParser.this.AVCODEC.avcodec_decode_audio2(this.codecCtx, this.buffer, frameSize, packet.data, packet.size);
                    if (frameSize.getValue() < 0) {
                        throw new RuntimeException("Failed to read audio frame");
                    }
                    if (frameSize.getValue() > 0) {
                        if (frameSize.getValue() > this.bufferSize) {
                            FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                            this.bufferSize = frameSize.getValue();
                            this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(this.bufferSize);
                        }
                        byte[] data = this.buffer.getByteArray(0, frameSize.getValue());
                        buffer.setData(data);
                        buffer.setLength(data.length);
                        buffer.setOffset(0);
                        buffer.setEOM(false);
                        buffer.setDiscard(false);
                        buffer.setTimeStamp(System.currentTimeMillis());
                    } else {
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                    }
                    if (packet.destruct != null) {
                        packet.destruct.callback(packet);
                    }
                }
            } else {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            if (((FFMPEGParser)FFMPEGParser.this).formatCtx.duration <= 0L) {
                return Duration.DURATION_UNKNOWN;
            }
            return new Time(((FFMPEGParser)FFMPEGParser.this).formatCtx.duration * 1000L);
        }
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final int videoStreamIndex;
        private AVFormatLibrary.AVStream stream;
        private AVCodecLibrary.AVCodecContext codecCtx;
        private AVCodecLibrary.AVCodec codec;
        private AVCodecLibrary.AVFrame frame;
        private AVCodecLibrary.AVFrame frameRGB;
        private final VideoFormat format;
        private Pointer buffer;
        private long frameNo;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VideoTrack(int videoStreamIndex, AVFormatLibrary.AVStream stream, AVCodecLibrary.AVCodecContext codecCtx) throws ResourceUnavailableException {
            this.videoStreamIndex = videoStreamIndex;
            this.stream = stream;
            this.codecCtx = codecCtx;
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                this.codec = FFMPEGParser.this.AVCODEC.avcodec_find_decoder(codecCtx.codec_id);
                if (this.codec == null) {
                    throw new ResourceUnavailableException("Codec not found for codec_id " + codecCtx.codec_id + " (0x" + Integer.toHexString(codecCtx.codec_id) + ")");
                }
                if (FFMPEGParser.this.AVCODEC.avcodec_open(codecCtx, this.codec) < 0) {
                    throw new ResourceUnavailableException("Could not open codec");
                }
                this.frame = FFMPEGParser.this.AVCODEC.avcodec_alloc_frame();
                if (this.frame == null) {
                    throw new ResourceUnavailableException("Could not allocate frame");
                }
                this.frameRGB = FFMPEGParser.this.AVCODEC.avcodec_alloc_frame();
                if (this.frameRGB == null) {
                    throw new ResourceUnavailableException("Could not allocate frame");
                }
                int numBytes = FFMPEGParser.this.AVCODEC.avpicture_get_size(2, codecCtx.width, codecCtx.height);
                this.buffer = FFMPEGParser.this.AVUTIL.av_malloc(numBytes);
                FFMPEGParser.this.AVCODEC.avpicture_fill(this.frameRGB, this.buffer, 2, codecCtx.width, codecCtx.height);
                this.format = FFMPEGParser.convertCodecPixelFormat(2, codecCtx.width, codecCtx.height, FFMPEGParser.getFPS(stream, codecCtx));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deallocate() {
            Object object = AV_SYNC_OBJ;
            synchronized (object) {
                if (this.codecCtx != null) {
                    FFMPEGParser.this.AVCODEC.avcodec_close(this.codecCtx);
                    this.codecCtx = null;
                }
                if (this.frameRGB != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.frameRGB.getPointer());
                    this.frameRGB = null;
                }
                if (this.frame != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.frame.getPointer());
                    this.frame = null;
                }
                if (this.buffer != null) {
                    FFMPEGParser.this.AVUTIL.av_free(this.buffer);
                    this.buffer = null;
                }
            }
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            long dts = -1L;
            AVFormatLibrary.AVPacket packet = FFMPEGParser.this.nextPacket(this.videoStreamIndex);
            if (packet != null) {
                Object object = AV_SYNC_OBJ;
                synchronized (object) {
                    IntByReference frameFinished = new IntByReference();
                    FFMPEGParser.this.AVCODEC.avcodec_decode_video(this.codecCtx, this.frame, frameFinished, packet.data, packet.size);
                    if (dts == -1L || packet.dts < dts) {
                        dts = packet.dts;
                    }
                    if (frameFinished.getValue() != 0) {
                        FFMPEGParser.this.AVCODEC.img_convert(this.frameRGB, 2, this.frame, this.codecCtx.pix_fmt, this.codecCtx.width, this.codecCtx.height);
                        byte[] data = this.frameRGB.data0.getByteArray(0, this.codecCtx.height * this.frameRGB.linesize[0]);
                        buffer.setData(data);
                        buffer.setLength(data.length);
                        buffer.setOffset(0);
                        buffer.setEOM(false);
                        buffer.setDiscard(false);
                        buffer.setTimeStamp(FFMPEGParser.getTimestamp(this.frame, this.stream, this.codecCtx, this.frameNo++, dts));
                        dts = -1L;
                    } else {
                        buffer.setLength(0);
                        buffer.setDiscard(true);
                    }
                    if (packet.destruct != null) {
                        packet.destruct.callback(packet);
                    }
                }
            } else {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public Time getDuration() {
            if (((FFMPEGParser)FFMPEGParser.this).formatCtx.duration <= 0L) {
                return Duration.DURATION_UNKNOWN;
            }
            return new Time(((FFMPEGParser)FFMPEGParser.this).formatCtx.duration * 1000L);
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

