/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import java.awt.Dimension;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.JPEGFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.AVUtilLibrary;
import net.sf.fmj.utility.LoggerSingleton;

public class ListFormats {
    private static final Logger logger = LoggerSingleton.logger;
    static final int CODEC_TYPE_UNKNOWN = -1;
    static final int CODEC_TYPE_VIDEO = 0;
    static final int CODEC_TYPE_AUDIO = 1;
    static final int CODEC_TYPE_DATA = 2;
    static final int CODEC_TYPE_SUBTITLE = 3;
    static final int CODEC_TYPE_NB = 4;
    static final AVFormatLibrary AVFORMAT = AVFormatLibrary.INSTANCE;
    static final AVCodecLibrary AVCODEC = AVCodecLibrary.INSTANCE;
    static final AVUtilLibrary AVUTIL = AVUtilLibrary.INSTANCE;
    static final String FIRST_FFMPEG_MUX_NAME = "ac3";
    static final String FIRST_FFMPEG_DECODER_NAME = "aasc";
    static final String FIRST_FFMPEG_ENCODER_NAME = "asv1";
    static final int JPEG_QUALITY = 100;

    public static void main(String[] args) throws Exception {
        AVFORMAT.av_register_all();
        ListFormats.listMuxes();
        ListFormats.listDecoder();
        ListFormats.listEncoder();
    }

    public static ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formats) {
        List contentDescriptors = ListFormats.listMuxes();
        return contentDescriptors.toArray(new ContentDescriptor[0]);
    }

    static List listMuxes() {
        ArrayList<String> contentDescriptors = new ArrayList<String>();
        int i = 1;
        AVFormatLibrary.AVOutputFormat avOutputFormat = AVFORMAT.guess_format(FIRST_FFMPEG_MUX_NAME, null, null);
        while (avOutputFormat != null) {
            String mimeType = null;
            mimeType = avOutputFormat.mime_type != null && avOutputFormat.mime_type.length() > 0 ? avOutputFormat.mime_type : "ffmpeg/" + avOutputFormat.name;
            System.out.println(i++ + ". " + avOutputFormat.name + " - " + avOutputFormat.long_name + " : " + mimeType);
            logger.log(Level.FINEST, i++ + ". " + avOutputFormat.name + " - " + avOutputFormat.long_name + " : " + mimeType);
            contentDescriptors.add(ContentDescriptor.mimeTypeToPackageName(mimeType));
            if (avOutputFormat.next != null && avOutputFormat.next.isValid()) {
                avOutputFormat = new AVFormatLibrary.AVOutputFormat(avOutputFormat.next);
                continue;
            }
            avOutputFormat = null;
        }
        return contentDescriptors;
    }

    static void listDecoder() {
        int i = 1;
        AVCodecLibrary.AVCodec avCodec = AVCODEC.avcodec_find_decoder_by_name(FIRST_FFMPEG_DECODER_NAME);
        while (avCodec != null) {
            logger.log(Level.FINEST, i++ + ". " + avCodec.name + " (" + ListFormats.getCodecType(avCodec.type) + ")");
            if (avCodec.next != null && avCodec.next.isValid()) {
                avCodec = new AVCodecLibrary.AVCodec(avCodec.next);
                continue;
            }
            avCodec = null;
        }
    }

    static void listEncoder() {
        int i = 1;
        AVCodecLibrary.AVCodec avCodec = AVCODEC.avcodec_find_decoder_by_name(FIRST_FFMPEG_ENCODER_NAME);
        while (avCodec != null) {
            logger.log(Level.FINEST, i++ + ". " + avCodec.name + " (" + ListFormats.getCodecType(avCodec.type) + ")");
            if (avCodec.next != null && avCodec.next.isValid()) {
                avCodec = new AVCodecLibrary.AVCodec(avCodec.next);
                continue;
            }
            avCodec = null;
        }
    }

    protected static String getCodecType(int codecType) {
        String result = null;
        switch (codecType) {
            case -1: {
                result = "unknown";
                break;
            }
            case 0: {
                result = "video";
                break;
            }
            case 1: {
                result = "audio";
                break;
            }
            case 2: {
                result = "data";
                break;
            }
            case 3: {
                result = "subtitle";
                break;
            }
            case 4: {
                result = "nb";
            }
        }
        return result;
    }

    public static VideoFormat convertCodecPixelFormat(int pixFmt, int width, int height) {
        VideoFormat result = null;
        switch (pixFmt) {
            case -1: {
                throw new IllegalArgumentException();
            }
            case 0: {
                result = new YUVFormat(2);
                break;
            }
            case 1: {
                throw new IllegalArgumentException();
            }
            case 2: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 24;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 3: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 24;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 4: {
                result = new YUVFormat(4);
                break;
            }
            case 5: {
                throw new IllegalArgumentException();
            }
            case 6: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 32;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 4;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 7: {
                throw new IllegalArgumentException();
            }
            case 8: {
                result = new YUVFormat(1);
                break;
            }
            case 9: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 16;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 2;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 10: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 16;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 2;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 11: {
                int red = 255;
                int green = 255;
                int blue = 255;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 12: {
                int red = 1;
                int green = 1;
                int blue = 1;
                int bitsPerPixel = 1;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 13: {
                int red = 1;
                int green = 1;
                int blue = 1;
                int bitsPerPixel = 1;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 14: {
                throw new IllegalArgumentException();
            }
            case 15: {
                result = new JPEGFormat(new Dimension(width, height), -1, byte[].class, 1.0f, 100, 1);
                break;
            }
            case 16: {
                result = new JPEGFormat(new Dimension(width, height), -1, byte[].class, 1.0f, 100, 0);
                break;
            }
            case 17: {
                result = new JPEGFormat(new Dimension(width, height), -1, byte[].class, 1.0f, 100, 2);
                break;
            }
            case 18: {
                throw new IllegalArgumentException();
            }
            case 19: {
                throw new IllegalArgumentException();
            }
            case 20: {
                throw new IllegalArgumentException();
            }
            case 21: {
                throw new IllegalArgumentException();
            }
            case 22: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 32;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 4;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 23: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 16;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 2;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 24: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 16;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 2;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 25: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 26: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 4;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 27: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 28: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 29: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 4;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 30: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
                break;
            }
            case 31: {
                throw new IllegalArgumentException();
            }
            case 32: {
                throw new IllegalArgumentException();
            }
            case 33: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 32;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 4;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 34: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 32;
                int endianess = ListFormats.getCpuEndianess();
                int pixelStride = 4;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 35: {
                int red = 65535;
                int green = 65535;
                int blue = 65535;
                int bitsPerPixel = 16;
                int pixelStride = 2;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, 0);
                break;
            }
            case 36: {
                int red = 65535;
                int green = 65535;
                int blue = 65535;
                int bitsPerPixel = 16;
                int pixelStride = 2;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, 1);
                break;
            }
            case 37: {
                throw new IllegalArgumentException();
            }
            case 38: {
                throw new IllegalArgumentException();
            }
            case 39: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    public static AudioFormat convertCodecAudioFormat(AVCodecLibrary.AVCodecContext codecCtx) {
        return new AudioFormat("LINEAR", codecCtx.sample_rate, 16, codecCtx.channels);
    }

    public static final int getCpuEndianess() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()) ? 0 : 1;
    }

    public static VideoFormat convertCodecPixelFormat2(int pixFmt, int width, int height) {
        if (pixFmt != 2) {
            throw new IllegalArgumentException();
        }
        int bitsPerPixel = 24;
        int red = 1;
        int green = 2;
        int blue = 3;
        return new RGBFormat(new Dimension(width, height), -1, byte[].class, 1.0f, bitsPerPixel, red, green, blue);
    }
}

