/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import com.sun.jna.Pointer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.custom_protocol.CallbackURLProtocolHandler;
import net.sf.fmj.utility.LoggerSingleton;

public class PullDataSourceCallbackURLProtocolHandler
implements CallbackURLProtocolHandler {
    private static final Logger logger = LoggerSingleton.logger;
    private PullDataSource source;
    private PullSourceStream pss;
    private long curpos;
    public static final boolean TRACE = false;
    private boolean mustClone = false;
    private final boolean isSourceCloneable;
    private boolean opened = false;

    public PullDataSourceCallbackURLProtocolHandler(PullDataSource source) {
        this.source = source;
        this.isSourceCloneable = source instanceof SourceCloneable;
    }

    public int open(AVFormatLibrary.URLContext h, String filename, int flags) {
        if ((flags & 2) != 0) {
            logger.severe("PullSourceStreamCallbackURLProtocolHandler: only read-only open supported");
            return -1;
        }
        if ((flags & 1) != 0) {
            logger.severe("PullSourceStreamCallbackURLProtocolHandler: only read-only open supported");
            return -1;
        }
        try {
            this.doOpen();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return -1;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "" + e, e);
            return -1;
        }
        return 0;
    }

    private void doOpen() throws IOException {
        if (this.opened) {
            return;
        }
        if (this.mustClone) {
            if (!this.isSourceCloneable) {
                logger.severe("PullSourceStreamCallbackURLProtocolHandler: cannot reopen because source is not SourceCloneable");
                throw new IOException("not SourceCloneable");
            }
            this.source = (PullDataSource)((SourceCloneable)((Object)this.source)).createClone();
        }
        this.source.connect();
        this.source.start();
        PullSourceStream[] pullSourceStreams = this.source.getStreams();
        if (pullSourceStreams.length < 1) {
            logger.warning("No streams");
            throw new IOException("No streams");
        }
        this.pss = pullSourceStreams[0];
        this.curpos = 0L;
        this.opened = true;
    }

    private void closeAndReopen() throws IOException {
        this.doClose();
        this.doOpen();
    }

    public int read(AVFormatLibrary.URLContext h, Pointer buf, int size) {
        byte[] ba = new byte[size];
        try {
            if (!this.opened) {
                logger.warning("Attempt to read with closed stream");
                return -1;
            }
            int ret = this.pss.read(ba, 0, size);
            buf.write(0, ba, 0, size);
            this.curpos += (long)ret;
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return -1;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "" + e, e);
            return -1;
        }
    }

    public int write(AVFormatLibrary.URLContext h, Pointer buf, int size) {
        logger.severe("write not supported");
        return -1;
    }

    public long seek(AVFormatLibrary.URLContext h, long pos, int whence) {
        if (whence == 65536) {
            long ret = this.pss.getContentLength();
            return ret;
        }
        if (whence == 2 && this.pss.getContentLength() < 0L) {
            return -1L;
        }
        boolean isSeekable = this.pss instanceof Seekable;
        try {
            long ret;
            long seekTo;
            if (!isSeekable) {
                if (whence == 2) {
                    whence = 0;
                    pos += this.pss.getContentLength();
                }
                if (whence == 1) {
                    whence = 0;
                    pos += this.curpos;
                }
                if (whence == 0) {
                    if (this.pss.getContentLength() > 0L && pos >= this.pss.getContentLength()) {
                        this.doClose();
                        this.curpos = pos;
                        return this.curpos;
                    }
                    if (pos >= this.curpos) {
                        whence = 1;
                        pos -= this.curpos;
                    } else {
                        whence = 1;
                        this.closeAndReopen();
                    }
                }
                if (whence == 1) {
                    byte[] b = new byte[1];
                    int i = 0;
                    while ((long)i < pos) {
                        if (this.pss.read(b, 0, 1) < 0) {
                            logger.warning("attempt to seek past end of stream");
                            return -1L;
                        }
                        ++this.curpos;
                        ++i;
                    }
                    return this.curpos;
                }
            }
            if (!isSeekable) {
                return -1L;
            }
            Seekable seekable = (Seekable)((Object)this.pss);
            if (whence == 0) {
                seekTo = pos;
            } else if (whence == 1) {
                seekTo = this.curpos + pos;
            } else if (whence == 2) {
                if (this.pss.getContentLength() < 0L) {
                    return -1L;
                }
                seekTo = this.pss.getContentLength() + pos;
            } else {
                logger.warning("seek: Invalid whence value: " + whence);
                return -1L;
            }
            this.curpos = ret = seekable.seek(seekTo);
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return -1L;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "" + e, e);
            return -1L;
        }
    }

    public int close(AVFormatLibrary.URLContext h) {
        try {
            this.doClose();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            return -1;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "" + e, e);
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() throws IOException {
        if (!this.opened) {
            return;
        }
        try {
            this.source.stop();
            this.source.disconnect();
        }
        finally {
            this.mustClone = true;
            this.opened = false;
        }
    }
}

