/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.ResourceUnavailableException;
import net.sf.fmj.codegen.MediaCGUtils;
import net.sf.fmj.filtergraph.FilterGraphNode;

public class CodecNode
extends FilterGraphNode {
    private final Format inputFormat;
    private final Codec codec;

    public CodecNode(Codec codec, Format inputFormat) {
        super(codec);
        this.inputFormat = inputFormat;
        this.codec = codec;
    }

    public FilterGraphNode duplicate() {
        return this.propagateDuplicate(new CodecNode(this.getCodec(), this.getInputFormat()));
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void open() throws ResourceUnavailableException {
        this.getCodec().open();
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        int processResult;
        if (input.getLength() == 0 && input.getData() == null) {
            logger.warning("Skipping processing of codec input buffer with length 0 and null buffer");
            return 4;
        }
        if (input.getFormat() == null) {
            input.setFormat(this.getInputFormat());
        }
        if (this.getOutputBuffer(0) == null) {
            this.setOutputBuffer(0, new Buffer());
        }
        Buffer buffer1 = this.getOutputBuffer(0);
        buffer1.setLength(0);
        buffer1.setTimeStamp(input.getTimeStamp());
        buffer1.setFlags(0);
        if (buffer1.getFormat() == null) {
            buffer1.setFormat(this.getDestLink(0).getDestNode().getInputFormat());
        }
        buffer1.setSequenceNumber(input.getSequenceNumber());
        try {
            processResult = this.getCodec().process(input, buffer1);
        }
        catch (NullPointerException e) {
            System.out.println(MediaCGUtils.bufferToStr(input));
            System.out.println(MediaCGUtils.bufferToStr(buffer1));
            e.printStackTrace();
            throw e;
        }
        if (processResult != 0) {
            if (processResult == 4) {
                logger.finer("Codec process result for " + this.getCodec() + ": " + processResult);
            } else if (processResult == 2) {
                logger.finer("Codec process result for " + this.getCodec() + ": " + processResult);
            } else {
                logger.warning("Codec process result for " + this.getCodec() + ": " + MediaCGUtils.plugInResultToStr(processResult));
            }
        }
        return processResult;
    }

    public PlugIn getPlugIn() {
        return this.codec;
    }
}

