/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.Track;
import net.sf.fmj.filtergraph.FilterGraphLink;
import net.sf.fmj.filtergraph.FilterGraphNode;

public class DemuxNode
extends FilterGraphNode {
    private final Format inputFormat;
    private final Demultiplexer demux;
    private Track[] tracks;
    public long sequenceNumber = 0L;

    public DemuxNode(Format format, Demultiplexer demux, Track[] tracks) {
        super(demux);
        this.inputFormat = format;
        this.demux = demux;
        this.setTracks(tracks);
    }

    public FilterGraphNode duplicate() {
        return this.propagateDuplicate(new DemuxNode(this.getInputFormat(), this.getDemux(), this.getTracks()));
    }

    public void setTracks(Track[] tracks) {
        this.tracks = tracks;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public Format getInputFormat() {
        return this.inputFormat;
    }

    public Demultiplexer getDemux() {
        return this.demux;
    }

    public void open() throws ResourceUnavailableException {
        this.getDemux().open();
    }

    public void start() throws IOException {
        this.getDemux().start();
    }

    public void stop() {
        this.getDemux().stop();
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        for (int i = 0; i < this.getTracks().length; ++i) {
            FilterGraphLink destLink;
            if (sourceTrackNumber >= 0 && i != sourceTrackNumber || (destLink = this.getDestLink(i)) == null || (flags & 1) != 0) continue;
            if (this.getOutputBuffer(i) == null) {
                this.setOutputBuffer(i, new Buffer());
            }
            Buffer buffer1 = this.getOutputBuffer(i);
            buffer1.setLength(0);
            buffer1.setSequenceNumber(this.sequenceNumber++);
            buffer1.setFlags(0);
            this.getTracks()[i].readFrame(buffer1);
            if (buffer1.getFormat() != null) continue;
            buffer1.setFormat(this.getTracks()[i].getFormat());
        }
        return 0;
    }
}

